
if isfield(DSer,'SIntv')
	if (strcmp(DSer.SIntvUnit, 's')	)
		sps = 1/DSer.SIntv;
	else
		sps = 1000/DSer.SIntv;
	end
else
	if isfield(DSer,'SPSec')
		sps = DSer.SPSec;
	end
end
xx = 0:1/sps:(DSer.NSamp-1)/sps;
yy = DSer.Vals;

if exist('Evt')
	if isfield(Evt(1).Hypo(1),'OTime')
		event = Evt(1).Hypo(1).OTime.DTime;
 	elseif isfield(Evt(1).Hypo(1),'Id')
		event = Evt(1).Hypo(1).Id;
	end
 elseif isfield(DSer.FSTime,'DTime')
	event = DSer.FSTime.DTime;
 else
	event = 'Unk event';
end

if isfield (GLoc.Name(1), 'SName')
	stn = GLoc.Name(1).SName;
elseif isfield (GLoc.Name(1),'SNCL')
	stn = GLoc.Name(1).SNCL;
elseif isfield (GLoc.Name(1),'Desc')
	stn = GLoc.Name(1).Desc;
elseif isfield(GLoc.Site.Code(1), 'TVal')
	stn = GLoc.Site.Code(1).TVal;
else
	stn = 'unk';
end
	
if isfield(Sens.Incl, 'Val')		
	if Sens.Incl.Val == 90
		orient = [num2str(Sens.Azim.Val),'\circ'];
	elseif Sens.Incl.Val == 180
		orient ='Down';
	elseif Sens.Incl.Val == 0
		orient = 'Up';
	else
		orient = 'unk';
	end
end

plot(xx,yy)
xlabel('Time (s)')
ylabel(DSer.U1)
title([DSer.PPara,'  ',stn,' Orient:', orient,' Event:',event]);