/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.cosmos.csmml.StrongMotion;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class xmlIO {
    private Marshaller mar = null;
    private Unmarshaller um = null;
    private JAXBContext jc = null;

    public xmlIO() {
        try {
            this.jc = JAXBContext.newInstance((String)"org.cosmos.csmml");
            this.um = this.jc.createUnmarshaller();
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ClassLoader cl = this.getClass().getClassLoader();
            Schema schema = sf.newSchema(cl.getResource("xsd/csmml.xsd"));
            if (schema == null) {
                System.out.println("Did not find schema.");
            }
            this.um.setSchema(schema);
            this.mar = this.jc.createMarshaller();
            this.mar.setSchema(schema);
            this.mar.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.mar.setProperty("jaxb.encoding", (Object)"UTF-8");
        }
        catch (Exception e) {
            System.err.println("error creating JAXB context: " + e.toString());
        }
    }

    public xmlIO(boolean validation) {
        try {
            this.jc = JAXBContext.newInstance((String)"org.cosmos.csmml");
            this.um = this.jc.createUnmarshaller();
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ClassLoader cl = this.getClass().getClassLoader();
            Schema schema = sf.newSchema(cl.getResource("xsd/csmml.xsd"));
            if (validation) {
                this.um.setSchema(schema);
                this.mar = this.jc.createMarshaller();
                this.mar.setSchema(schema);
            } else {
                this.um.setSchema(null);
                this.mar = this.jc.createMarshaller();
                this.mar.setSchema(null);
            }
            this.mar.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.mar.setProperty("jaxb.encoding", (Object)"UTF-8");
        }
        catch (Exception e) {
            System.err.println("error creating JAXB context: " + e.toString());
        }
    }

    public StrongMotion readStrongMotionXML(String infilename) {
        try {
            return (StrongMotion)this.um.unmarshal((InputStream)new FileInputStream(infilename));
        }
        catch (JAXBException e) {
            System.err.println("error unmarshalling: " + e.toString());
        }
        catch (FileNotFoundException fe) {
            System.err.println(String.valueOf(infilename) + "not found, error:" + fe.toString());
        }
        return null;
    }

    public String writeStrongMotionXML(StrongMotion sm, String outfilename) {
        try {
            FileOutputStream fo = new FileOutputStream(new File(outfilename));
            this.mar.marshal((Object)sm, (OutputStream)fo);
        }
        catch (Exception me) {
            return "Error writing xml file " + outfilename + "\n" + me.toString();
        }
        return null;
    }

    public Document getXMLdoc(StrongMotion c, Document d) {
        try {
            Marshaller mar2 = this.jc.createMarshaller();
            mar2.marshal((Object)c, (Node)d);
            return d;
        }
        catch (Exception e) {
            System.err.println("in xmlIO, can't use the marshaller:" + e.toString());
            return null;
        }
    }
}

