/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.datatype.DatatypeFactory;
import org.cosmos.csmml.ObjectFactory;
import org.cosmos.csmml.StrongMotion;
import org.cosmos.utils.XMLModelSet;

public class varList {
    private StrongMotion sm;
    private ObjectFactory of = new ObjectFactory();
    private Map<String, Class[]> concrete = this.getConcreteMap();
    private Set mapkeys = this.concrete.keySet();
    private Map<String, XMLModelSet> out = new HashMap<String, XMLModelSet>();
    private final String mainPackage = "org.cosmos.csmml.";
    private final String complexTypeExtension = "Type";
    DatatypeFactory dtf = null;

    public varList() {
        try {
            this.sm = this.of.createStrongMotion();
            this.procreate(this.sm, "", null);
        }
        catch (Exception e) {
            System.out.println("In XMLModel: " + e.toString());
        }
    }

    public Set<String> getTags() {
        TreeMap<String, XMLModelSet> tmap = new TreeMap<String, XMLModelSet>(this.out);
        return tmap.keySet();
    }

    public XMLModelSet getSet(String tag) {
        return this.out.get(tag);
    }

    private void procreate(Object obj, String current, Object parent) {
        Class<?> cls = null;
        Object newObj = null;
        Class<?> cosmosClass = obj.getClass();
        Method[] theMethods = cosmosClass.getMethods();
        String createString = null;
        String classname = null;
        String methodString = null;
        String varname = null;
        String returnType = null;
        Method setMethod = null;
        Method getMethod = null;
        int i = 0;
        while (i < theMethods.length) {
            methodString = theMethods[i].getName();
            if (methodString.startsWith("get") && methodString.indexOf("getClass") < 0) {
                Class[] concreteClasses;
                returnType = theMethods[i].getReturnType().getName();
                getMethod = theMethods[i];
                if (!returnType.startsWith("java.util.List")) {
                    classname = returnType;
                    createString = "create" + classname.substring(classname.lastIndexOf(".") + 1);
                    varname = this.buildVariableName(current, methodString.substring(3));
                    try {
                        cls = Class.forName(returnType);
                    }
                    catch (Exception e) {
                        System.err.println("Can't create " + returnType);
                        System.exit(1);
                    }
                    setMethod = this.getSetMethod(theMethods, methodString);
                    boolean successful = this.outputValues(varname, cls, obj, parent, null);
                    if (!successful) {
                        try {
                            boolean isAbstract = false;
                            if (classname.indexOf("JAXBElement") > 0) {
                                classname = "org.cosmos.csmml." + methodString.substring(3) + "Type";
                                cls = Class.forName("org.cosmos.csmml." + methodString.substring(3) + "Type");
                            }
                            if (this.mapkeys.contains(classname)) {
                                String concElement = null;
                                concreteClasses = this.concrete.get(classname);
                                int k = 0;
                                while (k < concreteClasses.length) {
                                    Class conc = concreteClasses[k];
                                    if (cls.isAssignableFrom(conc)) {
                                        isAbstract = true;
                                        newObj = this.getNewObject(classname, this.makeCreateString(conc.getName(), "Type"), null);
                                        if (newObj == null) {
                                            return;
                                        }
                                        concElement = conc.getSimpleName().substring(0, conc.getSimpleName().length() - 4);
                                        Object envelope = this.getNewObject(concElement, "create" + concElement, new Class[]{newObj.getClass()}, newObj);
                                        if (envelope == null) {
                                            return;
                                        }
                                        this.addToParent(obj, setMethod, envelope);
                                        this.procreate(newObj, String.valueOf(current) + "." + concElement, obj);
                                    }
                                    ++k;
                                }
                            }
                            if (!isAbstract) {
                                newObj = this.getNewObject(classname, createString, null);
                                if (newObj == null) {
                                    return;
                                }
                                this.addToParent(obj, setMethod, newObj);
                                this.procreate(newObj, String.valueOf(current) + "." + methodString.substring(3), obj);
                            }
                        }
                        catch (Throwable e) {
                            System.err.println("couldn't create with: " + cls.getName().toString());
                        }
                    }
                } else if (returnType.startsWith("java.util.List")) {
                    varname = this.buildVariableName(current, methodString.substring(3), 0);
                    String genericType = getMethod.getGenericReturnType().toString();
                    classname = genericType.substring(genericType.indexOf("<") + 1, genericType.indexOf(">"));
                    createString = "create" + classname.substring(classname.lastIndexOf(".") + 1);
                    String shortvarname = varname.substring(0, varname.lastIndexOf("."));
                    if (varname.endsWith(".Value(1)")) {
                        List children = this.getChild(obj, getMethod, newObj);
                        if (varname.contains("Units") || varname.contains("Format")) {
                            this.output("txt", shortvarname, obj, parent, children);
                        } else {
                            this.output("cpx", shortvarname, obj, parent, children);
                        }
                        return;
                    }
                    boolean isAbstract = false;
                    try {
                        cls = Class.forName("org.cosmos.csmml." + methodString.substring(3) + "Type");
                        classname = "org.cosmos.csmml." + methodString.substring(3) + "Type";
                        if (this.mapkeys.contains(classname)) {
                            concreteClasses = this.concrete.get(classname);
                            String concElement = null;
                            int k = 0;
                            while (k < concreteClasses.length) {
                                Class conc = concreteClasses[k];
                                if (cls.isAssignableFrom(conc)) {
                                    isAbstract = true;
                                    newObj = this.getNewObject(classname, this.makeCreateString(conc.getName(), "Type"), null);
                                    if (newObj == null) {
                                        return;
                                    }
                                    concElement = conc.getSimpleName().substring(0, conc.getSimpleName().length() - 4);
                                    Object envelope = this.getNewObject(concElement, "create" + concElement, new Class[]{newObj.getClass()}, newObj);
                                    if (envelope == null) {
                                        return;
                                    }
                                    List children = this.getChild(obj, getMethod, envelope);
                                    this.procreate(newObj, String.valueOf(current) + "." + concElement + "(1)", obj);
                                }
                                ++k;
                            }
                        }
                        if (!isAbstract) {
                            newObj = this.getNewObject(classname, createString, null);
                            if (newObj == null) {
                                return;
                            }
                            List children = this.getChild(obj, getMethod, newObj);
                            boolean successful = this.outputValues(varname, cls, obj, parent, children);
                            if (!successful) {
                                this.procreate(newObj, String.valueOf(current) + "." + methodString.substring(3) + "(1)", obj);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    private void addToParent(Object parent, Method setMethod, Object child) {
        try {
            setMethod.invoke(parent, child);
        }
        catch (Exception e) {
            System.err.println("Unable to add " + child.getClass().getSimpleName() + " to " + parent.getClass().getSimpleName() + " with " + setMethod.getName());
        }
    }

    private List getChild(Object parent, Method getMethod, Object child) {
        List outputList = null;
        try {
            outputList = (List)getMethod.invoke(parent, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("Couldn't get List for: " + parent.getClass().getSimpleName() + " " + e.toString());
        }
        try {
            Class[] parameterTypes = new Class[]{Object.class};
            Method meth = outputList.getClass().getMethod("add", parameterTypes);
            meth.invoke((Object)outputList, child);
        }
        catch (Exception e) {
            System.err.println("No add method for: " + child.getClass().getSimpleName() + " " + e.toString());
        }
        return outputList;
    }

    private Method getSetMethod(Method[] theMethods, String getMethodString) {
        String setMethodString = null;
        Method setMethod = null;
        int jk = 0;
        while (jk < theMethods.length) {
            setMethodString = theMethods[jk].getName();
            if (setMethodString.startsWith("set") && setMethodString.indexOf(getMethodString.substring(3)) > 0 && setMethodString.length() == getMethodString.length()) {
                setMethod = theMethods[jk];
            }
            ++jk;
        }
        return setMethod;
    }

    private boolean outputValues(String varname, Class cls, Object obj, Object parent, List children) {
        String shortvarname;
        String returnType = obj.getClass().getName();
        int lastElement = varname.lastIndexOf(".");
        String string = shortvarname = lastElement > 1 ? varname.substring(0, lastElement) : null;
        if (varname.endsWith(".Note")) {
            return true;
        }
        if (varname.endsWith(".Uom")) {
            return true;
        }
        if (cls.equals(String.class)) {
            if (returnType.indexOf("Int") > 0) {
                this.output("int", shortvarname, obj, parent, children);
            } else if (returnType.indexOf("ObservationalMMI") > 0) {
                this.output("int", shortvarname, obj, parent, children);
            } else if (returnType.indexOf("Double") > 0) {
                this.output("dbl", shortvarname, obj, parent, children);
            } else if (returnType.indexOf("Corner") > 0 || returnType.indexOf("Decay") > 0) {
                this.output("dbl", shortvarname, obj, parent, children);
            } else {
                this.output("txt", shortvarname, obj, parent, children);
            }
            return true;
        }
        return false;
    }

    private void output(String typeDescription, String variableName, Object datatype, Object parent, List children) {
        XMLModelSet set = new XMLModelSet(typeDescription, datatype, children, parent);
        this.out.put(variableName.substring(1), set);
    }

    private Object getNewObject(String classname, String createString, Class[] parameterTypes) {
        Object newObj = null;
        Method createMethod = null;
        try {
            createMethod = this.of.getClass().getMethod(createString, parameterTypes);
            newObj = createMethod.invoke((Object)this.of, new Object[0]);
            return newObj;
        }
        catch (Exception e) {
            System.err.println("Can't create " + classname + " using " + createString + ", so quitting");
            return null;
        }
    }

    private Object getNewObject(String classname, String createString, Class[] parameterTypes, Object obj) {
        Object newObj = null;
        Method createMethod = null;
        try {
            createMethod = this.of.getClass().getMethod(createString, parameterTypes);
            newObj = createMethod.invoke((Object)this.of, obj);
            return newObj;
        }
        catch (Exception e) {
            System.err.println("Can't create " + classname + " using " + createString + ", so quitting: " + e.toString());
            return null;
        }
    }

    private String makeCreateString(String classname, String extension) {
        int position = classname.lastIndexOf(".") + 1;
        String createString = "create" + classname.substring(position);
        int choiceIndex = createString.indexOf("$");
        if (choiceIndex > -1) {
            createString = String.valueOf(createString.substring(0, choiceIndex - 4)) + extension + createString.substring(choiceIndex + 1, createString.length());
        }
        return createString;
    }

    private String buildVariableName(String curr, String method, int order) {
        String out = curr;
        if (out != null) {
            out = String.valueOf(out) + ".";
        }
        int newOrder = order + 1;
        return String.valueOf(out) + method + "(" + String.valueOf(newOrder) + ")";
    }

    private String buildVariableName(String curr, String method) {
        String out = curr;
        if (out != null) {
            out = String.valueOf(out) + ".";
        }
        return String.valueOf(out) + method;
    }

    private HashMap<String, Class[]> getConcreteMap() {
        String[][] concreteTypes = new String[][]{{"BuildingType", "OtherStructureType", "BridgeType", "DamType"}, {"SaType", "SvType", "SdType"}};
        HashMap<String, Class[]> map = new HashMap<String, Class[]>(2);
        String[] abstractTypes = new String[]{"org.cosmos.csmml.AbstractStructureType", "org.cosmos.csmml.AbstractSpecType"};
        Class[][] concreteClasses = new Class[2][4];
        String[] prefixes = new String[]{"org.cosmos.csmml.", "org.cosmos.csmml."};
        try {
            int end = abstractTypes.length;
            int k = 0;
            while (k < end) {
                int i = 0;
                while (i < concreteTypes[k].length) {
                    concreteClasses[k][i] = Class.forName(String.valueOf(prefixes[k]) + concreteTypes[k][i]);
                    ++i;
                }
                map.put(abstractTypes[k], concreteClasses[k]);
                ++k;
            }
        }
        catch (Exception eec) {
            System.out.println("couldn't assign values to the hashmap of concrete classes" + eec.toString());
        }
        return map;
    }
}

