/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.datatype.DatatypeFactory;
import org.cosmos.csmml.ObjectFactory;
import org.cosmos.csmml.StrongMotion;
import org.cosmos.utils.TagHeader;
import org.cosmos.utils.XMLModelSet;

public class XMLModel {
    private StrongMotion sm;
    private ObjectFactory of = new ObjectFactory();
    private Map<String, XMLModelSet> leaf = new HashMap<String, XMLModelSet>();
    private Map<String, XMLModelSet> branch = new HashMap<String, XMLModelSet>();
    private final String mainPackage = "org.cosmos.csmml.";
    private final String complexTypeExtension = "Type";
    DatatypeFactory dtf = null;

    public XMLModel() {
        this.sm = this.of.createStrongMotion();
    }

    public StrongMotion getStrongMotion() {
        return this.sm;
    }

    public Set<String> getTags() {
        TreeMap<String, XMLModelSet> tmap = new TreeMap<String, XMLModelSet>(this.leaf);
        return tmap.keySet();
    }

    public void generateNodes(TagHeader th) {
        Set<String> tags = th.getTags();
        Iterator<String> it = tags.iterator();
        XMLModelSet branchSet = null;
        Object current = null;
        Object parent = null;
        String childString = null;
        String currentString = null;
        String shortname = null;
        String tag = null;
        List children = null;
        boolean last = false;
        while (it.hasNext()) {
            parent = null;
            childString = null;
            children = null;
            current = this.sm;
            currentString = "";
            tag = it.next();
            String[] tagSegment = tag.split("\\.");
            int i = 0;
            while (i < tagSegment.length) {
                childString = tagSegment[i];
                currentString = String.valueOf(currentString) + "." + childString;
                if (childString.indexOf("(") > -1) {
                    childString = childString.substring(0, childString.lastIndexOf("("));
                }
                if (this.branch.containsKey(shortname = currentString.substring(1))) {
                    branchSet = this.branch.get(shortname);
                    current = branchSet.getObject();
                    parent = branchSet.getParent();
                    children = branchSet.getList();
                } else {
                    last = i == tagSegment.length - 1;
                    XMLModelSet newSet = this.procreate(current, currentString, childString, parent, last);
                    if (newSet == null) {
                        System.exit(1);
                    }
                    newSet.setType(th.getType(tag));
                    current = newSet.getObject();
                    parent = newSet.getParent();
                    children = newSet.getList();
                    if (!last) {
                        this.branch.put(shortname, newSet);
                    }
                }
                ++i;
            }
            XMLModelSet set = new XMLModelSet(th.getType(shortname), current, children, parent);
            this.leaf.put(currentString.substring(1), set);
        }
    }

    private XMLModelSet procreate(Object obj, String current, String child, Object parent, boolean last) {
        Object newObj = null;
        String createString = null;
        String classname = null;
        String methodString = null;
        String returnType = null;
        Method setMethod = null;
        Method getMethod = null;
        List children = null;
        Class<?> cosmosClass = obj.getClass();
        Method[] theMethods = cosmosClass.getMethods();
        try {
            getMethod = obj.getClass().getMethod("get" + child, new Class[0]);
        }
        catch (Exception e) {
            String abstractType = this.getAbstractClass(child);
            if (abstractType != null) {
                try {
                    getMethod = obj.getClass().getMethod("get" + abstractType, new Class[0]);
                    returnType = getMethod.getReturnType().getName();
                }
                catch (Exception ee) {
                    System.err.println("couldn't create get method for " + abstractType + " " + e.toString());
                    System.exit(1);
                }
                newObj = this.getNewObject(String.valueOf(child) + "Type", "create" + child + "Type", null);
                if (newObj == null) {
                    return null;
                }
                Object envelope = this.getNewObject(child, "create" + child, new Class[]{newObj.getClass()}, newObj);
                if (envelope == null) {
                    return null;
                }
                if (returnType.startsWith("java.util.List")) {
                    children = this.getChild(obj, getMethod, envelope);
                } else {
                    try {
                        setMethod = obj.getClass().getMethod("set" + abstractType, getMethod.getReturnType());
                    }
                    catch (Exception ee) {
                        System.err.println("couldn't create set method for " + abstractType + " with return type:" + returnType + " " + e.toString());
                        System.exit(1);
                    }
                    this.addToParent(obj, setMethod, envelope);
                }
                return new XMLModelSet(null, newObj, children, obj);
            }
            System.out.println("No method get" + child + " for " + obj.getClass().getSimpleName() + " " + e.toString());
            System.exit(1);
        }
        methodString = getMethod.getName();
        returnType = getMethod.getReturnType().getName();
        if (!returnType.startsWith("java.util.List")) {
            classname = returnType;
            createString = "create" + classname.substring(classname.lastIndexOf(".") + 1);
            setMethod = this.getSetMethod(theMethods, methodString);
            newObj = this.getNewObject(classname, createString, null);
            if (newObj == null) {
                return null;
            }
            this.addToParent(obj, setMethod, newObj);
            return new XMLModelSet(null, newObj, children, obj);
        }
        if (returnType.startsWith("java.util.List")) {
            String genericType = getMethod.getGenericReturnType().toString();
            classname = genericType.substring(genericType.indexOf("<") + 1, genericType.indexOf(">"));
            newObj = this.getNewObject(classname, createString = "create" + classname.substring(classname.lastIndexOf(".") + 1), null);
            if (newObj == null) {
                return null;
            }
            children = this.getChild(obj, getMethod, newObj);
            return new XMLModelSet(null, newObj, children, obj);
        }
        return null;
    }

    private void addToParent(Object parent, Method setMethod, Object child) {
        try {
            setMethod.invoke(parent, child);
        }
        catch (Exception e) {
            System.err.println("Unable to add " + child.getClass().getSimpleName() + " to " + parent.getClass().getSimpleName() + " with " + setMethod.getName());
        }
    }

    private List getChild(Object parent, Method getMethod, Object child) {
        List outputList = null;
        try {
            outputList = (List)getMethod.invoke(parent, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("Couldn't get List for: " + parent.getClass().getSimpleName() + " " + e.toString());
        }
        try {
            Class[] parameterTypes = new Class[]{Object.class};
            Method meth = outputList.getClass().getMethod("add", parameterTypes);
            meth.invoke((Object)outputList, child);
        }
        catch (Exception e) {
            System.err.println("No add method for: " + child.getClass().getSimpleName() + " " + e.toString());
        }
        return outputList;
    }

    private Method getSetMethod(Method[] theMethods, String getMethodString) {
        String setMethodString = null;
        Method setMethod = null;
        int jk = 0;
        while (jk < theMethods.length) {
            setMethodString = theMethods[jk].getName();
            if (setMethodString.startsWith("set") && setMethodString.indexOf(getMethodString.substring(3)) > 0 && setMethodString.length() == getMethodString.length()) {
                setMethod = theMethods[jk];
            }
            ++jk;
        }
        return setMethod;
    }

    private Object getNewObject(String classname, String createString, Class[] parameterTypes) {
        Object newObj = null;
        Method createMethod = null;
        try {
            createMethod = this.of.getClass().getMethod(createString, parameterTypes);
            newObj = createMethod.invoke((Object)this.of, new Object[0]);
            return newObj;
        }
        catch (Exception e) {
            System.err.println("Can't create " + classname + " using " + createString + " : " + e.toString());
            return null;
        }
    }

    private Object getNewObject(String classname, String createString, Class[] parameterTypes, Object obj) {
        Object newObj = null;
        Method createMethod = null;
        try {
            createMethod = this.of.getClass().getMethod(createString, parameterTypes);
            newObj = createMethod.invoke((Object)this.of, obj);
            return newObj;
        }
        catch (Exception e) {
            System.err.println("Can't create " + classname + " using " + createString + " : " + e.toString());
            return null;
        }
    }

    private String getAbstractClass(String elementName) {
        try {
            Class<?> cls = Class.forName("org.cosmos.csmml." + elementName + "Type");
            String superClass = cls.getSuperclass().getSimpleName();
            return superClass.substring(0, superClass.length() - 4);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setXMLValues(TagHeader th) {
        Set<String> tags = th.getTags();
        Iterator<String> it = tags.iterator();
        Object obj = null;
        String tag = null;
        String value = null;
        String note = null;
        String units = null;
        while (it.hasNext()) {
            tag = it.next();
            value = th.getValue(tag);
            note = th.getNote(tag);
            units = th.getUnits(tag);
            XMLModelSet set = this.leaf.get(tag);
            if (set == null) {
                System.err.println("Name error for " + tag);
                continue;
            }
            if (set.getType().indexOf("cpx") > -1) {
                this.setList(set.getObject(), value, set.getList());
                continue;
            }
            obj = set.getObject();
            if (tag.startsWith("DataSeries.DataSeriesValues")) {
                this.setObject(obj, "setValue", "\n" + th.getValue("DataSeries.DataSeriesValues"));
            } else if (tag.indexOf("DateTime") > -1) {
                this.setObject(obj, "setValue", this.fixStringDate(value));
            } else {
                this.setObject(obj, "setValue", value);
            }
            if (note != null) {
                this.setObject(obj, "setNote", note);
            }
            if (units == null) continue;
            this.setObject(obj, "setUom", units);
        }
    }

    private void setObject(Object obj, String methodString, String val) {
        try {
            Class[] parameterTypes = new Class[]{String.class};
            Method meth = obj.getClass().getMethod(methodString, parameterTypes);
            meth.invoke(obj, val);
        }
        catch (Exception e) {
            System.err.println("No such method: " + methodString + " " + e.toString());
        }
    }

    private void setList(Object obj, String val, List children) {
        Method meth = null;
        List cpxList = null;
        try {
            meth = obj.getClass().getMethod("getValue", new Class[0]);
            cpxList = (List)meth.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("Error trying to get a complex list:" + obj.getClass().getSimpleName() + " " + e.toString());
        }
        try {
            meth = cpxList.getClass().getMethod("add", Object.class);
            Object[] argList = new Object[]{val};
            meth.invoke((Object)cpxList, argList);
        }
        catch (Exception e) {
            System.err.println("Error trying to add the value to the complex list:" + obj.getClass().getSimpleName() + " " + e.toString());
        }
    }

    private String fixStringDate(String cosmosDate) {
        String date = cosmosDate.trim();
        int tIndex = date.indexOf(" ");
        if (tIndex > -1) {
            date = String.valueOf(date.substring(0, tIndex)) + "T" + date.substring(tIndex + 1);
        }
        return date;
    }
}

