/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.cosmos.utils.TagHeader;
import org.cosmos.utils.TagLineParser;

public class TaggedHandler {
    private String fileName = null;
    private File ffile = null;
    private String[] lines;
    private int dividingLine;
    private StringBuffer dataString = null;
    private StringBuffer origHeader = null;
    private TagHeader th = null;

    public TaggedHandler() {
    }

    public TaggedHandler(String filename) {
        this.setFileName(filename);
    }

    public void setFileName() {
        this.fileName = this.launchChooser();
    }

    public void setFileName(String filename) {
        this.ffile = new File(filename);
        this.fileName = this.ffile.getName();
    }

    public void setFile(File file) {
        this.ffile = file;
        this.fileName = this.ffile.getName();
    }

    public String getLongFileName() {
        return this.ffile.getPath();
    }

    public String launchChooser() {
        JFrame cframe = new JFrame("Choose a file");
        this.ffile = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Choose a file");
        int returnVal = chooser.showOpenDialog(cframe);
        if (returnVal == 0) {
            this.ffile = chooser.getSelectedFile();
        }
        return this.ffile.getName();
    }

    public String importFile() {
        String wholeFile = new String();
        try {
            int size = (int)this.ffile.length();
            int chars_read = 0;
            FileReader in = new FileReader(this.ffile);
            char[] data2 = new char[size];
            chars_read = in.read(data2, 0, size);
            in.close();
            wholeFile = new String(data2, 0, chars_read);
        }
        catch (IOException e) {
            return "Error reading file " + this.fileName + ": " + e.toString();
        }
        return this.parseTaggedFile(wholeFile);
    }

    public String parseTaggedFile(String wholeFile) {
        this.lines = wholeFile.split("\\n");
        if (this.lines[this.lines.length - 1].indexOf("}") < 0) {
            return String.valueOf(this.fileName) + " is not a properly formed COSMOS Tagged file";
        }
        this.th = new TagHeader();
        TagLineParser tp = new TagLineParser();
        String line = null;
        int i = 0;
        while (i < this.lines.length) {
            int lineno = i + 1;
            line = this.lines[i].trim();
            if (line.indexOf("DataSeries.DataSeriesValues") > -1) {
                this.dividingLine = i;
                break;
            }
            if (line.length() != 0) {
                if (line.startsWith("||")) {
                    String previousComment = tp.getNote();
                    String addstring = previousComment == null ? "" : String.valueOf(previousComment) + " ";
                    tp.setNote(String.valueOf(addstring) + line.substring(2).trim());
                    this.th.put(tp.getKey(), tp.getType(), tp.getValue(), tp.getUnits(), tp.getNote());
                } else {
                    tp.setLine(lineno, line);
                    this.th.put(tp.getKey(), tp.getType(), tp.getValue(), tp.getUnits(), tp.getNote());
                }
            }
            ++i;
        }
        int noteIndex = line.indexOf("||");
        String dataSeriesNote = noteIndex > 0 ? line.substring(noteIndex + 2) : null;
        this.origHeader = new StringBuffer("");
        int i2 = 0;
        while (i2 < this.dividingLine) {
            this.origHeader.append(this.lines[i2]);
            this.origHeader.append("\n");
            ++i2;
        }
        this.dataString = new StringBuffer("");
        i2 = this.dividingLine + 1;
        while (i2 < this.lines.length) {
            if (this.lines[i2].indexOf("}") > -1) break;
            this.dataString.append(this.lines[i2]);
            this.dataString.append("\n");
            ++i2;
        }
        this.th.put("DataSeries.DataSeriesValues", "txt", this.getDataString(), null, dataSeriesNote);
        return null;
    }

    public String getDataString() {
        return this.dataString.toString();
    }

    public String getHeaderString() {
        return this.origHeader.toString();
    }

    public TagHeader getTagSet() {
        return this.th;
    }

    public Set<String> getTags() {
        return this.th.getTags();
    }

    public boolean hasTag(String tag) {
        return this.th.hasTag(tag);
    }
}

