/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.utils;

public class TagLineParser {
    private String value;
    private String units;
    private String note;
    private String line;
    private String key;
    private String type;
    private int lineno;
    private int quoteloc;
    private int quoteloc2;
    private int colonloc;
    private int noteloc;
    private int typeloc;
    private String datatype;
    private String valuepart;
    private int equalsloc;
    private boolean isComplex;
    private int unitsloc;

    protected void setLine(int inputLineno, String inputLine) {
        int first;
        this.line = inputLine;
        this.lineno = inputLineno;
        this.value = null;
        this.units = null;
        this.note = null;
        this.key = null;
        this.type = null;
        this.typeloc = this.line.indexOf("_");
        this.colonloc = this.line.indexOf(";");
        this.equalsloc = this.line.indexOf("=");
        if (this.colonloc < 0 || this.equalsloc < 0 || this.typeloc < 0) {
            System.err.println("Can't parse line, missing '_' or '=' or ';' on line " + this.lineno + " :" + this.line);
            System.exit(1);
        }
        this.type = this.line.substring(this.typeloc + 1, this.typeloc + 4);
        this.key = this.line.substring(0, this.typeloc);
        this.quoteloc = this.line.indexOf("\"");
        this.noteloc = this.line.indexOf("||");
        this.datatype = this.line.substring(this.typeloc + 1, this.typeloc + 4);
        this.isComplex = this.datatype.startsWith("cpx");
        this.valuepart = this.line.substring(this.equalsloc + 1, this.colonloc).trim();
        this.unitsloc = this.valuepart.indexOf(" ");
        if (this.unitsloc < 0) {
            this.unitsloc = this.valuepart.indexOf("\t");
        }
        this.note = null;
        this.units = null;
        if (this.quoteloc > -1 && this.quoteloc < this.colonloc) {
            try {
                this.quoteloc2 = this.line.indexOf("\"", this.quoteloc + 1);
                if (this.quoteloc2 > this.colonloc) {
                    this.colonloc = this.line.indexOf(";", this.quoteloc2);
                    this.valuepart = this.line.substring(this.equalsloc + 1, this.colonloc).trim();
                }
                this.value = this.line.substring(this.quoteloc + 1, this.quoteloc2);
            }
            catch (Exception e) {
                System.err.println("Line " + this.lineno + " seems to be missing one of its quotation marks");
                System.exit(1);
            }
        } else {
            String[] values;
            this.value = this.isComplex ? ((values = this.valuepart.split("\\s")).length == 3 ? String.valueOf(values[1]) + " " + values[2] : this.valuepart) : (this.unitsloc > -1 ? this.valuepart.substring(0, this.unitsloc) : this.valuepart);
        }
        if (this.noteloc > -1 && (first = this.noteloc + 2) < this.line.length()) {
            this.note = this.line.substring(first, this.line.length()).trim();
        }
        if (this.quoteloc > -1 && this.quoteloc < this.colonloc) {
            this.units = null;
        } else if (this.isComplex) {
            String[] values = this.valuepart.split("\\s");
            if (values.length == 3) {
                this.units = values[2].trim();
            }
        } else if (this.unitsloc > -1) {
            this.units = this.valuepart.substring(this.unitsloc, this.valuepart.length()).trim();
        }
    }

    protected String getKey() {
        return this.key;
    }

    protected String getValue() {
        return this.value;
    }

    protected String getNote() {
        return this.note;
    }

    protected String getUnits() {
        return this.units;
    }

    protected String getType() {
        return this.type;
    }

    protected void setNote(String inputNote) {
        this.note = inputNote;
    }
}

