/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.cosmos.utils.TagSet;

public class TagHeader {
    private Map<String, TagSet> map = new HashMap<String, TagSet>();

    protected TagHeader() {
    }

    protected void put(String tag, String type, String value, String units, String note) {
        TagSet ts = new TagSet(value, units, note, type);
        this.map.put(tag, ts);
    }

    public String getValue(String tag) {
        try {
            TagSet ts = this.map.get(tag);
            return ts.getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getUnits(String tag) {
        try {
            TagSet ts = this.map.get(tag);
            return ts.getUnits();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getNote(String tag) {
        try {
            TagSet ts = this.map.get(tag);
            return ts.getNote();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getType(String tag) {
        try {
            TagSet ts = this.map.get(tag);
            return ts.getType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Set<String> getTags() {
        TreeMap<String, TagSet> tmap = new TreeMap<String, TagSet>(this.map);
        return tmap.keySet();
    }

    public boolean hasTag(String tag) {
        return this.map.containsKey(tag);
    }
}

