/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.utils;

import java.io.File;
import java.util.Vector;
import org.cosmos.utils.FileHandler;

public class FileSplitter {
    private String[][] type = new String[][]{{"Corrected Acceleration", "Corrected Velocity    ", "Corrected Displacement"}, {"something else"}};
    private String[][] shortType = new String[][]{{"acc", "vel", "dis"}, {"x", "y", "z"}};
    protected Vector<String> splitOutputFiles = new Vector();

    public void resetSplitFileList() {
        this.splitOutputFiles.clear();
    }

    public Vector<String> getSplitOutputFileList() {
        return this.splitOutputFiles;
    }

    public String splitCSMIP2(FileHandler fh, String file, String shortname) {
        Vector<String> header = new Vector<String>();
        Vector<String> channel = new Vector<String>();
        Vector<String> datatype = new Vector<String>();
        String endOfChannel = "/&";
        String formatType = fh.getFormatType(file);
        String[] line = fh.getFileAsStrings(file);
        File outdir = fh.getOutputDir();
        int chan = 1;
        int j = 0;
        while (j < line.length) {
            channel.add(String.valueOf(line[j++]) + "\n");
            if (!line[j - 1].startsWith(endOfChannel)) continue;
            int k = 0;
            while (!((String)channel.get(k)).toLowerCase().contains("equally spaced")) {
                header.add((String)channel.get(k++));
            }
            int m = 0;
            while (m < 3) {
                datatype.clear();
                datatype.add((String)channel.get(k++));
                while (k < channel.size() && !((String)channel.get(k)).toLowerCase().contains("equally spaced")) {
                    datatype.add((String)channel.get(k++));
                }
                String datatypeString = this.type[0][m];
                header.set(0, String.valueOf(datatypeString) + ((String)header.get(0)).substring(datatypeString.length()));
                String newFileName = this.getOutDirName(outdir, shortname, formatType, chan, this.shortType[0][m]);
                String outfile = this.combineLines(header, datatype, chan, this.shortType[0][m], formatType);
                this.splitOutputFiles.add(newFileName);
                String errorMessage = fh.writeLines(newFileName, outfile);
                if (errorMessage != null) {
                    return errorMessage;
                }
                ++m;
            }
            channel.clear();
            ++chan;
            header.clear();
        }
        return null;
    }

    public String splitCosmos2(FileHandler fh, String file, String shortname) {
        Vector<String> channel = new Vector<String>();
        Vector<String> datatype = new Vector<String>();
        String formatType = fh.getFormatType(file);
        String[] line = fh.getFileAsStrings(file);
        File outdir = fh.getOutputDir();
        String endOfChannel = fh.getChannelEndString(file);
        String newFileName = null;
        String outfile = null;
        int chan = 1;
        int j = 0;
        while (j < line.length) {
            channel.add(String.valueOf(line[j++]) + "\n");
            if (!line[j - 1].startsWith(endOfChannel)) continue;
            int k = 0;
            int m = 0;
            while (m < 3) {
                datatype.add((String)channel.get(k++));
                while (k < channel.size() && !((String)channel.get(k)).contains("v01.20")) {
                    datatype.add((String)channel.get(k++));
                }
                newFileName = this.getOutDirName(outdir, shortname, formatType, chan, this.shortType[0][m]);
                outfile = this.combineLines(datatype, chan, this.shortType[0][m], formatType);
                this.splitOutputFiles.add(newFileName);
                datatype.clear();
                String errorMessage = fh.writeLines(newFileName, outfile);
                if (errorMessage != null) {
                    return errorMessage;
                }
                ++m;
            }
            channel.clear();
            ++chan;
        }
        return null;
    }

    public String splitNZ(FileHandler fh, String file, String shortname) {
        int headerLength;
        Vector<String> header = new Vector<String>();
        Vector<String> channel = new Vector<String>();
        Vector<String> datatype = new Vector<String>();
        String startOfChannel = fh.getChannelStartString(file);
        String formatType = fh.getFormatType(file);
        String[] line = fh.getFileAsStrings(file);
        int[] linesPerDataType = new int[3];
        int channelLength = headerLength = 26;
        try {
            int i = 0;
            while (i < 3) {
                int start = i * 8 + 24;
                int numSamp = Integer.valueOf(line[19].substring(start, start + 8).trim());
                linesPerDataType[i] = numSamp / 10;
                if (numSamp % 10 > 0) {
                    int n = i;
                    linesPerDataType[n] = linesPerDataType[n] + 1;
                }
                channelLength += linesPerDataType[i];
                ++i;
            }
        }
        catch (Exception e) {
            return "could not read number of samples from line: " + line[19] + "\nin header of " + shortname + " " + e.toString();
        }
        File outdir = fh.getOutputDir();
        int chan = 1;
        int j = 0;
        int k = 0;
        int arrayEnd = line.length + 1;
        while (j < arrayEnd) {
            if (channel.size() == channelLength) {
                k = 0;
                while (k < headerLength) {
                    header.add((String)channel.get(k));
                    ++k;
                }
                int end = headerLength;
                int m = 0;
                while (m < 3) {
                    datatype.clear();
                    int start = end;
                    end = start + linesPerDataType[m];
                    k = start;
                    while (k < end) {
                        datatype.add((String)channel.get(k));
                        ++k;
                    }
                    String datatypeString = this.type[0][m];
                    header.set(0, String.valueOf(datatypeString) + ((String)header.get(0)).substring(datatypeString.length()));
                    String newFileName = this.getOutDirName(outdir, shortname, formatType, chan, this.shortType[0][m]);
                    String outfile = this.combineLines(header, datatype, chan, this.shortType[0][m], formatType);
                    this.splitOutputFiles.add(newFileName);
                    String errorMessage = fh.writeLines(newFileName, outfile);
                    if (errorMessage != null) {
                        return errorMessage;
                    }
                    ++m;
                }
                channel.clear();
                ++chan;
                header.clear();
            }
            if (j < arrayEnd - 1) {
                channel.add(String.valueOf(line[j]) + "\n");
            }
            ++j;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public String splitByChannel(FileHandler fh, String file, String shortname) {
        block7: {
            channel = new Vector<String>();
            endOfChannel = fh.getChannelEndString(file);
            startOfChannel = fh.getChannelStartString(file);
            type = fh.getDataType(file);
            extension = "spe";
            if (type.contains("unprocessed")) {
                extension = "unc";
            }
            line = fh.getFileAsStrings(file);
            outdir = fh.getOutputDir();
            formatType = fh.getFormatType(file);
            chan = 1;
            j = 0;
            if (endOfChannel != null) ** GOTO lbl44
            arrayEnd = line.length;
            while (j <= arrayEnd) {
                if (j == arrayEnd || line[j].contains(startOfChannel) && j != 0) {
                    newFileName = this.getOutDirName(outdir, shortname, formatType, chan, extension);
                    outfile = this.combineLines(channel, chan);
                    this.splitOutputFiles.add(newFileName);
                    errorMessage = fh.writeLines(newFileName, outfile);
                    if (errorMessage != null) {
                        return errorMessage;
                    }
                    channel.clear();
                    ++chan;
                }
                if (j < arrayEnd) {
                    channel.add(String.valueOf(line[j]) + "\n");
                }
                ++j;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                channel.add(String.valueOf(line[j++]) + "\n");
                if (!line[j - 1].startsWith(endOfChannel)) continue;
                newFileName = this.getOutDirName(outdir, shortname, formatType, chan, extension);
                outfile = this.combineLines(channel, chan);
                this.splitOutputFiles.add(newFileName);
                errorMessage = fh.writeLines(newFileName, outfile);
                if (errorMessage != null) {
                    return errorMessage;
                }
                channel.clear();
                ++chan;
lbl44:
                // 3 sources

                ** while (j < line.length)
            }
        }
        return null;
    }

    private String combineLines(Vector header, Vector datatype, int chan, String type, String formatType) {
        StringBuffer sb = new StringBuffer();
        int l = 0;
        while (l < header.size()) {
            sb.append(header.get(l));
            ++l;
        }
        l = 0;
        while (l < datatype.size()) {
            sb.append(datatype.get(l));
            ++l;
        }
        sb.append("/&  ----------  End of data for channel  " + chan + " " + type + " ----------");
        return sb.toString();
    }

    private String combineLines(Vector vect, int chan, String type, String formatType) {
        StringBuffer sb = new StringBuffer();
        int l = 0;
        while (l < vect.size()) {
            sb.append(vect.get(l));
            ++l;
        }
        sb.append("End-of-data for Chan  " + chan + " " + type);
        return sb.toString();
    }

    private String combineLines(Vector channel, int chan) {
        StringBuffer sb = new StringBuffer();
        int l = 0;
        while (l < channel.size()) {
            sb.append(channel.get(l));
            ++l;
        }
        return sb.toString();
    }

    private String getOutDirName(File out, String shortname, String formatType, int chan, String type) {
        String filename = this.makeOutputFileName(out, shortname, formatType, chan, type);
        return String.valueOf(this.getDirPath(out)) + filename;
    }

    private String getOutDirName(File out, String shortname, String formatType, int chan) {
        String filename = this.makeOutputFileName(out, shortname, formatType, chan);
        return String.valueOf(this.getDirPath(out)) + filename;
    }

    private String makeOutputFileName(File out, String shortname, String formatType, int chan) {
        String initChar = chan < 10 ? "0" : "";
        return String.valueOf(shortname.substring(0, shortname.indexOf("."))) + "_" + initChar + chan + "_" + formatType + ".txt";
    }

    private String makeOutputFileName(File out, String shortname, String formatType, int chan, String type) {
        String initChar = chan < 10 ? "0" : "";
        return String.valueOf(shortname.substring(0, shortname.indexOf("."))) + "_" + initChar + chan + "_" + formatType + "_" + type + ".txt";
    }

    private String getDirPath(File out) {
        String outdir = out.getAbsolutePath();
        if (!outdir.endsWith("/")) {
            outdir = String.valueOf(outdir) + "/";
        }
        return outdir;
    }
}

