/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.utils;

import org.cosmos.csmml.StrongMotion;

public class FileNamer {
    public String getNewFileName(StrongMotion sm, String extension) {
        StringBuffer filename = new StringBuffer();
        String date = sm.getDataSeries().getFirstSampleTime().getDateTime().getValue();
        if (date.contains("NULL")) {
            try {
                date = sm.getEvent().get(0).getHypocenter().get(0).getOriginTime().getDateTime().getValue();
            }
            catch (Exception e) {
                date = "0000-00-00T00:00:00";
            }
        }
        filename.append(String.valueOf(date.substring(0, 4)) + date.substring(5, 7) + date.substring(8, 10));
        filename.append("_" + date.substring(11, 13) + date.substring(14, 16) + date.substring(17, 19));
        String network = null;
        String point = null;
        try {
            point = sm.getGeoLocation().getName().get(0).getSCNL().getValue();
            network = null;
        }
        catch (Exception e) {
            try {
                try {
                    point = sm.getGeoLocation().getName().get(0).getShortName().getValue();
                }
                catch (Exception ee) {
                    point = sm.getGeoLocation().getSite().getCode().get(0).getTextValue().getValue();
                }
                network = sm.getArray().getAgency().getValue();
            }
            catch (Exception ee) {
                try {
                    network = sm.getGeoLocation().getName().get(0).getAgency().getValue();
                }
                catch (Exception eee) {
                    network = "XX";
                }
            }
        }
        if (network != null) {
            filename.append("_" + network);
        }
        filename.append("_" + point);
        String version = "";
        try {
            String vol = sm.getProcessing().getBlueBookVolume().getValue();
            if (!vol.startsWith("NULL")) {
                version = String.valueOf(version) + "_Vo" + vol;
            }
        }
        catch (Exception vol) {
            // empty catch block
        }
        try {
            String instance = sm.getProcessing().getInstance().getValue();
            if (!instance.startsWith("NULL")) {
                version = String.valueOf(version) + "_Op" + instance;
            }
        }
        catch (Exception instance) {
            // empty catch block
        }
        try {
            String review = sm.getProcessing().getHumanReview().getValue().toUpperCase();
            if (!review.startsWith("NULL")) {
                version = String.valueOf(version) + "_Hn" + review.substring(0, 1);
            }
        }
        catch (Exception review) {
            // empty catch block
        }
        try {
            String stage = sm.getProcessing().getStage().getValue().toUpperCase();
            if (!stage.startsWith("NULL")) {
                version = String.valueOf(version) + "_St" + stage.substring(0, 1);
            }
        }
        catch (Exception stage) {
            // empty catch block
        }
        try {
            String special = sm.getProcessing().getSpecialProcessing().getValue();
            if (!special.startsWith("NULL")) {
                version = String.valueOf(version) + "_SP" + special;
            }
        }
        catch (Exception special) {
            // empty catch block
        }
        filename.append(version);
        String channel = null;
        try {
            channel = "_Ch" + sm.getSensor().getArrayChannel().getValue();
        }
        catch (Exception e) {
            try {
                channel = "_Ch" + sm.getSensor().getDAUchannel().getValue();
            }
            catch (Exception ee) {
                channel = "";
            }
        }
        filename.append(channel);
        String index = null;
        try {
            index = "In" + sm.getGeoLocation().getName().get(0).getIndex().getValue();
        }
        catch (Exception e) {
            index = "";
        }
        filename.append(index);
        String type = null;
        try {
            String longtype = sm.getDataSeries().getPhysicalParameter().getValue().toUpperCase();
            if (longtype.indexOf("PROCESSED ACCELERATION") > -1) {
                type = "A";
            } else if (longtype.indexOf("VELOCITY") > -1) {
                type = "V";
            } else if (longtype.indexOf("DISPLACEMENT") > -1) {
                type = "D";
            } else if (longtype.indexOf("(SA)") > -1) {
                type = "Sa";
            } else if (longtype.indexOf("(SV)") > -1) {
                type = "Sv";
            } else if (longtype.indexOf("(SD)") > -1) {
                type = "Sd";
            } else if (longtype.indexOf("(PSA)") > -1) {
                type = "PSA";
            } else if (longtype.indexOf("(PSV)") > -1) {
                type = "PSV";
            } else if (longtype.indexOf("AMPLITUDE") > -1) {
                type = "DFT";
            } else if (longtype.indexOf("COMPLEX") > -1) {
                type = "CFT";
            } else if (longtype.indexOf("RELATIVE PRESSURE") > -1) {
                type = "GP";
            } else if (longtype.indexOf("PRESSURE") > -1) {
                type = "P";
            } else if (longtype.indexOf("CALIBRATION") > -1) {
                type = "CAL";
            } else if (longtype.indexOf("STRAIN") > -1) {
                type = "S";
            } else if (longtype.indexOf("RMS") > -1) {
                type = "RMS";
            } else if (longtype.indexOf("POWER") > -1) {
                type = "PWR";
            }
            if (longtype.indexOf("ROTATIONAL") > -1) {
                type = "R" + type;
            }
            type = "_" + type;
        }
        catch (Exception e) {
            type = "";
        }
        filename.append(type);
        filename.append("." + extension);
        String name = filename.toString();
        name = name.replaceAll("/", "-");
        name = name.replaceAll(":", "_");
        name = name.replaceAll(" ", "");
        return name;
    }
}

