/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.utils;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class FileHandler {
    private String inDirPath = null;
    private File input;
    private File output;
    private String[] filenames = null;
    private File outDirectory = null;
    private String[] dates = null;
    private String separator = System.getProperty("file.separator");
    private HashMap<String, String> types = null;
    private String formatType = null;
    private String channelEndString = null;
    private String channelStartString = null;
    private boolean isDir = false;
    private boolean isSingle = false;
    protected FilenameFilter csmipFileFilter;
    protected FilenameFilter nzFileFilter;
    protected FilenameFilter cosmFileFilter;
    protected FilenameFilter nonSplittableFileFilter;

    public String getShortName(int i) {
        return this.filenames[i].substring(this.filenames[i].lastIndexOf(this.separator) + 1);
    }

    public String getShortName(String filename) {
        return filename.substring(filename.lastIndexOf(this.separator) + 1);
    }

    public boolean isFolder(int i) {
        File f = new File(this.filenames[i]);
        return f.isDirectory();
    }

    public boolean isFolder(String filename) {
        File f = new File(filename);
        return f.isDirectory();
    }

    public boolean isDir() {
        return this.isDir;
    }

    public boolean isSingleFile() {
        return this.isSingle;
    }

    public String getFirstFileName() {
        return this.filenames != null ? this.filenames[0] : null;
    }

    public String getFileName() {
        return this.findInput(null);
    }

    public String getFileName(String previous) {
        return this.findInput(previous);
    }

    public String[] getFileNames() {
        return this.filenames;
    }

    public String setFileName(String filename) {
        File test = new File(filename);
        if (!test.exists()) {
            return "could not find file: " + filename;
        }
        this.setFiles(test);
        return null;
    }

    public String getInputDirName() {
        return this.inDirPath;
    }

    public String getDate(int i) {
        return this.dates[i];
    }

    public String getOutputFileName(String filename) {
        return String.valueOf(this.outDirectory.getAbsolutePath()) + "/" + filename;
    }

    public String[] getSplittableCSMIPFiles() {
        this.csmipFileFilter = new CSMIPFileFilter();
        File inDir = new File(this.inDirPath);
        Object[] splittableCSMIPFiles = inDir.list(this.csmipFileFilter);
        Arrays.sort(splittableCSMIPFiles);
        int i = 0;
        while (i < splittableCSMIPFiles.length) {
            splittableCSMIPFiles[i] = String.valueOf(this.inDirPath) + "/" + (String)splittableCSMIPFiles[i];
            System.out.println(String.valueOf(splittableCSMIPFiles[i]) + "\n");
            ++i;
        }
        return splittableCSMIPFiles;
    }

    public String[] getSplittableNZFiles() {
        this.nzFileFilter = new NZFileFilter();
        File inDir = new File(this.inDirPath);
        Object[] splittableNZFiles = inDir.list(this.nzFileFilter);
        Arrays.sort(splittableNZFiles);
        int i = 0;
        while (i < splittableNZFiles.length) {
            splittableNZFiles[i] = String.valueOf(this.inDirPath) + "/" + (String)splittableNZFiles[i];
            System.out.println(String.valueOf(splittableNZFiles[i]) + "\n");
            ++i;
        }
        return splittableNZFiles;
    }

    public String setOutputDir() {
        JFrame cframe = new JFrame("Choose a directory");
        this.output = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Choose a directory");
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(cframe);
        if (returnVal == 0) {
            this.output = chooser.getSelectedFile();
            if (this.output.canWrite()) {
                this.outDirectory = this.output;
            } else {
                return "can not write to output directory " + this.output.getName();
            }
        }
        return null;
    }

    public String setOutputDir(String filename) {
        this.outDirectory = new File(filename);
        if (!this.outDirectory.exists()) {
            boolean madeDir = this.outDirectory.mkdir();
            if (!madeDir) {
                return "can't create output directory: " + filename;
            }
            return null;
        }
        if (this.outDirectory.canWrite()) {
            if (this.outDirectory.isDirectory()) {
                return null;
            }
            this.outDirectory = this.outDirectory.getParentFile();
            return null;
        }
        this.outDirectory = null;
        return "cannot write to: " + filename;
    }

    public String findOutput(String previous) {
        JFrame cframe = new JFrame("Choose an output directory");
        String output = null;
        JFileChooser chooser = new JFileChooser();
        if (previous != null && previous.length() > 1) {
            File dir = new File(previous);
            chooser.setCurrentDirectory(dir);
        }
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Choose the output directory");
        int returnVal = chooser.showOpenDialog(cframe);
        if (returnVal == 0) {
            output = chooser.getSelectedFile().getPath();
        }
        return output;
    }

    public File getOutputDir() {
        if (this.outDirectory == null) {
            this.setOutputDir();
        }
        return this.outDirectory;
    }

    public String getOutputDirName() {
        if (this.outDirectory == null) {
            this.setOutputDir();
        }
        return this.outDirectory.getAbsolutePath();
    }

    public String findInput(String previous) {
        JFrame cframe = new JFrame("Choose a file or directory");
        this.input = null;
        JFileChooser chooser = new JFileChooser();
        if (previous != null && previous.length() > 1) {
            File f = new File(previous);
            File dir = f.getParentFile();
            chooser.setCurrentDirectory(dir);
        }
        chooser.setFileSelectionMode(2);
        chooser.setDialogTitle("Choose the input file or directory");
        int returnVal = chooser.showOpenDialog(cframe);
        if (returnVal == 0) {
            this.input = chooser.getSelectedFile();
            this.setFiles(this.input);
        }
        return this.input.getPath();
    }

    public String getDataType(String filename) {
        if (!this.types.containsKey(filename)) {
            this.readFirstLine(filename);
        }
        return this.types.get(filename);
    }

    public String getFormatType(String filename) {
        if (!this.types.containsKey(filename)) {
            this.readFirstLine(filename);
        }
        return this.formatType;
    }

    public String getChannelEndString(String filename) {
        if (!this.types.containsKey(filename)) {
            this.readFirstLine(filename);
        }
        return this.channelEndString;
    }

    public String getChannelStartString(String filename) {
        if (!this.types.containsKey(filename)) {
            this.readFirstLine(filename);
        }
        return this.channelStartString;
    }

    public void readFirstLine(String filename) {
        File file = new File(filename);
        int chars_read = 0;
        try {
            FileReader fr = new FileReader(file);
            char[] data2 = new char[80];
            chars_read = fr.read(data2, 0, 80);
            fr.close();
            String line = new String(data2, 0, chars_read).toLowerCase();
            int end = line.indexOf("\n");
            if (end > 0) {
                line = line.substring(0, end);
            }
            boolean isUncorrected = false;
            if (line.indexOf("spectra") > -1) {
                this.types.put(filename, "spectra");
            } else if (line.indexOf("uncorrected") > -1) {
                this.types.put(filename, "unprocessed");
                isUncorrected = true;
            } else {
                this.types.put(filename, "time series");
            }
            String testline = line.toLowerCase().trim();
            this.formatType = null;
            this.channelEndString = null;
            this.channelStartString = null;
            if (testline.contains("v01.20")) {
                this.channelEndString = "End-of-data";
                this.formatType = "cosm";
            } else if (testline.endsWith("for") || testline.endsWith("from")) {
                this.channelEndString = "/&";
                this.formatType = "dmg";
            } else if (testline.contains("uncorrected accelerogram data")) {
                this.channelEndString = "/&";
                this.formatType = "dmg";
            } else if (testline.contains("science")) {
                this.formatType = "gns";
                this.channelStartString = isUncorrected ? "Uncorrected accelerogram" : "Corrected accelerogram";
            } else if (testline.contains("gns")) {
                this.formatType = "gns";
                this.channelStartString = "Response Spectra";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getFileAsStrings(String filename) {
        int size;
        File file;
        String lineDelimiter;
        String wholeFile;
        block3: {
            wholeFile = null;
            lineDelimiter = "\n";
            try {
                file = new File(filename);
                size = (int)file.length();
                if (size != 0) break block3;
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        int chars_read = 0;
        FileReader in = new FileReader(file);
        char[] data2 = new char[size];
        chars_read = in.read(data2, 0, size);
        in.close();
        wholeFile = new String(data2, 0, chars_read);
        return wholeFile.split(lineDelimiter);
    }

    public String writeLines(String outfileName, String array) {
        try {
            FileWriter out = new FileWriter(outfileName);
            out.write(array);
            out.close();
        }
        catch (IOException e) {
            return "Error writing to " + outfileName + ": " + e.toString();
        }
        return null;
    }

    public String writeLines(String outfileName, StringBuffer sb) {
        try {
            FileWriter out = new FileWriter(outfileName);
            out.write(sb.toString());
            out.close();
        }
        catch (IOException e) {
            return "Error writing " + outfileName;
        }
        return "Wrote " + outfileName;
    }

    private void setFiles(File input) {
        try {
            if (input.isFile() && !input.isHidden()) {
                this.filenames = new String[1];
                this.filenames[0] = input.getAbsolutePath();
                this.inDirPath = input.getParentFile().getAbsolutePath();
                this.dates = new String[1];
                this.dates[0] = this.setCreationDate(input);
                this.types = new HashMap(1);
                this.isDir = false;
                this.isSingle = true;
            } else if (input.isDirectory()) {
                this.inDirPath = input.getAbsolutePath();
                File[] files = input.listFiles();
                this.filenames = new String[files.length];
                this.types = new HashMap(files.length);
                this.isDir = true;
                this.isSingle = false;
                int j = 0;
                while (j < files.length) {
                    this.filenames[j] = files[j].getAbsolutePath();
                    ++j;
                }
                this.dates = new String[files.length];
                int i = 0;
                while (i < files.length) {
                    this.dates[i] = this.setCreationDate(files[i]);
                    ++i;
                }
            } else {
                this.inDirPath = null;
                this.filenames = null;
                this.dates = null;
            }
        }
        catch (Exception e) {
            this.filenames = null;
        }
    }

    protected String setCreationDate(File fdir) {
        long createdDate = fdir.lastModified();
        try {
            DatatypeFactory dtf = DatatypeFactory.newInstance();
            Calendar regcal = Calendar.getInstance();
            regcal.setTimeInMillis(createdDate);
            XMLGregorianCalendar cal = dtf.newXMLGregorianCalendar((GregorianCalendar)regcal);
            return cal.toXMLFormat();
        }
        catch (Exception ee) {
            System.err.println("Error creating DatatypeFactory instance (used to convert file dates): " + ee.toString());
            return null;
        }
    }

    class CSMIPFileFilter
    implements FilenameFilter {
        CSMIPFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".V1") || name.endsWith(".V2") || name.endsWith(".V3");
        }
    }

    class CosmFileFilter
    implements FilenameFilter {
        CosmFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".COSM") || name.endsWith(".COSM");
        }
    }

    class NZFileFilter
    implements FilenameFilter {
        NZFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".V1A") || name.endsWith(".V2A") || name.endsWith(".V3A");
        }
    }

    class NotSplittableFileFilter
    implements FilenameFilter {
        NotSplittableFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return !name.endsWith(".V1A") && !name.endsWith(".V2A") && !name.endsWith(".V3A") && !name.endsWith(".V1") && !name.endsWith(".V2") && !name.endsWith(".V3");
        }
    }
}

