/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.to_tag;

import org.cosmos.to_tag.componentIF;
import org.cosmos.to_tag.data;
import org.cosmos.to_tag.expFormat;
import org.cosmos.to_tag.integerFormat;
import org.cosmos.to_tag.numberFormat;
import org.cosmos.to_tag.realFormat;

public class timeSeriesData
extends data
implements componentIF {
    protected String[] _stringNumbers;
    protected int ptsTo;
    protected String _absMax;

    @Override
    public String[] toStringArray() {
        return this._format.reformat(this._stringNumbers, this.maxLength, this._numberOfValues);
    }

    public String getMax() {
        return this._absMax;
    }

    public int getMaxLocation() {
        return this.ptsTo;
    }

    @Override
    public String[] getTimeSeriesAsStrings() {
        if (this._stringNumbers == null) {
            return null;
        }
        return this._stringNumbers;
    }

    @Override
    public void setLines(String[] compLines) {
        int lineLength;
        int i;
        int limit;
        int columns;
        int columnwidth;
        boolean isExpFormat;
        int index = 0;
        int valLength = 0;
        String temp = new String();
        boolean bl = isExpFormat = this._format instanceof expFormat;
        if (this._format.getType().equals("columnar")) {
            columnwidth = this._format.getColumnsPerNumber();
            columns = this._format.getNumberPerLine();
            limit = compLines.length * columns;
            this._stringNumbers = new String[limit];
            i = 0;
            while (i < compLines.length) {
                lineLength = compLines[i].length();
                int j = 0;
                while (j < columns) {
                    int start = j * columnwidth;
                    int end = start + columnwidth;
                    try {
                        temp = compLines[i].substring(start, end).trim();
                        valLength = temp.indexOf(".");
                        if (temp.startsWith(".")) {
                            temp = "0." + temp.substring(valLength + 1);
                        }
                        valLength = temp.indexOf("-.");
                        if (temp.startsWith("-.")) {
                            temp = "-0." + temp.substring(valLength + 2);
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        if (end > lineLength || temp.length() == 0) {
                            this._numberOfValues = index;
                            this.calculateMaxima();
                            return;
                        }
                        System.err.println("Index out of bounds on line:" + i + ", start=" + start + " end = " + end);
                        System.err.println("value=" + compLines[i]);
                    }
                    if (temp.length() == 0) {
                        this._numberOfValues = index;
                        this.calculateMaxima();
                        return;
                    }
                    if (isExpFormat) {
                        temp = this.reviseExp(temp);
                    }
                    this._stringNumbers[index++] = temp;
                    ++j;
                }
                ++i;
            }
        }
        if (this._format.getType().equals("delimited")) {
            columnwidth = this._format.getColumnsPerNumber();
            columns = this._format.getNumberPerLine();
            limit = compLines.length * columns;
            this._stringNumbers = new String[limit];
            i = 0;
            while (i < compLines.length) {
                lineLength = compLines[i].length();
                String[] lineVals = compLines[i].trim().split("\\s+");
                int j = 0;
                while (j < lineVals.length) {
                    int start = j * columnwidth;
                    int end = start + columnwidth;
                    try {
                        temp = lineVals[j].trim();
                        valLength = temp.indexOf(".");
                        if (temp.startsWith(".")) {
                            temp = "0." + temp.substring(valLength + 1);
                        }
                        valLength = temp.indexOf("-.");
                        if (temp.startsWith("-.")) {
                            temp = "-0." + temp.substring(valLength + 2);
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        if (end < columns || temp.length() == 0) {
                            this._numberOfValues = index;
                            this.calculateMaxima();
                            return;
                        }
                        System.err.println("Index out of bounds on line:" + i + ", start=" + start + " end = " + end);
                        System.err.println("value=" + compLines[i]);
                    }
                    if (temp.length() == 0) {
                        this._numberOfValues = index;
                        this.calculateMaxima();
                        return;
                    }
                    if (isExpFormat) {
                        temp = this.reviseExp(temp);
                    }
                    this._stringNumbers[index++] = temp;
                    ++j;
                }
                ++i;
            }
        }
        this._numberOfValues = index;
        this.calculateMaxima();
    }

    private void calculateMaxima() {
        double max = 0.0;
        this.ptsTo = 0;
        double temp = 0.0;
        int i = 0;
        while (i < this._numberOfValues) {
            try {
                temp = Math.abs(Double.parseDouble(this._stringNumbers[i]));
            }
            catch (Exception e) {
                System.out.println("problem number:" + this._stringNumbers[i]);
            }
            if (temp > max) {
                max = temp;
                this.ptsTo = i;
            }
            ++i;
        }
        this._absMax = this._stringNumbers[this.ptsTo];
        if (this._absMax.startsWith(".")) {
            this._absMax = "0".concat(this._absMax);
        }
        if (this._absMax.startsWith("-.")) {
            this._absMax = "-0".concat(this._absMax.substring(1));
        }
    }

    public void calculateMaxima(double mean) {
        double max = 0.0;
        this.ptsTo = 0;
        double temp = 0.0;
        int i = 0;
        while (i < this._numberOfValues) {
            try {
                temp = Math.abs(Double.parseDouble(this._stringNumbers[i]) - mean);
            }
            catch (Exception e) {
                System.out.println("problem number:" + this._stringNumbers[i]);
            }
            if (temp > max) {
                max = temp;
                this.ptsTo = i;
            }
            ++i;
        }
        this._absMax = this._stringNumbers[this.ptsTo];
        if (this._absMax.startsWith(".")) {
            this._absMax = "0".concat(this._absMax);
        }
        if (this._absMax.startsWith("-.")) {
            this._absMax = "-0".concat(this._absMax.substring(1));
        }
    }

    private String reviseExp(String temp) {
        int expPlaces = ((expFormat)this._format).getexpPlaces();
        if (expPlaces == 3) {
            return temp;
        }
        if (expPlaces == 2) {
            StringBuffer temp2 = new StringBuffer(temp.substring(0, temp.indexOf("E") + 2));
            temp2.append("0");
            temp2.append(temp.substring(temp.indexOf("E") + 2));
            return temp2.toString();
        }
        return temp;
    }

    public String[] getFortranFormat() {
        String[] formats = new String[1];
        this.setMaxLength();
        formats[0] = this.buildFormatString(this._format, "");
        return formats;
    }

    protected void setMaxLength() {
        String max = this.getMax().trim();
        this.maxLength = max.length();
        this.ineg = 0;
        if (!max.startsWith("-")) {
            this.ineg = 1;
        }
        this.maxLength += this.ineg;
    }

    protected String buildFormatString(numberFormat _format, String initial) {
        if (_format instanceof integerFormat) {
            return String.valueOf(initial) + "I" + this.maxLength;
        }
        int decimalPosition = this.getMax().trim().indexOf(".");
        int places = this.maxLength - (decimalPosition + this.ineg + 1);
        if (_format instanceof realFormat) {
            return String.valueOf(initial) + "F" + this.maxLength + "." + places;
        }
        if (_format instanceof expFormat) {
            return String.valueOf(initial) + "E" + this.maxLength + "." + (places -= 4);
        }
        return null;
    }
}

