/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.to_tag;

import java.math.BigDecimal;
import java.util.HashMap;
import org.cosmos.to_tag.parseableText;

public class textHeader
extends parseableText {
    private String _type;
    private int _numberOfLines;
    private String[] _lines;

    public String gettype() {
        return this._type;
    }

    public void settype(String value) {
        this._type = value;
    }

    public int getnumberOfLines() {
        return this._numberOfLines;
    }

    public void setnumberOfLines(String value) {
        this._numberOfLines = Integer.parseInt(value);
        this._lines = new String[this._numberOfLines];
    }

    public void paste(int lineNo, int startIndex, int numChars, String value) {
        if (value == null) {
            return;
        }
        String newValue = value;
        if (value.length() > numChars) {
            newValue = value.substring(0, numChars);
        } else if (value.length() < numChars) {
            StringBuffer blank = new StringBuffer();
            int i = 0;
            while (i < numChars) {
                blank.append(" ");
                ++i;
            }
            blank.replace(0, value.length(), value);
            newValue = blank.toString();
        }
        StringBuffer line = new StringBuffer(this._lines[lineNo]);
        line.replace(startIndex, startIndex + newValue.length(), newValue);
        this._lines[lineNo] = line.toString();
    }

    public void paste(int lineNo, int startIndex, int numChars, BigDecimal value) {
        if (value == null) {
            return;
        }
        this.paste(lineNo, startIndex, numChars, value.toString());
    }

    public void paste(int lineNo, int startIndex, int numChars, int value) {
        this.paste(lineNo, startIndex, numChars, String.valueOf(value));
    }

    public String getValue(HashMap attributes) {
        int lineEnd;
        Integer line = (Integer)attributes.get("headerLine");
        int lineNo = line - 1;
        int start = 0;
        int end = lineEnd = this._lines[lineNo].length();
        if (attributes.get("startColumn") != null) {
            start = (Integer)attributes.get("startColumn") - 1;
        }
        if (attributes.get("endColumn") != null) {
            end = (Integer)attributes.get("endColumn");
        }
        if (attributes.get("afterString") != null) {
            String aft = (String)attributes.get("afterString");
            if (this._lines[lineNo].indexOf(aft, start) > -1) {
                start = this._lines[lineNo].indexOf(aft, start) + aft.length();
            } else {
                return null;
            }
        }
        if (attributes.get("untilString") != null) {
            end = this._lines[lineNo].indexOf((String)attributes.get("untilString"), start);
        }
        if (end > lineEnd) {
            end = lineEnd;
        }
        if (start == end) {
            return null;
        }
        return this._lines[lineNo].substring(start, end).trim();
    }

    @Override
    public void setLines(String[] compLines) {
        int limit = this.getnumberOfLines();
        this._lines = new String[limit];
        int i = 0;
        while (i < limit) {
            this._lines[i] = compLines[i];
            ++i;
        }
    }

    public String getLine(int index) {
        return this._lines[index - 1];
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._lines.length) {
            sb.append(String.valueOf(this._lines[i]) + "\n");
            ++i;
        }
        return sb.toString();
    }
}

