/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.to_tag;

import org.cosmos.to_tag.componentIF;
import org.cosmos.to_tag.data;
import org.cosmos.to_tag.expFormat;
import org.cosmos.to_tag.integerFormat;
import org.cosmos.to_tag.numberFormat;
import org.cosmos.to_tag.periods;
import org.cosmos.to_tag.realFormat;

public class responseSpectraData
extends data
implements componentIF {
    protected String[][] _stringNumbers;
    protected static String[] _damping;
    protected static periods _per;
    protected String[] _periodAtMax;
    protected int periodLength;
    protected String[] _absMax;

    public int getNumberOfDampingValues() {
        return _damping != null ? _damping.length : 0;
    }

    public void setDamping(String[] damping) {
        _damping = damping;
    }

    public String[] getDamping() {
        return _damping;
    }

    public void setPeriods(periods per) {
        _per = per;
    }

    public String getMaxPoint(int index) {
        return this._periodAtMax[index];
    }

    public String getMax(int index) {
        return this._absMax[index];
    }

    @Override
    public String[] toStringArray() {
        return this._format.reformat(this._stringNumbers, _per, _damping.length, this.periodLength, this.maxLength);
    }

    public void setLines(String[] compLines, int dampIndex) {
        int index = 0;
        String temp = new String();
        if (this._format.getType().equals("columnar")) {
            int columnwidth = this._format.getColumnsPerNumber();
            int columns = this._format.getNumberPerLine();
            if (dampIndex == 0) {
                int limit = compLines.length * columns;
                this._stringNumbers = new String[_damping.length][limit];
                this._periodAtMax = new String[_damping.length];
                this._absMax = new String[_damping.length];
            }
            int i = 0;
            while (i < compLines.length) {
                int lineLength = compLines[i].length();
                int j = 0;
                while (j < columns) {
                    int start = j * columnwidth;
                    int end = start + columnwidth;
                    try {
                        temp = compLines[i].substring(start, end).trim();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        if (end > lineLength || temp.length() == 0) {
                            this._numberOfValues = index;
                            this.calculateMaximum(dampIndex);
                            return;
                        }
                        System.err.println("Index out of bounds on line:" + i + ", start=" + start + " end = " + end);
                        System.err.println("value=" + compLines[i]);
                    }
                    if (temp.length() == 0) {
                        this._numberOfValues = index;
                        this.calculateMaximum(dampIndex);
                        return;
                    }
                    this._stringNumbers[dampIndex][index++] = temp;
                    ++j;
                }
                ++i;
            }
        }
        this._numberOfValues = index;
        this.calculateMaximum(dampIndex);
    }

    private void calculateMaximum(int dampindex) {
        double max = 0.0;
        int _ptsToMax = 0;
        int i = 0;
        while (i < this._numberOfValues) {
            double temp = Math.abs(Double.parseDouble(this._stringNumbers[dampindex][i]));
            if (temp > max) {
                max = temp;
                _ptsToMax = i;
            }
            ++i;
        }
        String tempmax = this._stringNumbers[dampindex][_ptsToMax];
        if (tempmax.startsWith(".")) {
            tempmax = "0" + tempmax;
        }
        if (tempmax.startsWith("-.")) {
            tempmax = "-0" + tempmax.substring(1);
        }
        this._absMax[dampindex] = tempmax;
        String tempper = _per.getPeriod(_ptsToMax);
        if (tempper.startsWith(".")) {
            tempper = "0" + tempper;
        }
        this._periodAtMax[dampindex] = tempper;
    }

    public String[] getFortranFormat() {
        String periodFormat;
        this.setMaxLength();
        int numformats = this.getNumberOfDampingValues() + 1;
        String[] formats = new String[numformats];
        String lastPeriod = _per.getPeriod(responseSpectraData._per._numberOfValues - 1);
        this.periodLength = lastPeriod.trim().length();
        String periodFormatType = lastPeriod.indexOf("E") > -1 ? "E" : "F";
        int decimalPosition = lastPeriod.indexOf(".");
        int places = this.periodLength - (decimalPosition + 1);
        if (periodFormatType.indexOf("E") > -1) {
            places -= 4;
        }
        formats[0] = periodFormat = String.valueOf(periodFormatType) + this.periodLength + "." + places;
        String specformat = this.buildFormatString(this._format, "");
        int i = 1;
        while (i < numformats) {
            formats[i] = specformat;
            ++i;
        }
        return formats;
    }

    protected void setMaxLength() {
        String max = this.getMax(0).trim();
        this.maxLength = max.length();
        this.ineg = 0;
        if (!max.startsWith("-")) {
            this.ineg = 1;
        }
        this.maxLength += this.ineg;
    }

    protected String buildFormatString(numberFormat _format, String initial) {
        if (_format instanceof integerFormat) {
            return String.valueOf(initial) + "I" + this.maxLength;
        }
        int decimalPosition = this.getMax(0).trim().indexOf(".");
        int places = this.maxLength - (decimalPosition + this.ineg + 1);
        if (_format instanceof realFormat) {
            return String.valueOf(initial) + "F" + this.maxLength + "." + places;
        }
        if (_format instanceof expFormat) {
            return String.valueOf(initial) + "E" + this.maxLength + "." + (places -= 4);
        }
        return null;
    }
}

