/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.to_tag;

import java.math.BigDecimal;
import org.cosmos.to_tag.component;
import org.cosmos.to_tag.expFormat;
import org.cosmos.to_tag.integerFormat;
import org.cosmos.to_tag.numberFormat;
import org.cosmos.to_tag.realFormat;

public class numberHeader
extends component {
    protected int _numberOfValues;
    protected String[] _nullValue;
    protected String[] _stringNumbers;
    protected numberFormat _format;

    public numberFormat getFormat() {
        return this._format;
    }

    public int getNumberOfValues() {
        return this._numberOfValues;
    }

    public void setValue(int index, double value) {
        this._stringNumbers[index] = String.valueOf(value);
    }

    public void setValue(int index, BigDecimal value) {
        if (value != null) {
            this._stringNumbers[index] = value.toString();
        }
    }

    public void setValue(int index, String value) {
        if (value != null) {
            this._stringNumbers[index] = value;
        }
    }

    public void setValue(int index, int value) {
        this._stringNumbers[index] = String.valueOf(value);
    }

    public void setNullValue(String[] value) {
        if (this._nullValue == null) {
            this._nullValue = new String[value.length];
        }
        int i = 0;
        while (i < value.length) {
            this._nullValue[i] = value[i].trim();
            ++i;
        }
    }

    public String[] getNullValue() {
        return this._nullValue;
    }

    public void initArray() {
        int i = 0;
        while (i < this._numberOfValues) {
            this._stringNumbers[i] = this._nullValue[0];
            ++i;
        }
    }

    public void setNumberOfValues(String value) {
        this._numberOfValues = Integer.parseInt(value);
    }

    @Override
    public void addComponent(Object component2) {
        this._format = component2 instanceof realFormat ? (realFormat)component2 : (component2 instanceof expFormat ? (expFormat)component2 : (integerFormat)component2);
    }

    @Override
    public int getNumberOfLines() {
        int lines = this.getNumberOfValues();
        int n = this._format.getNumberPerLine();
        if (n != 0) {
            lines /= n;
            if (this.getNumberOfValues() % n > 0) {
                ++lines;
            }
        } else {
            System.err.println("numberPerLine in header is zero or not set to a value");
        }
        return lines;
    }

    @Override
    public void setLines(String[] compLines) {
        int index = 0;
        int columnwidth = this._format.getColumnsPerNumber();
        int columns = this._format.getNumberPerLine();
        int max = this.getNumberOfValues();
        if (max == 0) {
            max = columns * columnwidth;
        }
        this._stringNumbers = new String[max];
        int start = 0;
        int end = 0;
        int lineEnd = 0;
        int i = 0;
        while (i < compLines.length) {
            lineEnd = compLines[i].length();
            int j = 0;
            while (j < columns) {
                block7: {
                    start = j * columnwidth;
                    end = start + columnwidth;
                    if (end > lineEnd) {
                        end = lineEnd;
                    }
                    if (start == end) {
                        return;
                    }
                    String temp = compLines[i].substring(start, end).trim();
                    try {
                        this._stringNumbers[index++] = temp;
                    }
                    catch (Exception e) {
                        if (index < max) break block7;
                        return;
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

