/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.to_tag;

import org.cosmos.to_tag.componentIF;
import org.cosmos.to_tag.data;
import org.cosmos.to_tag.expFormat;
import org.cosmos.to_tag.integerFormat;
import org.cosmos.to_tag.numberFormat;
import org.cosmos.to_tag.periods;
import org.cosmos.to_tag.realFormat;

public class fourierData
extends data
implements componentIF {
    protected periods _per;
    protected String[] _stringNumbers;
    protected int periodLength;
    protected int _ptsToMax;
    protected String _absMax;
    protected String _periodAtMax;

    public fourierData() {
        this._dataType = "Acceleration Amplitude Spectrum";
        this._dataTypeShort = "DFT";
    }

    public void setPeriods(periods per) {
        this._per = per;
    }

    @Override
    public String[] toStringArray() {
        return this._format.reformat(this._stringNumbers, this._per, this.periodLength, this.maxLength);
    }

    public String getMaxPoint() {
        return this._periodAtMax;
    }

    public String getMax() {
        return this._absMax;
    }

    @Override
    public void setLines(String[] compLines) {
        int index = 0;
        int skip = this._format.getSkip();
        String temp = new String();
        if (this._format.getType().equals("columnar")) {
            int columnwidth = this._format.getColumnsPerNumber();
            int columns = this._format.getNumberPerLine();
            int limit = compLines.length * columns;
            this._stringNumbers = new String[limit];
            int i = 0;
            while (i < compLines.length) {
                int lineLength = compLines[i].length();
                int j = 0;
                while (j < columns) {
                    int start = j * columnwidth + skip;
                    int end = start + columnwidth;
                    try {
                        temp = compLines[i].substring(start, end).trim();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        if (end > lineLength || temp.length() == 0) {
                            this._numberOfValues = index;
                            this.calculateMaximum();
                            return;
                        }
                        System.out.println("Index out of bounds on line:" + i + ", start=" + start + " end = " + end);
                        System.out.println("value=" + compLines[i]);
                    }
                    if (temp.length() == 0) {
                        this._numberOfValues = index;
                        this.calculateMaximum();
                        return;
                    }
                    this._stringNumbers[index++] = temp;
                    ++j;
                }
                ++i;
            }
        }
        this._numberOfValues = index;
        this.calculateMaximum();
    }

    private void calculateMaximum() {
        double max = 0.0;
        this._ptsToMax = 0;
        int i = 0;
        while (i < this._numberOfValues) {
            double temp = Math.abs(Double.parseDouble(this._stringNumbers[i]));
            if (temp > max) {
                max = temp;
                this._ptsToMax = i;
            }
            ++i;
        }
        this._absMax = this._stringNumbers[this._ptsToMax];
        this._periodAtMax = this._per.getPeriod(this._ptsToMax);
    }

    public String[] getFortranFormat() {
        String periodFormat;
        this.setMaxLength();
        String[] formats = new String[2];
        String lastPeriod = this._per.getPeriod(this._per._numberOfValues - 1);
        this.periodLength = lastPeriod.trim().length();
        String periodFormatType = lastPeriod.indexOf("E") > -1 ? "E" : "F";
        int decimalPosition = lastPeriod.indexOf(".");
        int places = this.periodLength - (decimalPosition + 1);
        if (periodFormatType.indexOf("E") > -1) {
            places -= 4;
        }
        formats[0] = periodFormat = String.valueOf(periodFormatType) + this.periodLength + "." + places;
        formats[1] = this.buildFormatString(this._format, "");
        return formats;
    }

    protected void setMaxLength() {
        String max = this.getMax().trim();
        this.maxLength = max.length();
        this.ineg = 0;
        if (!max.startsWith("-")) {
            this.ineg = 1;
        }
        this.maxLength += this.ineg;
    }

    protected String buildFormatString(numberFormat _format, String initial) {
        if (_format instanceof integerFormat) {
            return String.valueOf(initial) + "I" + this.maxLength;
        }
        int decimalPosition = this.getMax().trim().indexOf(".");
        int places = this.maxLength - (decimalPosition + this.ineg + 1);
        if (_format instanceof realFormat) {
            return String.valueOf(initial) + "F" + this.maxLength + "." + places;
        }
        if (_format instanceof expFormat) {
            return String.valueOf(initial) + "E" + this.maxLength + "." + (places -= 4);
        }
        return null;
    }
}

