/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.to_tag;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.cosmos.to_tag.MatrixRow;

public class TranslationMatrix {
    String rowname;
    private TreeMap<String, MatrixRow> list = new TreeMap();
    private int maxHeaderLines = 300;
    private int longestTagLength;

    protected void addRule(String rowname, String defaultValue, Class valueType, boolean vreq, boolean ureq, String units, Method setMethod, Method getMethod) {
        String extension = rowname.substring(rowname.length() - 3, rowname.length());
        MatrixRow mr = new MatrixRow(defaultValue, valueType, vreq, ureq, units, setMethod, getMethod, extension);
        this.list.put(rowname, mr);
    }

    protected void addSourceParameters(String rowname, Object sourceRef, Class sourceType, int sourceIndex, HashMap attributes) {
        this.list.get(rowname).setSource(sourceRef, sourceType, sourceIndex, attributes);
    }

    protected Object getSource(String rowname) {
        return this.list.get(rowname).getSource();
    }

    protected int getSourceIndex(String rowname) {
        return this.list.get(rowname).getIndex();
    }

    protected Class getSourceType(String rowname) {
        return this.list.get(rowname).getSourceType();
    }

    protected Method getSetMethod(String rowname) {
        return this.list.get(rowname).getSetMethod();
    }

    protected Method getGetMethod(String rowname) {
        return this.list.get(rowname).getGetMethod();
    }

    protected Class getParameterType(String rowname) {
        return this.list.get(rowname).getDataType();
    }

    protected HashMap getAttributes(String rowname) {
        return this.list.get(rowname).getAttributes();
    }

    protected boolean isValueRequired(String rowname) {
        return this.list.get(rowname).isValueRequired();
    }

    protected boolean isUnitsRequired(String rowname) {
        return this.list.get(rowname).isUnitsRequired();
    }

    protected boolean isRule(String rowname) {
        return this.list.containsKey(rowname);
    }

    protected boolean isEmpty() {
        return this.list.isEmpty();
    }

    protected String[] getRownames() {
        Iterator<String> it = this.list.keySet().iterator();
        String[] str = new String[this.list.size()];
        int index = 0;
        while (it.hasNext()) {
            str[index++] = it.next();
        }
        return str;
    }

    protected String[] getRownames(String firstKey, String lastKey) {
        SortedMap<String, MatrixRow> tm = this.list.subMap(firstKey, lastKey);
        Iterator<String> it = tm.keySet().iterator();
        String[] sb = new String[tm.size()];
        int index = 0;
        while (it.hasNext()) {
            sb[index++] = it.next();
        }
        return sb;
    }

    protected void resetElement(String fragment, String value) {
        Iterator<String> it = this.list.keySet().iterator();
        boolean wasReset = false;
        while (it.hasNext()) {
            String rowname = it.next();
            if (rowname.indexOf(fragment) <= -1) continue;
            MatrixRow mr = this.list.get(rowname);
            if (rowname.indexOf("_txt") > 0 && value != null) {
                value = "\"" + value + "\"";
            }
            mr.setValue(value);
            wasReset = true;
            return;
        }
    }

    protected void resetElement(String fragment, String value, String units) {
        for (String rowname : this.list.keySet()) {
            if (rowname.indexOf(fragment) <= -1) continue;
            MatrixRow mr = this.list.get(rowname);
            mr.setValue(value);
            mr.setUnits(units);
            return;
        }
    }

    protected void setUnits(String fragment, String units) {
        for (String rowname : this.list.keySet()) {
            if (rowname.indexOf(fragment) <= -1) continue;
            MatrixRow mr = this.list.get(rowname);
            mr.setUnits(units);
            return;
        }
    }

    protected void setDamping(String[] dampvalues) {
        Iterator<String> it = this.list.keySet().iterator();
        int max = dampvalues.length + 1;
        if (max < 2) {
            return;
        }
        String newrow = "";
        int startIndex = 0;
        while (it.hasNext()) {
            String rowname = it.next();
            if (rowname.indexOf("DataSeries.ResponseSpectrumDamping(1)") <= -1) continue;
            this.setValue(rowname, dampvalues[0]);
            int i = 2;
            while (i < max) {
                startIndex = rowname.indexOf("(") + 1;
                newrow = String.valueOf(rowname.substring(0, startIndex)) + i + rowname.substring(rowname.indexOf(")"));
                this.copyRow(rowname, newrow);
                this.setValue(newrow, dampvalues[i - 1].trim());
                ++i;
            }
            return;
        }
    }

    protected void setValue(String rowname, String value) {
        MatrixRow mr = this.list.get(rowname);
        mr.setValue(value);
    }

    protected String getValue(String rowname) {
        MatrixRow mr = this.list.get(rowname);
        if (mr.hasValue()) {
            return mr.getValue();
        }
        return null;
    }

    protected boolean hasValue(String rowname) {
        try {
            MatrixRow mr = this.list.get(rowname);
            return mr.hasValue();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void clearValues() {
        for (String this.rowname : this.list.keySet()) {
            MatrixRow mr = this.list.get(this.rowname);
            mr.resetRow();
        }
    }

    protected String processMatrix() {
        Iterator<String> it = this.list.keySet().iterator();
        String value = null;
        Object[] attributes = new Object[1];
        Method meth = null;
        while (it.hasNext()) {
            this.rowname = it.next();
            MatrixRow mr = this.list.get(this.rowname);
            if (!mr.hasGetMethod()) continue;
            try {
                meth = mr.getGetMethod();
                attributes[0] = mr.getAttributes();
                value = (String)meth.invoke(mr.getSource(), attributes);
            }
            catch (Exception e) {
                value = null;
                return "couldn't invoke method for " + this.rowname.substring(4) + ": " + e.toString();
            }
            if (value == null) continue;
            if (this.rowname.indexOf("_txt") > -1) {
                value = "\"" + value + "\"";
            }
            mr.setValue(value);
        }
        return null;
    }

    protected StringBuffer getHeaderLines(String commentTag) {
        StringBuffer lines = new StringBuffer("");
        Iterator<String> it = this.list.keySet().iterator();
        String tag = null;
        String value = null;
        String begOfLine = null;
        while (it.hasNext()) {
            this.rowname = it.next();
            MatrixRow mr = this.list.get(this.rowname);
            if (!mr.hasValue()) continue;
            tag = this.rowname.substring(this.rowname.indexOf("_") + 1, this.rowname.length());
            begOfLine = tag.concat("\t").concat("= ");
            value = mr.getValue();
            String units = mr.getUnits();
            if (units == null) {
                units = "";
            }
            lines = lines.append(String.valueOf(begOfLine.concat(value).concat(" ").concat(units)) + "; ");
            if (mr.hasComment()) {
                lines = lines.append(String.valueOf(commentTag) + " " + mr.getComment());
            }
            lines = lines.append("\n");
        }
        return lines;
    }

    protected String[] getHeaderArray(String commentTag) {
        String[] lines = new String[this.maxHeaderLines];
        Iterator<String> it = this.list.keySet().iterator();
        this.longestTagLength = 0;
        int spaces = 0;
        MatrixRow mr = null;
        while (it.hasNext()) {
            this.rowname = it.next();
            mr = this.list.get(this.rowname);
            if (!mr.hasValue() || this.rowname.length() <= this.longestTagLength) continue;
            this.longestTagLength = this.rowname.length();
        }
        this.longestTagLength -= 3;
        String tag = null;
        String value = null;
        String begOfLine = null;
        Object endOfLine = null;
        int i = 0;
        for (String this.rowname : this.list.keySet()) {
            mr = this.list.get(this.rowname);
            if (!mr.hasValue()) continue;
            begOfLine = tag = this.rowname.substring(this.rowname.indexOf("_") + 1, this.rowname.length());
            spaces = this.longestTagLength - begOfLine.length();
            int j = 0;
            while (j < spaces) {
                begOfLine = begOfLine.concat(" ");
                ++j;
            }
            begOfLine = begOfLine.concat("= ");
            value = mr.getValue();
            String units = mr.getUnits();
            lines[i] = units == null ? String.valueOf(begOfLine.concat(value)) + ";" : String.valueOf(begOfLine.concat(value).concat(" ").concat(units)) + ";";
            if (mr.hasComment()) {
                lines[i] = String.valueOf(lines[i].concat(" ").concat(commentTag).concat(" ")) + mr.getComment();
            }
            ++i;
        }
        String[] lineset = new String[i];
        int j = 0;
        while (j < i) {
            lineset[j] = lines[j];
            ++j;
        }
        return lineset;
    }

    protected String getContentTagSpaces(String contentTag) {
        int spaces = this.longestTagLength - contentTag.length();
        String spaceString = "";
        int j = 0;
        while (j < spaces) {
            spaceString = spaceString.concat(" ");
            ++j;
        }
        return spaceString;
    }

    protected void copyRow(String oldRule, String newRule) {
        MatrixRow mr = this.list.get(oldRule);
        Class dataType = mr.getDataType();
        Method setMethod = mr.getSetMethod();
        Method getMethod = mr.getGetMethod();
        String units = mr.getUnits();
        boolean vreq = mr.isValueRequired();
        boolean ureq = mr.isUnitsRequired();
        Object source = mr.getSource();
        Class sourceType = mr.getSourceType();
        HashMap attributes = mr.getAttributes();
        int sourceIndex = mr.getSourceIndex();
        String extension = oldRule.substring(this.rowname.length() - 3, this.rowname.length());
        MatrixRow mrNew = new MatrixRow(null, dataType, vreq, ureq, units, setMethod, getMethod, extension);
        this.list.put(newRule, mrNew);
        mr = this.list.get(newRule);
        mr.setSource(source, sourceType, sourceIndex, attributes);
    }
}

