/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.to_tag;

import org.cosmos.to_tag.FileFetcher;
import org.cosmos.to_tag.TableSet;
import org.cosmos.to_tag.component;

public class TableHandler
extends component {
    private String _filePath;
    private TableSet tab = new TableSet();
    private int _headerLinesToSkip = 1;

    public TableHandler(String tableFilepath, int headerLinesToSkip) {
        this.setTableLines(tableFilepath, headerLinesToSkip);
    }

    public TableHandler() {
    }

    public void setFileName(String tableFilePath) {
        this._filePath = tableFilePath;
    }

    public void setLinesToskip(int lines) {
        this._headerLinesToSkip = lines;
    }

    public void setTableLines(String tableFilepath) {
        this.setTableLines(tableFilepath, this._headerLinesToSkip);
    }

    public void setTableLines() {
        this.setTableLines(this._filePath, this._headerLinesToSkip);
    }

    public String setTableLines(String tableFilepath, int headerLinesToSkip) {
        try {
            FileFetcher ff = new FileFetcher();
            this._filePath = tableFilepath;
            this._headerLinesToSkip = headerLinesToSkip;
            this.tab.addRows(ff.readTable(this._filePath), this._headerLinesToSkip);
        }
        catch (Exception e) {
            return "Error reading input table: " + e.toString();
        }
        return null;
    }

    public String getValue(int table, int index) {
        return this.tab.getValue(table, index, 1);
    }

    public String getValue(int table, int index, int column) {
        return this.tab.getValue(table, index, column);
    }

    public boolean isInTable(int table, String value, int column) {
        return this.tab.hasValue(table, value, column);
    }

    public int getIndex(int table, String value, int column) {
        return this.tab.getIndex(table, value, column);
    }
}

