/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.to_tag;

import java.util.HashMap;
import org.cosmos.to_tag.DateTime;
import org.cosmos.to_tag.FileFetcher;
import org.cosmos.to_tag.MatrixHandler;
import org.cosmos.to_tag.TableHandler;
import org.cosmos.to_tag.data;
import org.cosmos.to_tag.template;

public class ProcessFormat {
    protected String[] componentTypes = new String[0];
    protected template templ;
    protected FileFetcher ff;
    protected String[] lines;
    public String[] spec;
    protected TableHandler th;
    protected String prefix;
    protected String outputFileNamePrefix;
    protected String preparingAgency;
    protected String VDC_id;
    protected String formatdir;
    protected String directory;
    protected int maxformats = 7;

    public ProcessFormat(String dir) {
        this.formatdir = dir;
        this.spec = new String[]{"SdData", "SvData", "SaData"};
        this.prefix = String.valueOf(this.getClass().getPackage().getName()) + ".";
    }

    public void setTableHandler(TableHandler tabh) {
        this.th = tabh;
    }

    public void setTemplate() {
        this.templ = new template();
        this.templ.setTemplate(this.componentTypes);
    }

    public String getFormatDir() {
        return this.formatdir;
    }

    public data[] getData() {
        return this.templ.getDataSets();
    }

    public template getTemplate() {
        return this.templ;
    }

    public String setComponents() {
        return null;
    }

    public void resetElements(MatrixHandler mh, data dats) {
        mh.resetElement("DataSeries.PhysicalParameter_txt", dats.getDataName());
    }

    public void readFile(String filename) {
        this.ff = new FileFetcher(filename);
        this.lines = this.ff.getLines();
    }

    public String getOutputFileName(String datatype) {
        String name = this.outputFileNamePrefix;
        String agency = "networkcode";
        name = String.valueOf(name) + "_" + agency;
        String site = "site";
        name = String.valueOf(name) + "_" + site + "_" + datatype + ".cosm";
        return this.fixFileName(name);
    }

    public String fixFileName(String inputName) {
        String name = inputName;
        name = name.replaceAll("/", "-");
        name = name.replaceAll(":", "_");
        name = name.replaceAll(" ", "");
        return name;
    }

    public String[] extractLines(int startLine, int numLines) {
        try {
            String[] tlines = new String[numLines];
            int i = 0;
            while (i < numLines) {
                tlines[i] = this.lines[i + startLine];
                ++i;
            }
            return tlines;
        }
        catch (Exception e) {
            System.out.println("Couldn't extract lines from the input file: " + e.toString());
            return null;
        }
    }

    protected void setFormats(MatrixHandler mh, String[] formats) {
        int i = 1;
        while (i < formats.length) {
            mh.resetElement("DataSeries.OrdinateFormat(" + i + ")", formats[i]);
            ++i;
        }
        i = formats.length;
        while (i <= this.maxformats) {
            mh.resetElement("DataSeries.OrdinateFormat(" + i + ")", null);
            ++i;
        }
    }

    public String getToday(HashMap attributes) {
        DateTime dt = new DateTime();
        return dt.getNow();
    }

    public String getVDC_ID(HashMap attributes) {
        return this.VDC_id;
    }

    public void setVDC_ID(String id) {
        this.VDC_id = id;
    }

    public String getPrepAgency(HashMap attributes) {
        return this.preparingAgency;
    }

    public void setPrepAgency(String agency) {
        this.preparingAgency = agency;
    }
}

