/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.to_tag;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.cosmos.to_tag.ProcessFormat;
import org.cosmos.to_tag.TableHandler;
import org.cosmos.to_tag.TranslationMatrix;
import org.cosmos.to_tag.template;

public class MatrixHandler {
    private TranslationMatrix tm = new TranslationMatrix();
    private TableHandler th;
    private String[] numberAttributes;
    private HashMap<String, Method> methods;
    private String[] headerTypes = new String[]{"integer", "real", "text"};
    private HashMap<String, Class> valueClasses;

    public MatrixHandler() {
        this.numberAttributes = new String[]{"index", "tableNumber", "tableColumn", "headerLine", "startColumn", "endColumn"};
        this.valueClasses = new HashMap();
        this.valueClasses.put("dbl", BigDecimal.class);
        this.valueClasses.put("txt", String.class);
        this.valueClasses.put("cpx", String.class);
        this.valueClasses.put("datetime", XMLGregorianCalendar.class);
        this.valueClasses.put("int", Integer.class);
    }

    public void addTables(TableHandler thandler) {
        this.th = thandler;
    }

    public String[] getRownames() {
        return this.tm.getRownames();
    }

    public String[] getRownames(String beg, String end) {
        return this.tm.getRownames(beg, end);
    }

    public String process() {
        return this.tm.processMatrix();
    }

    public void reset() {
        this.tm.clearValues();
    }

    public void resetElement(String rowFragment, String value) {
        this.tm.resetElement(rowFragment, value);
    }

    public void resetElement(String rowFragment, String value, String units) {
        this.tm.resetElement(rowFragment, value, units);
    }

    public void setUnits(String rowFragment, String units) {
        this.tm.setUnits(rowFragment, units);
    }

    public void setDamping(String[] damping) {
        this.tm.setDamping(damping);
    }

    public String getRemainingSpaces(String contentTag) {
        return this.tm.getContentTagSpaces(contentTag);
    }

    public String fillMatrix(String[] rows, template _temp, ProcessFormat pf) {
        int length = rows.length;
        int tableColumns = 19;
        int headerLines = 1;
        String key = null;
        String defaultValue = null;
        String val = null;
        String tag = null;
        String defaultUnits = null;
        String headerType = null;
        int headerSeqNo = 0;
        String[] svals = new String[tableColumns];
        boolean unitsRequired = false;
        boolean valueRequired = false;
        Class valueType = null;
        this.methods = this.getMethods(this.headerTypes, _temp);
        String delimiter = null;
        String special = null;
        Class<?> process = pf.getClass();
        Method getMethod = null;
        Object obj = null;
        try {
            int j = headerLines;
            while (j < length) {
                String[] tvals = rows[j].split("\t");
                int columns = tvals.length;
                if (columns > tableColumns) {
                    columns = tableColumns;
                }
                int i = 0;
                while (i < columns) {
                    svals[i] = tvals[i].trim();
                    ++i;
                }
                i = columns;
                while (i < tableColumns) {
                    svals[i] = null;
                    ++i;
                }
                try {
                    tag = svals[1];
                    String orderNumber = svals[0];
                    if (orderNumber == null || orderNumber.length() == 0) {
                        System.err.println("ordernumber: " + orderNumber);
                        orderNumber = "000";
                    }
                    if (orderNumber.length() == 1) {
                        orderNumber = "00" + orderNumber;
                    }
                    if (orderNumber.length() == 2) {
                        orderNumber = "0" + orderNumber;
                    }
                    key = String.valueOf(orderNumber) + "_" + tag;
                    valueRequired = svals[2].toLowerCase().indexOf("req") > -1;
                    try {
                        unitsRequired = svals[3].toLowerCase().indexOf("y") > -1;
                    }
                    catch (Exception e) {
                        return " error on line:" + j + " error:" + e.toString();
                    }
                    defaultUnits = svals[4].length() < 1 ? null : svals[4];
                    defaultValue = null;
                    try {
                        if (svals[5].length() > 0) {
                            defaultValue = svals[5];
                            if (defaultValue.startsWith("\"")) {
                                defaultValue = defaultValue.substring(1);
                            }
                            if (defaultValue.endsWith("\"")) {
                                defaultValue = defaultValue.substring(0, defaultValue.lastIndexOf("\""));
                            }
                        }
                    }
                    catch (Exception ee) {
                        return "error processing " + svals[1] + ": " + ee.toString();
                    }
                    String valueTypeName = tag.substring(tag.indexOf("_") + 1, tag.length());
                    valueType = this.valueClasses.get(valueTypeName);
                    if (tag.toLowerCase().indexOf("datetime") > -1) {
                        valueType = this.valueClasses.get("datetime");
                    }
                    headerType = svals[8];
                    try {
                        headerSeqNo = Integer.valueOf(svals[9]);
                    }
                    catch (Exception e) {
                        headerSeqNo = 1;
                    }
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    int k = 0;
                    while (k < this.numberAttributes.length) {
                        val = svals[k + 10];
                        try {
                            attributes.put(this.numberAttributes[k], Integer.valueOf(val));
                        }
                        catch (Exception e) {
                            attributes.put(this.numberAttributes[k], null);
                        }
                        ++k;
                    }
                    delimiter = svals[16] != null && svals[16].length() > 0 ? svals[16] : null;
                    attributes.put("afterString", delimiter);
                    delimiter = svals[17] != null && svals[17].length() > 0 ? svals[17] : null;
                    attributes.put("untilString", delimiter);
                    if (svals[18] != null && svals[18].length() > 0) {
                        special = "get" + svals[18];
                        try {
                            Class[] parameterTypes = new Class[]{HashMap.class};
                            getMethod = process.getMethod(special, parameterTypes);
                            obj = pf;
                        }
                        catch (Exception e) {
                            return "could not create special method: " + special + ", error: " + e.toString();
                        }
                    } else {
                        getMethod = this.methods.get(headerType);
                        obj = _temp.getComponent(String.valueOf(headerType) + "Header", headerSeqNo);
                    }
                    this.tm.addRule(key, defaultValue, valueType, valueRequired, unitsRequired, defaultUnits, null, getMethod);
                    if (obj != null) {
                        this.tm.addSourceParameters(key, obj, obj.getClass(), headerSeqNo, attributes);
                    }
                }
                catch (Error e) {
                    return "could not parse input line: " + e.toString();
                }
                ++j;
            }
        }
        catch (Exception eee) {
            return "error traversing translation table: " + eee.toString();
        }
        return null;
    }

    private HashMap<String, Method> getMethods(String[] headerTypes, template _temp) {
        HashMap<String, Method> getmethods = new HashMap<String, Method>();
        Method meth = null;
        Class[] parameterTypes = new Class[]{HashMap.class};
        String methodName = "getValue";
        int i = 0;
        while (i < headerTypes.length) {
            String cl = headerTypes[i];
            try {
                Object o = _temp.getComponent(String.valueOf(cl) + "Header", 1);
                Class<?> c = o.getClass();
                meth = c.getMethod(methodName, parameterTypes);
                getmethods.put(cl, meth);
            }
            catch (Exception e) {
                System.err.println("couldn't find a method for the class: " + cl + "Header " + e.toString());
                System.exit(1);
            }
            ++i;
        }
        return getmethods;
    }

    public String getHeader(String commentString) {
        StringBuffer sb = this.tm.getHeaderLines(commentString);
        String outputString = null;
        if (sb != null) {
            outputString = sb.toString();
        }
        return outputString;
    }

    public String[] getHeaderArray(String commentString) {
        return this.tm.getHeaderArray(commentString);
    }

    public void finalize() {
        int k;
        String[] rows = this.getRownames();
        ArrayList<String> magrows = new ArrayList<String>(0);
        ArrayList<String> sarows = new ArrayList<String>(0);
        String prefix = "";
        String magNumber = "";
        String temp = "";
        String thisRow = "";
        boolean j = false;
        int i = 0;
        while (i < rows.length) {
            if (rows[i].indexOf("Magnitude") > -1) {
                magrows.add(rows[i]);
            }
            ++i;
        }
        i = 0;
        while (i < magrows.size()) {
            thisRow = (String)magrows.get(i);
            if (!(thisRow.indexOf(".Value") <= -1 || this.tm.hasValue(thisRow) && this.tm.getValue(thisRow).trim().length() != 0)) {
                magNumber = thisRow.substring(thisRow.indexOf("."), thisRow.lastIndexOf("."));
                k = 0;
                while (k < magrows.size()) {
                    temp = (String)magrows.get(k);
                    if (temp.indexOf(magNumber) > -1) {
                        prefix = temp.substring(0, temp.lastIndexOf(".") + 1);
                        if (temp.indexOf("Type") > -1) {
                            this.tm.setValue(String.valueOf(prefix) + "Type_txt", null);
                        }
                        if (temp.indexOf("Value") > -1) {
                            this.tm.setValue(String.valueOf(prefix) + "Value_dbl", null);
                        }
                        if (temp.indexOf("Agency") > -1) {
                            this.tm.setValue(String.valueOf(prefix) + "Agency_txt", null);
                        }
                        if (temp.indexOf("DateTime") > -1) {
                            this.tm.setValue(String.valueOf(prefix) + "DateTime_txt", null);
                        }
                    }
                    ++k;
                }
            }
            ++i;
        }
        magrows.clear();
        i = 0;
        while (i < rows.length) {
            if (rows[i].contains("Hypocenter")) {
                magrows.add(rows[i]);
            }
            ++i;
        }
        i = 0;
        while (i < magrows.size()) {
            thisRow = (String)magrows.get(i);
            if (thisRow.contains("Latitude") && (!this.tm.hasValue(thisRow) || this.tm.getValue(thisRow).length() == 0)) {
                magNumber = thisRow.substring(thisRow.indexOf("."), thisRow.lastIndexOf("."));
                k = 0;
                while (k < magrows.size()) {
                    temp = (String)magrows.get(k);
                    if (temp.indexOf(magNumber) > -1) {
                        prefix = temp.substring(0, temp.lastIndexOf(".") + 1);
                        if (temp.indexOf("DateTime") > -1) {
                            this.tm.setValue(String.valueOf(prefix) + "DateTime_txt", null);
                        }
                    }
                    ++k;
                }
            }
            ++i;
        }
        i = 0;
        while (i < rows.length) {
            if (rows[i].indexOf(".Sa") > -1) {
                sarows.add(rows[i]);
            }
            ++i;
        }
        i = 0;
        while (i < sarows.size()) {
            thisRow = (String)sarows.get(i);
            if (!(thisRow.indexOf(".Value") <= -1 || this.tm.hasValue(thisRow) && this.tm.getValue(thisRow).length() != 0)) {
                magNumber = thisRow.substring(thisRow.indexOf("."), thisRow.lastIndexOf("."));
                k = 0;
                while (k < sarows.size()) {
                    temp = (String)sarows.get(k);
                    if (temp.indexOf(magNumber) > -1) {
                        prefix = temp.substring(0, temp.lastIndexOf(".") + 1);
                        if (temp.indexOf("StructureDamping") > -1) {
                            this.tm.setValue(String.valueOf(prefix) + "StructureDamping_dbl", null);
                        }
                        if (temp.indexOf("Period") > -1) {
                            this.tm.setValue(String.valueOf(prefix) + "Period_dbl", null);
                        }
                    }
                    ++k;
                }
            }
            ++i;
        }
        sarows.clear();
        i = 0;
        while (i < rows.length) {
            if (rows[i].indexOf(".Filter") > -1) {
                sarows.add(rows[i]);
            }
            ++i;
        }
        HashMap<String, Boolean> hasPoles = new HashMap<String, Boolean>();
        HashMap<String, Boolean> hasPolynomial = new HashMap<String, Boolean>();
        HashMap<String, Boolean> hasOther = new HashMap<String, Boolean>();
        HashMap<String, Boolean> filters = new HashMap<String, Boolean>();
        try {
            String firstLine = (String)sarows.get(0);
            int start = firstLine.indexOf("Filter(");
            int i2 = 0;
            while (i2 < sarows.size()) {
                thisRow = (String)sarows.get(i2);
                prefix = thisRow.substring(0, start + 10);
                String filterIndex = prefix.substring(prefix.lastIndexOf("(") + 1, prefix.length() - 2);
                filters.put(filterIndex, true);
                if (this.tm.hasValue(String.valueOf(prefix) + "OtherDescription.Corner(1)_dbl")) {
                    hasOther.put(filterIndex, true);
                }
                if (this.tm.hasValue(String.valueOf(prefix) + "PoleZero.Numerator.NumberOfRoots_int")) {
                    hasPoles.put(filterIndex, true);
                }
                if (this.tm.hasValue(String.valueOf(prefix) + "Polynomial.Numerator.NumberOfCoeff_int")) {
                    hasPolynomial.put(filterIndex, true);
                }
                ++i2;
            }
            Set keys = filters.keySet();
            for (String index : keys) {
                if (hasOther.get(index) != null || hasPoles.get(index) != null || hasPolynomial.get(index) != null) continue;
                int k2 = 0;
                while (k2 < sarows.size()) {
                    thisRow = (String)sarows.get(k2);
                    prefix = String.valueOf(thisRow.substring(0, start + 7)) + index + ").";
                    temp = (String)sarows.get(k2);
                    if (this.tm.hasValue(String.valueOf(prefix) + "FilterName_txt")) {
                        this.tm.setValue(String.valueOf(prefix) + "FilterName_txt", null);
                    }
                    if (this.tm.hasValue(String.valueOf(prefix) + "Causality_txt")) {
                        this.tm.setValue(String.valueOf(prefix) + "Causality_txt", null);
                    }
                    if (this.tm.hasValue(String.valueOf(prefix) + "FrequencyBandType_txt")) {
                        this.tm.setValue(String.valueOf(prefix) + "FrequencyBandType_txt", null);
                    }
                    if (this.tm.hasValue(String.valueOf(prefix) + "PeriodBandType_txt")) {
                        this.tm.setValue(String.valueOf(prefix) + "PeriodBandType_txt", null);
                    }
                    if (this.tm.hasValue(String.valueOf(prefix) + "Domain_txt")) {
                        this.tm.setValue(String.valueOf(prefix) + "Domain_txt", null);
                    }
                    if (this.tm.hasValue(String.valueOf(prefix) + "Mode_txt")) {
                        this.tm.setValue(String.valueOf(prefix) + "Mode_txt", null);
                    }
                    ++k2;
                }
            }
        }
        catch (Exception firstLine) {
            // empty catch block
        }
        ArrayList<String> textrows = new ArrayList<String>(0);
        int i3 = 0;
        while (i3 < rows.length) {
            if (rows[i3].indexOf("_txt") > -1) {
                textrows.add(rows[i3]);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < textrows.size()) {
            thisRow = (String)textrows.get(i3);
            if (this.tm.hasValue(thisRow) && this.tm.getValue(thisRow).startsWith("\"\"")) {
                this.tm.setValue(thisRow, null);
            }
            ++i3;
        }
    }
}

