/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.to_tag;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.cosmos.to_tag.DateTime;

public class FileFetcher {
    private String fullFileName;
    private static String metadataDirectory;
    private static String dataDirectory;
    private String separator = File.pathSeparator;
    private File fdir;
    private String creationDay;
    private String shortname;

    public FileFetcher() {
    }

    public FileFetcher(String filename) {
        this();
        this.fullFileName = filename;
    }

    public FileFetcher(File pathname) {
        this(pathname.toString());
        this.shortname = pathname.getName();
        dataDirectory = pathname.getParent().concat(this.separator);
    }

    public FileFetcher(int directory) {
        this();
        JFrame cframe = new JFrame("Choose a directory");
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(directory);
        chooser.setDialogTitle("Select a directory");
        int returnVal = chooser.showOpenDialog(cframe);
        if (returnVal == 0) {
            File fdir = chooser.getSelectedFile();
            metadataDirectory = fdir.getPath().concat(this.separator);
        }
    }

    public String getDirectory() {
        return metadataDirectory;
    }

    public void setDirectory(String dirname) {
        metadataDirectory = dirname;
    }

    public String getDataDirectory() {
        return dataDirectory;
    }

    public void setDataDirectory(String dirname) {
        dataDirectory = dirname;
    }

    public String getFileName() {
        return this.shortname;
    }

    public String getLongFileName() {
        return this.fullFileName;
    }

    public String getCreationDay() {
        return this.creationDay;
    }

    public String launchChooser() {
        JFrame cframe = new JFrame("Choose a file");
        this.fdir = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Choose a file");
        int returnVal = chooser.showOpenDialog(cframe);
        if (returnVal == 0) {
            this.fdir = chooser.getSelectedFile();
            this.fullFileName = this.fdir.getPath();
        }
        return this.fdir.getName();
    }

    public String[] readTable(String fname) {
        StringBuffer sb = new StringBuffer();
        String lineDelimiter = "\r\n|\n|\r";
        try {
            int ch;
            InputStreamReader isr = new InputStreamReader(FileFetcher.class.getResourceAsStream(fname));
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                sb.append((char)ch);
            }
            ((Reader)in).close();
        }
        catch (Exception ee2) {
            System.err.println("Error accessing table:" + fname + "  " + ee2.toString());
        }
        return sb.toString().split(lineDelimiter);
    }

    public String[] getLines() {
        String wholeFile = new String();
        String lineDelimiter = "\r\n|\n|\r";
        try {
            File file = new File(this.fullFileName);
            long dateinfo = 0L;
            try {
                dateinfo = file.lastModified();
            }
            catch (SecurityException ee) {
                System.err.println("Cannot detect input file date:" + ee.toString());
            }
            Calendar day = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            day.setTimeInMillis(dateinfo);
            DateTime dt = new DateTime();
            this.creationDay = dt.getDateString(day);
            this.shortname = file.getName();
            int size = (int)file.length();
            int chars_read = 0;
            FileReader in = new FileReader(file);
            char[] data2 = new char[size];
            chars_read = in.read(data2, 0, size);
            in.close();
            wholeFile = new String(data2, 0, chars_read);
        }
        catch (IOException e) {
            System.err.println("Error opening or reading file " + this.fullFileName + ": " + e.toString());
        }
        return wholeFile.split(lineDelimiter);
    }

    public String writeLines(String outfileName, String array) {
        try {
            FileWriter out = new FileWriter(outfileName);
            out.write(array);
            out.close();
        }
        catch (IOException e) {
            System.err.println("Error writing to output file " + outfileName + ": " + e.toString());
            return "Error writing to output file " + outfileName + ": " + e.toString();
        }
        return null;
    }

    public BufferedWriter getStream(String outfileName) {
        try {
            File file = new File(outfileName);
            FileWriter os = new FileWriter(file);
            BufferedWriter bos = new BufferedWriter(os);
            return bos;
        }
        catch (Exception e) {
            System.err.println("Error opening output file " + outfileName + ": " + e.toString());
            return null;
        }
    }

    public String writeLines(BufferedWriter bos, String[] array) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        try {
            int i = 0;
            while (i < length) {
                bos.write(String.valueOf(array[i]) + "\n");
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Error writing to output file: " + e.toString());
            return "Error writing to output file: " + e.toString();
        }
        return null;
    }

    public void finish(BufferedWriter bos) {
        try {
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            System.err.println("Error closing output file: " + e.toString());
        }
    }
}

