/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.to_tag;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTime {
    String dateString;
    String zoneString;
    DecimalFormat iif = (DecimalFormat)NumberFormat.getIntegerInstance();
    DecimalFormat ihf;
    String intPattern = "00";
    DecimalFormat seconds;
    String realPattern;
    double frac;

    public DateTime() {
        this.iif.applyPattern(this.intPattern);
        this.ihf = (DecimalFormat)NumberFormat.getIntegerInstance();
        this.intPattern = "+00;-00";
        this.ihf.applyPattern(this.intPattern);
        this.seconds = (DecimalFormat)NumberFormat.getNumberInstance();
        this.realPattern = "00.000";
        this.seconds.applyPattern(this.realPattern);
    }

    public String getDateString(Calendar date) {
        this.dateString = this.getShortDateString(date);
        this.frac = (double)date.get(14) / 1000.0 + (double)date.get(13);
        String sec = this.seconds.format(this.frac);
        this.dateString = this.dateString.concat(":" + sec);
        this.dateString = this.dateString.concat(this.getZoneString(date));
        return this.dateString;
    }

    public Calendar getCalendar(int year, int dayOfYear) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1, year);
        cal.set(6, dayOfYear);
        return cal;
    }

    public String getDateString(int year, int month, int day, int hour, int min, int sec, int milli, String zone) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(zone));
        cal.set(year, month, day, hour, min, sec);
        cal.set(14, milli);
        if (cal == null) {
            return this.illegalShortDate(year, month, day);
        }
        this.dateString = this.getDateString(cal);
        return this.dateString;
    }

    public String getDateString(int year, int month, int day, int hour, int min, String zone) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(zone));
        cal.set(year, month, day, hour, min, 0);
        if (cal == null) {
            return this.illegalShortDate(year, month, day);
        }
        this.dateString = this.getShortDateString(cal);
        this.dateString = String.valueOf(this.dateString) + this.getZoneString(cal);
        return this.dateString;
    }

    public String getDateString(int year, int month, int day, String zone) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(zone));
        cal.set(year, month, day);
        if (cal == null) {
            return this.illegalShortDate(year, month, day);
        }
        this.dateString = this.getDateOnlyString(cal);
        return this.dateString;
    }

    public String getDateString(int[] dateParts) {
        this.dateString = "";
        int length = dateParts.length;
        if (length > 0) {
            this.dateString = String.valueOf(this.dateString) + dateParts[0];
        }
        if (length > 1) {
            this.dateString = String.valueOf(this.dateString) + "-" + this.iif.format(dateParts[1]);
        }
        if (length > 2) {
            this.dateString = String.valueOf(this.dateString) + "-" + this.iif.format(dateParts[2]);
        }
        if (length > 4) {
            this.dateString = String.valueOf(this.dateString) + " " + this.iif.format(dateParts[3]) + ":" + this.iif.format(dateParts[4]);
        }
        if (length > 6) {
            this.dateString = String.valueOf(this.dateString) + ":" + this.seconds.format((double)dateParts[5] + (double)dateParts[6] / 1000.0);
        } else if (length > 5) {
            this.dateString = String.valueOf(this.dateString) + ":" + this.iif.format(dateParts[5]);
        }
        return String.valueOf(this.dateString) + "Z";
    }

    public String getDateString(int[] dateParts, String zone) {
        this.dateString = "";
        String _zone = this.checkZone(zone);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(_zone));
        int length = dateParts.length;
        if (length > 0) {
            cal.set(1, dateParts[0]);
        }
        if (length > 1) {
            cal.set(2, dateParts[1] - 1);
        }
        if (length > 2) {
            cal.set(5, dateParts[2]);
        }
        if (length > 4) {
            cal.set(11, dateParts[3]);
            cal.set(12, dateParts[4]);
        }
        if (length > 5) {
            cal.set(13, dateParts[5]);
        }
        if (length > 6) {
            cal.set(14, dateParts[6]);
        } else {
            cal.set(14, 0);
        }
        return this.getDateString(cal);
    }

    private String checkZone(String zone) {
        String newzone = zone;
        if (zone.indexOf("D") > 0) {
            newzone = String.valueOf(newzone.substring(0, 1)) + "S" + newzone.substring(2);
        }
        return newzone;
    }

    public Calendar getCalendar(int year, int month, int day, int hour, int min, int sec, int milli, String zone) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(zone));
        try {
            cal.set(year, month, day, hour, min, sec);
        }
        catch (Exception e) {
            return null;
        }
        cal.set(14, milli);
        return cal;
    }

    public Calendar getCalendar(int[] vals, String zone) {
        int milli;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(zone));
        try {
            cal.set(vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]);
        }
        catch (Exception e) {
            return null;
        }
        milli = vals.length == 7 ? (milli = vals[6]) : 0;
        cal.set(14, milli);
        return cal;
    }

    public Calendar getCalendar(int year, int month, int day, int hour, int min, String zone) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(zone));
        try {
            cal.set(year, month, day, hour, min);
        }
        catch (Exception e) {
            return null;
        }
        return cal;
    }

    public Calendar getCalendar(int year, int month, int day, String zone) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(zone));
        try {
            cal.set(year, month, day);
        }
        catch (Exception e) {
            return null;
        }
        return cal;
    }

    public String getShortDateString(Calendar date) {
        int year = date.get(1);
        String month = this.iif.format(date.get(2) + 1);
        String day = this.iif.format(date.get(5));
        String hour = this.iif.format(date.get(11));
        String min = this.iif.format(date.get(12));
        return year + "-" + month + "-" + day + " " + hour + ":" + min;
    }

    public String getDateOnlyString(Calendar date) {
        int year = date.get(1);
        String month = this.iif.format(date.get(2) + 1);
        String day = this.iif.format(date.get(5));
        String hour = this.iif.format(date.get(11));
        String min = this.iif.format(date.get(12));
        return year + "-" + month + "-" + day;
    }

    public String getMediumDateString(Calendar date) {
        int year = date.get(1);
        String month = this.iif.format(date.get(2) + 1);
        String day = this.iif.format(date.get(5));
        String hour = this.iif.format(date.get(11));
        String min = this.iif.format(date.get(12));
        String sec = this.iif.format(date.get(13));
        return year + "-" + month + "-" + day + " " + hour + ":" + min + ":" + sec;
    }

    private String getZoneString(Calendar date) {
        int offset = date.get(15);
        if (offset == 0) {
            return "Z";
        }
        int secs = offset / 1000;
        int minutes = secs / 60;
        int hours = minutes / 60;
        String min = this.iif.format(minutes - hours * 60);
        String hour = this.ihf.format(hours);
        return String.valueOf(hour) + ":" + min;
    }

    public String getNow() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.dateString = this.getMediumDateString(cal);
        return String.valueOf(this.dateString) + "Z";
    }

    public String getUTCFromLocal(Calendar date) {
        long millis = date.getTimeInMillis();
        date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.setTimeInMillis(millis);
        return this.getDateString(date);
    }

    private String illegalShortDate(int year, int month, int day) {
        System.err.println("Invalid value for date, returning string for given date only");
        return year + "-" + month + "-" + day;
    }

    public boolean inDaylightTime(int year, int month, int day, String zone) {
        TimeZone tzone = TimeZone.getTimeZone(zone);
        Date ddate = new Date(year, month, day);
        return tzone.inDaylightTime(ddate);
    }

    public String getOutputFileNameDate(String FirstSampleDateTime) {
        String d = FirstSampleDateTime;
        return d.substring(0, 4) + d.substring(5, 7) + d.substring(8, 10) + "_" + d.substring(11, 13) + d.substring(14, 16) + d.substring(17, 19);
    }

    public String[] getTimeZones() {
        return TimeZone.getAvailableIDs();
    }

    public String[] getTimeZones(int offset) {
        return TimeZone.getAvailableIDs(offset);
    }
}

