/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cosmos.csmml.DoubleHzOrSecType;
import org.cosmos.csmml.StrongMotion;
import org.cosmos.utils.TagHeader;
import org.cosmos.utils.XMLModel;
import org.cosmos.utils.xmlIO;
import org.w3c.dom.Document;

public class XMLManager {
    protected xmlIO io = new xmlIO(true);
    private StrongMotion smOrig;
    private StrongMotion header;
    private String data = null;
    private int ndamps;
    private ArrayList<String> tempDamps = null;
    private boolean haveDamps = false;

    public void setStrongMotion(StrongMotion sm) {
        this.smOrig = sm;
        System.out.println("setting text data");
        this.setTextData();
        System.out.println("setting text header");
        this.setTextHeader();
        System.out.println("finished setting text data");
    }

    public String readXML(String filename) {
        try {
            this.smOrig = this.io.readStrongMotionXML(filename);
            this.setTextData();
            this.setTextHeader();
        }
        catch (Exception e) {
            return "error reading " + filename + " as an XML format file: " + e.toString();
        }
        return null;
    }

    public boolean isTimeSeries() {
        String type = this.smOrig.getDataSeries().getPhysicalParameter().getValue().toLowerCase();
        return !type.contains("spectr");
    }

    public boolean isDFT() {
        String type = this.smOrig.getDataSeries().getPhysicalParameter().getValue().toLowerCase();
        return type.contains("acceleration amplitude spectrum");
    }

    public boolean isSpec() {
        String type = this.smOrig.getDataSeries().getPhysicalParameter().getValue().toLowerCase();
        return type.contains("spectr");
    }

    public StrongMotion getTextHeader() {
        return this.header;
    }

    public String getTextData() {
        return this.data;
    }

    public float getSpan() {
        DoubleHzOrSecType o = this.smOrig.getDataSeries().getSpan();
        if (o != null) {
            return Float.valueOf(this.smOrig.getDataSeries().getSpan().getValue()).floatValue();
        }
        try {
            float sps = this.getFPSamplesPerSecond();
            float samples = Float.parseFloat(this.smOrig.getDataSeries().getNumberOfSamples().getValue());
            return samples / sps;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void setTextHeader() {
        this.header = this.smOrig;
        this.header.getDataSeries().getDataSeriesValues().setValue(null);
    }

    public void setTextData() {
        this.data = this.smOrig.getDataSeries().getDataSeriesValues().getValue();
    }

    public int getNumPoints() {
        return Integer.valueOf(this.smOrig.getDataSeries().getNumberOfSamples().getValue());
    }

    public String getUnits(int index) {
        return this.smOrig.getDataSeries().getOrdinateUnits().get(index).getValue();
    }

    public String getYUnits() {
        return this.smOrig.getDataSeries().getOrdinateUnits().get(0).getValue();
    }

    public String getXUnits() {
        try {
            return this.smOrig.getDataSeries().getAbscissaUnits().getValue();
        }
        catch (Exception e) {
            return "s";
        }
    }

    public String getFactor() {
        try {
            return this.smOrig.getRawSeries().getScaleToDataSeries().getValue();
        }
        catch (Exception e) {
            return "1.0";
        }
    }

    public double getSamplesPerSecond() {
        try {
            return Double.valueOf(this.smOrig.getDataSeries().getSamplesPerSecond().getValue());
        }
        catch (Exception e) {
            double val = Double.valueOf(this.smOrig.getDataSeries().getSampleInterval().getValue());
            return 1.0 / val;
        }
    }

    public float getFPSamplesPerSecond() {
        try {
            return Float.valueOf(this.smOrig.getDataSeries().getSamplesPerSecond().getValue()).floatValue();
        }
        catch (Exception e) {
            float val = Float.valueOf(this.smOrig.getDataSeries().getSampleInterval().getValue()).floatValue();
            return 1.0f / val;
        }
    }

    public int getNoDamps() {
        int ndamps = 0;
        this.tempDamps = new ArrayList();
        String temp = null;
        int i = 0;
        while (i < 10) {
            try {
                temp = this.smOrig.getDataSeries().getResponseSpectrumDamping().get(i).getValue();
                if (temp != null) {
                    this.tempDamps.add(temp);
                    ++ndamps;
                }
            }
            catch (Exception e) {
                return ndamps;
            }
            ++i;
        }
        this.tempDamps.trimToSize();
        this.haveDamps = true;
        return ndamps;
    }

    public ArrayList<String> getDamps() {
        if (this.haveDamps) {
            return this.tempDamps;
        }
        this.getNoDamps();
        return this.tempDamps;
    }

    public float getLastFreq() {
        StringTokenizer st = new StringTokenizer(this.data, "\n");
        String line = null;
        while (st.hasMoreTokens()) {
            line = st.nextToken();
        }
        st = new StringTokenizer(line, " ");
        return Float.valueOf(st.nextToken()).floatValue();
    }

    public float getFirstFreq() {
        StringTokenizer st = new StringTokenizer(this.data, "\n");
        String line = null;
        line = st.nextToken();
        st = new StringTokenizer(line, " ");
        return Float.valueOf(st.nextToken()).floatValue();
    }

    public Document getEmptyDoc() {
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            return docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            System.err.println(e.toString());
            return null;
        }
    }

    public Document makeXMLdoc() {
        Document d = this.getEmptyDoc();
        return this.io.getXMLdoc(this.smOrig, d);
    }

    public StrongMotion TagToXML(TagHeader ts) {
        XMLModel model = new XMLModel();
        model.generateNodes(ts);
        model.setXMLValues(ts);
        return model.getStrongMotion();
    }
}

