/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.cosmos.converter.DynamicTree;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class TreeDisplay {
    private static boolean isEditable;
    private static DynamicTree dTree;

    public TreeDisplay() {
        isEditable = false;
        dTree = new DynamicTree(isEditable);
    }

    public void fillTree(Document xmlFile, String startingPoint) {
        Document cosmosDocument = xmlFile;
        DefaultMutableTreeNode root = TreeDisplay.getTree(cosmosDocument, startingPoint);
    }

    public JTree getTree() {
        return dTree.getTree();
    }

    private static DefaultMutableTreeNode build(Document document, NodeList elements, DefaultMutableTreeNode parentNode) {
        DefaultMutableTreeNode thisNode = null;
        NamedNodeMap attributes = null;
        String textContent = null;
        if (elements == null) {
            return null;
        }
        int elementCount = elements.getLength();
        int i = 0;
        while (i < elementCount) {
            String elementValue;
            StringBuffer treeNode;
            Node element;
            if (elements.item(i).getNodeType() == 3 && (textContent = (element = (Text)elements.item(i)).getNodeValue()) != null) {
                treeNode = new StringBuffer(textContent.trim());
                elementValue = treeNode.toString();
                thisNode = dTree.addObject(parentNode, elementValue);
            }
            if (elements.item(i).getNodeType() == 1) {
                element = (Element)elements.item(i);
                treeNode = new StringBuffer(element.getNodeName());
                attributes = element.getAttributes();
                if (attributes != null) {
                    int j = 0;
                    while (j < attributes.getLength()) {
                        Attr attribute = (Attr)attributes.item(j);
                        treeNode.append(" " + attribute.getNodeName().trim() + "= " + attribute.getNodeValue().trim());
                        ++j;
                    }
                }
                elementValue = treeNode.toString();
                thisNode = dTree.addObject(parentNode, elementValue.trim());
                NodeList children = element.getChildNodes();
                int numberOfChildren = children.getLength();
                if (children != null && numberOfChildren > 0 && element.getNodeName() != "Content") {
                    TreeDisplay.build(document, children, thisNode);
                }
            }
            ++i;
        }
        return thisNode;
    }

    private static DefaultMutableTreeNode getTree(Document document, String startingPoint) {
        DefaultMutableTreeNode root = null;
        try {
            NodeList elements = document.getElementsByTagName(startingPoint);
            root = TreeDisplay.build(document, elements, null);
        }
        catch (Exception e) {
            System.err.println("error: Parse error occurred - " + e.getMessage());
            if (e instanceof SAXException) {
                e = ((SAXException)e).getException();
            }
            e.printStackTrace(System.err);
        }
        return root;
    }
}

