/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.cosmos.converter.Grapher;

public class TimeSeriesGrapher
extends Grapher {
    protected static final long serialVersionUID = 1L;
    protected float sampleRate;
    protected float myxmin;
    protected String xlabel = "Time (s)";
    protected String ylabel;
    protected double mean;

    @Override
    public void toPoints(String dataFile, String factor, String units, double samplesPerSec, int npts, float xxmin, float xxmax) {
        this.s = this.getSize();
        if (npts < 2) {
            System.out.println("Insufficient data points to plot");
            return;
        }
        this.numPoints = npts;
        this.myUnits = units;
        this.myxmin = xxmin;
        this.xdata = new ArrayList(this.numPoints);
        this.ydata = new ArrayList(this.numPoints);
        float ffact = Float.parseFloat(factor);
        this.mySamplesPerSec = samplesPerSec;
        String filestart = dataFile.substring(0, 80);
        StringTokenizer st1 = new StringTokenizer(filestart.trim(), this.delims);
        StringTokenizer sttest = new StringTokenizer(st1.nextToken(), this.ldelims);
        StringTokenizer st = new StringTokenizer(dataFile.trim(), this.delims);
        boolean isTwoColumn = false;
        this.sampleRate = 1.0f / (float)samplesPerSec;
        if (sttest.countTokens() == 2) {
            isTwoColumn = true;
        }
        if (isTwoColumn) {
            while (st.hasMoreTokens()) {
                StringTokenizer st2 = new StringTokenizer(st.nextToken(), this.ldelims);
                int nums = st2.countTokens();
                float tempx = Float.parseFloat(st2.nextToken().trim());
                if (!(tempx >= xxmin) || !(tempx <= xxmax)) continue;
                this.xdata.add(Float.valueOf(tempx));
                float tempy = Float.parseFloat(st2.nextToken().trim()) * ffact;
                this.ydata.add(Float.valueOf(tempy));
                if (tempy < this.miny) {
                    this.miny = tempy;
                }
                if (!(tempy > this.maxy)) continue;
                this.maxy = tempy;
            }
        } else {
            double ysum = 0.0;
            this.mean = 0.0;
            int ncounts = 0;
            int i = 0;
            while (st.hasMoreTokens()) {
                String value = st.nextToken();
                float tempx = i;
                float seconds = tempx * this.sampleRate;
                ++i;
                if (!(seconds <= xxmax) || !(seconds >= xxmin)) continue;
                float tempy = Float.parseFloat(value.trim()) * ffact;
                this.xdata.add(Float.valueOf(tempx));
                this.ydata.add(Float.valueOf(tempy));
                if (tempy < this.miny) {
                    this.miny = tempy;
                }
                if (tempy > this.maxy) {
                    this.maxy = tempy;
                }
                ysum += (double)tempy;
                ++ncounts;
            }
            this.mean = ysum / (double)ncounts;
        }
        this.xdata.trimToSize();
        this.ydata.trimToSize();
        this.minx = (float)((double)xxmin * this.mySamplesPerSec);
        this.maxx = ((Float)this.xdata.get(this.xdata.size() - 1)).floatValue();
        this.xrange = (this.maxx - this.minx) * 1.1f;
        this.bigY = this.maxy > -this.miny ? this.maxy : this.miny;
        this.absY = Math.abs(this.bigY);
        this.plotMax = (int)(this.absY + 1.0f);
        this.yrange = 2.0f * this.plotMax * 1.1f;
        this.trueYrange = this.maxy - this.miny;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.s = this.getSize();
        if (this.s.width == 0) {
            this.s = this.getPreferredSize();
        }
        this.ybottom = (int)((float)this.s.height - this.BelowPlot);
        this.plotHeight = (float)this.s.height - this.BelowPlot - this.AbovePlot - 2.0f * this.lineWidth;
        this.plotMid = this.plotHeight / 2.0f + this.AbovePlot + this.lineWidth;
        this.xfact = (float)this.s.width / this.xrange;
        this.yfact = this.plotHeight / (2.0f * this.plotMax);
        Graphics2D g2 = (Graphics2D)g;
        this.setImage(g2);
        g2.drawImage((Image)offimg, 0, 0, this);
    }

    public void setImage(Graphics2D comp) {
        if (this.numPoints < 2) {
            comp.drawString("Insufficient data", 10, 40);
            return;
        }
        offimg = (BufferedImage)this.createImage(this.s.width, this.s.height);
        comp = offimg.createGraphics();
        comp.setBackground(Color.WHITE);
        comp.clearRect(0, 0, this.s.width, this.s.height);
        int numPlotPoints = this.xdata.size();
        int[] x = new int[numPlotPoints];
        int[] y = new int[numPlotPoints];
        int i = 0;
        while (i < numPlotPoints) {
            x[i] = (int)((((Float)this.xdata.get(i)).floatValue() - this.minx) * this.xfact + this.xOffset);
            y[i] = (int)(this.plotMid - ((Float)this.ydata.get(i)).floatValue() * this.yfact);
            ++i;
        }
        GeneralPath accel = new GeneralPath(0, numPlotPoints);
        accel.moveTo(x[0], y[0]);
        i = 1;
        while (i < numPlotPoints) {
            accel.lineTo(x[i], y[i]);
            ++i;
        }
        comp.draw(accel);
        comp.setFont(this.f);
        int xstart = x[0];
        int xend = x[numPlotPoints - 1];
        float secs = ((float)numPlotPoints + 1.0f) / (float)this.mySamplesPerSec;
        if (secs > 150.0f) {
            this.secsPerTick = 20;
        }
        if (secs < 15.0f) {
            this.secsPerTick = 1;
        }
        float temp = this.myxmin % (float)this.secsPerTick;
        int xLabelStart = xstart;
        int datastart = (int)this.myxmin / this.secsPerTick * this.secsPerTick;
        if ((double)(this.myxmin % (float)this.secsPerTick) > 0.001) {
            xLabelStart = (int)((double)this.xfact * this.mySamplesPerSec * (double)((float)(datastart += this.secsPerTick) - this.myxmin)) + xstart;
        }
        float numTicks = secs / (float)this.secsPerTick;
        float secFact = (float)(xend - xstart) / numTicks;
        int iTicks = (int)numTicks;
        if ((double)(temp % (float)this.secsPerTick) < 0.001) {
            ++iTicks;
        }
        if ((double)temp > 0.001 && (double)(secs % (float)this.secsPerTick) > 0.001) {
            ++iTicks;
        }
        String numSecs = null;
        int xnudge = this.fontHeight / 4;
        int tickbottom = this.ybottom + 5;
        int longerTick = this.ybottom + 8;
        int labelbottom = this.ybottom + 15;
        int[] xposition = new int[iTicks + 1];
        i = 0;
        while (i < iTicks) {
            float xi = i;
            int val = i * this.secsPerTick + datastart;
            boolean shouldBeLong = !((double)val % (this.mySamplesPerSec / 2.0) > 0.01);
            xposition[i] = (int)((float)xLabelStart + xi * secFact);
            if (xposition[i] <= xend) {
                if (shouldBeLong) {
                    comp.drawLine(xposition[i], this.ybottom, xposition[i], longerTick);
                } else {
                    comp.drawLine(xposition[i], this.ybottom, xposition[i], tickbottom);
                }
            }
            ++i;
        }
        i = 0;
        while (i < iTicks) {
            boolean shouldLabel;
            int val = i * this.secsPerTick + datastart;
            boolean bl = shouldLabel = !((double)val % this.mySamplesPerSec > 0.01);
            if (this.xrange < 101.0f) {
                shouldLabel = true;
            }
            shouldLabel = true;
            numSecs = String.valueOf(val);
            if (val > 9) {
                xnudge = this.fontHeight / 2;
            }
            if (shouldLabel && xposition[i] <= xend) {
                comp.drawString(numSecs, xposition[i] - xnudge, labelbottom);
            }
            ++i;
        }
        comp.drawString(this.xlabel, (xend - xstart - this.fm.stringWidth(this.xlabel)) / 2, this.ybottom + 25);
        comp.drawLine(xstart - 5, this.ybottom, xend, this.ybottom);
        comp.drawLine(xstart, this.ytop, xstart, this.ybottom);
        String maxString = "Max = " + this.bigY;
        if (Math.abs(this.mean) > 0.01) {
            maxString = String.valueOf(maxString) + " Mean = " + this.setFormat(this.mean, 3);
        }
        int Maxy = (int)this.plotMax;
        int Miny = -Maxy;
        comp.drawString(String.valueOf(Maxy), xstart - 30, this.ytop + 4);
        comp.drawString(String.valueOf(Miny), xstart - 30, this.ybottom + 4);
        comp.drawString(maxString, xend - this.fm.stringWidth(maxString), this.ytop + this.fontHeight);
        int unitsPosition = (int)(this.plotMid + (float)this.fm.stringWidth(this.myUnits) / 2.0f);
        comp.rotate(Math.toRadians(270.0), xstart - 20, unitsPosition);
        this.ylabel = this.myUnits;
        comp.drawString(this.ylabel, xstart - 25, unitsPosition);
    }

    private String setFormat(double value, int decimalPlaces) {
        BigDecimal bd = new BigDecimal(value);
        return String.valueOf(bd.setScale(decimalPlaces, 4));
    }
}

