/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.cosmos.utils.TagHeader;
import org.cosmos.utils.TaggedHandler;

public class TagManager {
    protected TaggedHandler th;
    protected TagHeader tags;
    protected int ndamps;
    protected ArrayList<String> tempDamps = null;
    protected boolean haveDamps;

    public TagManager(String filename) {
        this.th = new TaggedHandler(filename);
        this.haveDamps = false;
    }

    public TagManager() {
        String filename = "internal";
        this.th = new TaggedHandler(filename);
        this.haveDamps = false;
    }

    public String readTagged() {
        try {
            this.th.importFile();
            this.tags = this.th.getTagSet();
        }
        catch (Exception e) {
            return "error opening " + this.th.getLongFileName() + " as a Tagged format file: " + e.toString();
        }
        return null;
    }

    public String importTagged(String wholeFile) {
        this.th.parseTaggedFile(wholeFile);
        this.tags = this.th.getTagSet();
        return null;
    }

    public TagHeader getTagSet() {
        return this.tags;
    }

    public String getTextHeader() {
        return this.th.getHeaderString();
    }

    public String getTextData() {
        return this.th.getDataString();
    }

    public int getNumPoints() {
        return Integer.valueOf(this.tags.getValue("DataSeries.NumberOfSamples"));
    }

    public String getFactor() {
        String val = this.tags.getValue("RawSeries.ScaleToDataSeries");
        return val != null ? val : "1.0";
    }

    public String getUnits(int index) {
        return this.tags.getValue("DataSeries.OrdinateUnits(" + index + ")");
    }

    public String getYUnits() {
        String test = this.tags.getUnits("RawSeries.ScaleToDataSeries");
        try {
            test = test.substring(0, test.lastIndexOf("/"));
            test = test.substring(test.indexOf("(") + 1);
            test = test.substring(0, test.indexOf(")"));
            return test;
        }
        catch (Exception e) {
            return this.tags.getValue("DataSeries.OrdinateUnits(1)");
        }
    }

    public String getXUnits() {
        String units = this.tags.getUnits("DataSeries.SampleInterval");
        if (units != null) {
            return units;
        }
        units = this.tags.getValue("DataSeries.AbscissaUnits");
        if (units != null) {
            return units;
        }
        return "s";
    }

    public float getSpan() {
        try {
            float val = Float.parseFloat(this.tags.getValue("DataSeries.Span"));
            return val;
        }
        catch (Exception e) {
            try {
                float sps = this.getFPSamplesPerSecond();
                float samples = Float.parseFloat(this.tags.getValue("DataSeries.NumberOfSamples"));
                return Float.valueOf(samples / sps).floatValue();
            }
            catch (Exception ee) {
                return 0.0f;
            }
        }
    }

    public float getLastFreq() {
        String data2 = this.getTextData();
        StringTokenizer st = new StringTokenizer(data2, "\n");
        String line = null;
        while (st.hasMoreTokens()) {
            line = st.nextToken();
        }
        st = new StringTokenizer(line, " ");
        return Float.valueOf(st.nextToken()).floatValue();
    }

    public float getFirstFreq() {
        String data2 = this.getTextData();
        StringTokenizer st = new StringTokenizer(data2, "\n");
        String line = null;
        line = st.nextToken();
        st = new StringTokenizer(line, " ");
        return Float.valueOf(st.nextToken()).floatValue();
    }

    public int getNoDamps() {
        int ndamps = 0;
        this.tempDamps = new ArrayList();
        String temp = null;
        int index = 0;
        int i = 0;
        while (i < 10) {
            index = i + 1;
            temp = this.tags.getValue("DataSeries.ResponseSpectrumDamping(" + index + ")");
            if (temp != null) {
                this.tempDamps.add(temp);
                ++ndamps;
            }
            ++i;
        }
        this.tempDamps.trimToSize();
        this.haveDamps = true;
        return ndamps;
    }

    public ArrayList<String> getDamps() {
        if (this.haveDamps) {
            return this.tempDamps;
        }
        this.getNoDamps();
        return this.tempDamps;
    }

    public boolean isDFT() {
        String type = this.tags.getValue("DataSeries.PhysicalParameter").toLowerCase();
        return type.contains("acceleration amplitude spectrum");
    }

    public boolean isTimeSeries() {
        String type = this.tags.getValue("DataSeries.PhysicalParameter").toLowerCase();
        return !type.contains("spectr");
    }

    public double getSamplesPerSecond() {
        String value = this.tags.getValue("DataSeries.SamplesPerSecond");
        if (value != null) {
            return Double.valueOf(value);
        }
        value = this.tags.getValue("DataSeries.SampleInterval");
        double sps = 1.0 / Double.valueOf(value);
        return sps;
    }

    public float getFPSamplesPerSecond() {
        String value = this.tags.getValue("DataSeries.SamplesPerSecond");
        if (value != null) {
            return Float.valueOf(value).floatValue();
        }
        value = this.tags.getValue("DataSeries.SampleInterval");
        float sps = 1.0f / Float.valueOf(value).floatValue();
        return sps;
    }
}

