/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.cosmos.converter.Grapher;

public class SpecGrapher
extends Grapher {
    private static final long serialVersionUID = 1L;
    protected int numPoints;
    protected int HzMultiplier;
    protected int ValMultiplier;
    protected float xrange;
    protected float plotMax;
    protected float yrange;
    protected float[] bigY;
    protected float xfact;
    protected int[] x;
    protected int[] y;
    protected float plotHeight;
    protected float plotMid;
    protected int HzPerTick;
    protected int ValPerTick;
    protected float yfact;
    protected int ytop;
    protected int ybottom;
    protected String dampValue;
    protected String xunits;

    public SpecGrapher() {
        this.ytop = (int)this.AbovePlot;
        this.HzMultiplier = 100;
        this.ValMultiplier = 100;
        this.ValPerTick = 5;
    }

    @Override
    public void toPoints(String dataFile, String xaxisunits, String units, int dampingIndex, String dampingValue, float xxmin, float xxmax) {
        this.s = this.getSize();
        if (dataFile.length() < 40) {
            System.out.println("Insufficient data points to plot");
            return;
        }
        this.myUnits = units;
        this.xunits = xaxisunits;
        this.HzPerTick = xxmax > 20.0f ? this.HzMultiplier / 20 : this.HzMultiplier / 10;
        this.dampValue = dampingValue;
        StringTokenizer st = new StringTokenizer(dataFile.trim(), this.delims);
        this.xdata = new ArrayList(st.countTokens());
        this.ydata = new ArrayList(st.countTokens());
        Float tempy = Float.valueOf(0.0f);
        int j = 0;
        String tempString = null;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(line, " ");
            Float tempx = Float.valueOf(Float.parseFloat(st2.nextToken().trim()));
            if (!(tempx.floatValue() >= xxmin) || !(tempx.floatValue() <= xxmax)) continue;
            this.xdata.add(Float.valueOf(tempx.floatValue() * (float)this.HzMultiplier));
            int i = 0;
            while (i <= dampingIndex) {
                tempString = st2.nextToken().trim();
                ++i;
            }
            try {
                tempy = Float.valueOf(Float.parseFloat(tempString) * (float)this.ValMultiplier);
            }
            catch (Exception e) {
                System.out.println("damp index:" + dampingIndex + "bad line:" + line + " bad value:" + tempString);
            }
            this.ydata.add(tempy);
            if (tempy.floatValue() < this.miny) {
                this.miny = tempy.floatValue();
            }
            if (tempy.floatValue() > this.maxy) {
                this.maxy = tempy.floatValue();
            }
            ++j;
        }
        this.xdata.trimToSize();
        this.numPoints = this.xdata.size();
        this.minx = xxmin * (float)this.HzMultiplier;
        this.maxx = ((Float)this.xdata.get(this.numPoints - 1)).floatValue();
        this.xrange = (this.maxx - this.minx) * 1.1f;
        this.plotMax = (float)((int)this.maxy) + 1.0f;
        this.yrange = this.plotMax * 1.1f;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.s = this.getSize();
        if (this.s.width == 0) {
            this.s = this.getPreferredSize();
        }
        this.ybottom = (int)((float)this.s.height - this.BelowPlot);
        this.plotHeight = (float)this.s.height - this.BelowPlot - this.AbovePlot - 2.0f * this.lineWidth;
        this.plotMid = this.plotHeight / 2.0f + this.AbovePlot + this.lineWidth;
        this.xfact = (float)this.s.width / this.xrange;
        this.yfact = this.plotHeight / this.plotMax;
        Graphics2D g2 = (Graphics2D)g;
        this.setImage(g2);
        g2.drawImage((Image)offimg, 0, 0, this);
    }

    public void setImage(Graphics2D comp) {
        boolean shouldLabel;
        boolean shouldBeLong;
        offimg = (BufferedImage)this.createImage(this.s.width, this.s.height);
        comp = offimg.createGraphics();
        comp.setBackground(Color.WHITE);
        comp.clearRect(0, 0, this.s.width, this.s.height);
        this.x = new int[this.numPoints];
        this.y = new int[this.numPoints];
        int i = 0;
        while (i < this.numPoints) {
            this.x[i] = (int)((((Float)this.xdata.get(i)).floatValue() - this.minx) * this.xfact + this.xOffset);
            this.y[i] = (int)((float)this.ybottom + this.lineWidth - ((Float)this.ydata.get(i)).floatValue() * this.yfact);
            ++i;
        }
        GeneralPath dependent = new GeneralPath(0, this.numPoints);
        dependent.moveTo(this.x[0], this.y[0]);
        i = 1;
        while (i < this.numPoints) {
            dependent.lineTo(this.x[i], this.y[i]);
            ++i;
        }
        comp.draw(dependent);
        comp.setFont(this.f);
        int xstart = this.x[0];
        int xend = this.x[this.numPoints - 1];
        float HzRange = this.maxx - this.minx;
        if (HzRange > 50.0f) {
            this.HzPerTick = 10;
        }
        if (HzRange > 100.0f) {
            this.HzPerTick = 20;
        }
        if (HzRange > 1000.0f) {
            this.HzPerTick = 200;
        }
        float myxmin = ((Float)this.xdata.get(0)).floatValue();
        float temp = myxmin % (float)this.HzPerTick;
        int xLabelStart = xstart;
        int datastart = (int)myxmin / this.HzPerTick * this.HzPerTick;
        if ((double)(myxmin % (float)this.HzPerTick) > 0.001) {
            xLabelStart = (int)(this.xfact * ((float)(datastart += this.HzPerTick) - myxmin)) + xstart;
        }
        float numTicks = HzRange / (float)this.HzPerTick;
        float HzFact = (float)(xend - xstart) / numTicks;
        int iTicks = (int)numTicks;
        if ((double)(temp % (float)this.HzPerTick) < 0.001) {
            ++iTicks;
        }
        if ((double)temp > 0.001 && (double)(HzRange % (float)this.HzPerTick) > 0.001) {
            ++iTicks;
        }
        int xnudge = this.fontHeight / 4;
        int tickbottom = this.ybottom + 5;
        int longerTick = this.ybottom + 8;
        int labelbottom = this.ybottom + 17;
        int[] xposition = new int[iTicks + 1];
        i = 0;
        while (i < iTicks) {
            float xi = i;
            int val = i * this.HzPerTick + datastart;
            shouldBeLong = !((double)(val % (this.HzMultiplier / 2)) > 0.01);
            xposition[i] = (int)((float)xLabelStart + xi * HzFact);
            if (xposition[i] <= xend) {
                if (shouldBeLong) {
                    comp.drawLine(xposition[i], this.ybottom, xposition[i], longerTick);
                } else {
                    comp.drawLine(xposition[i], this.ybottom, xposition[i], tickbottom);
                }
            }
            ++i;
        }
        String numHz = null;
        int decimalPlaces = 0;
        decimalPlaces = (double)HzRange > 1000.0 ? 0 : 1;
        i = 0;
        while (i < iTicks) {
            int val = i * this.HzPerTick + datastart;
            boolean bl = shouldLabel = !((double)(val % this.HzMultiplier) > 0.01);
            if ((double)(this.xrange / (float)this.HzMultiplier) < 1.05) {
                shouldLabel = true;
            }
            float HzVal = (float)val / (float)this.HzMultiplier;
            numHz = this.setFormat(HzVal, decimalPlaces);
            xnudge = this.fontHeight / 2;
            if (val > 9 * this.HzMultiplier) {
                xnudge += this.fontHeight / 2;
            }
            if (decimalPlaces == 0) {
                xnudge -= this.fontHeight / 2;
            }
            if (shouldLabel && xposition[i] <= xend) {
                comp.drawString(numHz, xposition[i] - xnudge, labelbottom);
            }
            ++i;
        }
        if (this.xunits.contains("Hz")) {
            comp.drawString("Hz", (xend - xLabelStart) / 2, this.ybottom + 25);
        } else {
            comp.drawString("Period (sec)", (xend - xLabelStart) / 2, this.ybottom + 25);
        }
        comp.drawLine(xstart - 5, this.ybottom, xend, this.ybottom);
        comp.drawLine(xstart, this.ytop, xstart, this.ybottom);
        String dampingString = "Damping = " + this.dampValue + "%";
        int ystart = 0;
        int yend = (int)(this.maxy * this.yfact);
        float ValRange = this.maxy;
        if (ValRange > 100000.0f) {
            this.ValPerTick = 25000;
        } else if (ValRange > 10000.0f) {
            this.ValPerTick = 2500;
        } else if (ValRange > 1000.0f) {
            this.ValPerTick = 250;
        } else if (ValRange > 100.0f) {
            this.ValPerTick = 25;
        } else if (ValRange < 5.0f) {
            this.ValPerTick = 1;
        }
        numTicks = ValRange / (float)this.ValPerTick;
        float ValFact = (float)(yend - ystart) / numTicks;
        iTicks = (int)numTicks;
        temp = 0 % this.ValPerTick;
        if ((double)(temp % (float)this.ValPerTick) < 0.001) {
            ++iTicks;
        }
        if ((double)temp > 0.001 && (double)(ValRange % (float)this.ValPerTick) > 0.001) {
            ++iTicks;
        }
        int ynudge = this.fontHeight / 4;
        int tickleft = xstart - 3;
        longerTick = xstart - 5;
        int[] yposition = new int[iTicks + 1];
        i = 0;
        while (i < iTicks) {
            float yi = i;
            shouldBeLong = i % 2 <= 0;
            yposition[i] = (int)((float)this.ybottom - yi * ValFact);
            if (yposition[i] <= yend) {
                if (shouldBeLong) {
                    comp.drawLine(longerTick, yposition[i], xstart, yposition[i]);
                } else {
                    comp.drawLine(tickleft, yposition[i], xstart, yposition[i]);
                }
            }
            ++i;
        }
        String value = null;
        float realVal = (float)this.ValPerTick / (float)this.ValMultiplier;
        decimalPlaces = realVal > 5.0f ? 0 : (realVal > 1.0f ? 1 : 2);
        ynudge = this.fontHeight / 2;
        i = 0;
        while (i < iTicks) {
            int val = i * this.ValPerTick;
            boolean bl = shouldLabel = i % 2 <= 0;
            if ((double)(this.yrange / (float)this.ValMultiplier) < 0.5) {
                shouldLabel = true;
            }
            realVal = (float)val / (float)this.ValMultiplier;
            value = this.setFormat(realVal, decimalPlaces);
            if (shouldLabel && yposition[i] <= yend) {
                comp.drawString(value, xstart - this.fm.stringWidth(value) - 7, yposition[i] + ynudge);
            }
            ++i;
        }
        value = this.setFormat(0.0f, decimalPlaces);
        comp.drawString(value, xstart - this.fm.stringWidth(value) - 7, this.ybottom + 4);
        if (this.dampValue != null) {
            comp.drawString(dampingString, xend - this.fm.stringWidth(dampingString), this.ytop + this.fontHeight);
        }
        String yAxisUnits = "Y Axis units = " + this.myUnits;
        comp.drawString(yAxisUnits, xend - this.fm.stringWidth(yAxisUnits), this.ytop + this.fontHeight * 3);
        this.x = null;
        this.y = null;
    }
}

