/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import java.io.BufferedWriter;
import java.lang.reflect.Constructor;
import org.cosmos.to_tag.FileFetcher;
import org.cosmos.to_tag.MatrixHandler;
import org.cosmos.to_tag.ProcessFormat;
import org.cosmos.to_tag.TableHandler;
import org.cosmos.to_tag.data;

public class ProcessSM {
    public static void main(String[] args) {
        String formatDir = "/format/";
        String origFormat = "COSMOSv12";
        String inputFilename = "/Volumes/data/eclipse/workspace/SMToTag/bin/format/" + origFormat + "/data/Cosmos12TimeSeriesTest.cosm";
        ProcessFormat proc = null;
        try {
            Class<?> cls = Class.forName("org.cosmos." + origFormat + ".Process");
            Constructor<?> con = cls.getConstructor(String.class);
            proc = (ProcessFormat)con.newInstance(String.valueOf(formatDir) + origFormat);
        }
        catch (Exception e) {
            System.err.println("Can't find a Process class for this format type " + e.toString());
            return;
        }
        String preparingAgency = "COSMOS";
        String vdcIdentifier = "1000";
        proc.setPrepAgency(preparingAgency);
        proc.setVDC_ID(vdcIdentifier);
        proc.setTemplate();
        MatrixHandler mh = new MatrixHandler();
        FileFetcher ff = new FileFetcher();
        String[] rows = ff.readTable(String.valueOf(formatDir) + origFormat + "/tables/TranslationTable.tab");
        mh.fillMatrix(rows, proc.getTemplate(), proc);
        TableHandler th = new TableHandler();
        int headerLinesToSkip = 1;
        th.setTableLines(String.valueOf(formatDir) + origFormat + "/tables/OriginalTables.tab", headerLinesToSkip);
        proc.readFile(inputFilename);
        String okay = proc.setComponents();
        mh.process();
        String[] start = new String[1];
        String contentString = "DataSeries.DataSeriesValues_txt";
        String[] end = new String[1];
        String commentIndicator = "||";
        mh.finalize();
        data[] dats = proc.getData();
        int i = 0;
        while (i < dats.length) {
            proc.resetElements(mh, dats[i]);
            BufferedWriter bos = ff.getStream(proc.getOutputFileName(dats[i].getShortName()));
            String[] head = mh.getHeaderArray(commentIndicator);
            ff.writeLines(bos, head);
            start[0] = String.valueOf(contentString) + mh.getRemainingSpaces(contentString) + "= {";
            ff.writeLines(bos, start);
            String[] dat = dats[i].toStringArray();
            ff.writeLines(bos, dat);
            end[0] = "};";
            ff.writeLines(bos, end);
            ff.finish(bos);
            ++i;
        }
    }
}

