/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import org.cosmos.converter.Grapher;
import org.cosmos.converter.LogSpecGrapher;
import org.cosmos.converter.SpecGrapher;
import org.cosmos.converter.TimeSeriesGrapher;

public class PlotManager {
    private boolean havePlot;
    private Grapher gg;

    public PlotManager() {
        this.unSetPlot();
    }

    public boolean havePlot() {
        return this.havePlot;
    }

    public void setPlot() {
        this.havePlot = true;
    }

    public void unSetPlot() {
        this.havePlot = false;
        this.gg = null;
    }

    public Grapher getGrapher() {
        return this.gg;
    }

    public void initPlot() {
        this.gg.initGraph();
    }

    public void paintPlot() {
        this.gg.paintGrapher();
    }

    public void initGrapher(boolean isTimeSeries, String type) {
        this.unSetPlot();
        this.gg = isTimeSeries ? new TimeSeriesGrapher() : (type.contains("Log") ? new LogSpecGrapher() : new SpecGrapher());
    }

    public void drawPlot(boolean haveData, String textData, String factor, String units, double SamplesPerSec, int npts, float min, float max) {
        if (haveData) {
            this.gg.toPoints(textData, factor, units, SamplesPerSec, npts, min, max);
            this.setPlot();
        }
    }

    public void drawPlot(boolean haveData, String textData, String xunits, String units, int dampingIndex, String dampingValue, float min, float max) {
        if (haveData) {
            this.gg.toPoints(textData, xunits, units, dampingIndex, dampingValue, min, max);
            this.setPlot();
        }
    }
}

