/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import org.cosmos.converter.ExcelExporter;
import org.cosmos.converter.Exporter;
import org.cosmos.converter.Grapher;
import org.cosmos.converter.MatLabExporter;
import org.cosmos.converter.PlotExporter;
import org.cosmos.converter.TagExporter;
import org.cosmos.converter.XMLExporter;
import org.cosmos.utils.TagHeader;

public class OutputManager {
    private Exporter ex;

    public String init(String type) {
        if (type.startsWith("MatLab")) {
            this.ex = new MatLabExporter();
        } else if (type.startsWith("Plot")) {
            this.ex = new PlotExporter();
        } else if (type.startsWith("Excel")) {
            this.ex = new ExcelExporter();
        } else if (type.startsWith("Tag")) {
            this.ex = new TagExporter();
        } else if (type.startsWith("XML")) {
            this.ex = new XMLExporter();
        } else {
            this.ex = null;
            return String.valueOf(type) + " conversion not available";
        }
        return null;
    }

    public void fillOutFile(String filename, TagHeader th, String data2, boolean isTS) {
        this.setFilename(filename);
        this.setTagHeader(th);
        this.setData(data2);
        this.setIsTimeSeries(isTS);
    }

    public String export() {
        return this.ex.export();
    }

    public void setFilename(String filename) {
        this.ex.setFileName(filename);
    }

    public void setGrapher(Grapher g) {
        this.ex.setGrapher(g);
    }

    public void setTagHeader(TagHeader th) {
        this.ex.setTagHeader(th);
    }

    public void setData(String data2) {
        this.ex.setData(data2);
    }

    public void setIsTimeSeries(boolean isTimeSeries) {
        this.ex.setIsTimeSeries(isTimeSeries);
    }

    public void setWholeFile(String tagfile) {
        this.ex.setFile(tagfile);
    }
}

