/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Set;
import org.cosmos.converter.Exporter;

public class MatLabExporter
extends Exporter {
    private String tsMfile;
    private String rsMfile;

    public MatLabExporter() {
        this.readTSMFile();
        this.readRSMfile();
    }

    public void readTSMFile() {
        this.tsMfile = this.readFile(String.valueOf(this.packageName) + "ts.m");
    }

    public void readRSMfile() {
        this.rsMfile = this.readFile(String.valueOf(this.packageName) + "spec.m");
    }

    @Override
    public String export() {
        String outfilename = this.getOutFilename("m");
        int shortnameIx = outfilename.lastIndexOf(this.separator);
        String shortname = "M" + outfilename.substring(shortnameIx + 1);
        outfilename = String.valueOf(outfilename.substring(0, shortnameIx + 1)) + shortname;
        StringBuffer out = new StringBuffer();
        int maxTagLength = 0;
        int length = 0;
        int maxValLength = 0;
        int vlen = 0;
        ArrayList<String> newtags = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> oldtags = new ArrayList<String>();
        String tag2 = null;
        String newTag = null;
        String units = null;
        String value = null;
        String type = null;
        String[] complex = new String[2];
        Set<String> tags = this._th.getTags();
        for (String tag2 : tags) {
            if (tag2.contains("DataSeriesValues")) continue;
            type = this._th.getType(tag2);
            value = this._th.getValue(tag2);
            if (value.contains("NULL")) {
                value = type.contains("txt") ? "" : (type.contains("int") ? String.valueOf(Integer.MIN_VALUE) : "NaN");
            }
            if (type.contains("txt")) {
                value = "'" + value + "'";
            }
            if (type.contains("cpx") && !value.contains("NaN")) {
                complex = value.split(" ");
                value = String.valueOf(complex[0].trim()) + "+i*" + complex[1].trim();
            }
            units = this._th.getUnits(tag2);
            if (tag2.contains("DataSeries.OrdinateUnits(")) {
                tag2 = String.valueOf(tag2.substring(0, 11)) + "U" + tag2.substring(tag2.indexOf("(") + 1, tag2.indexOf(")"));
            } else if (tag2.contains("DataSeries.OrdinateFormat(")) {
                tag2 = String.valueOf(tag2.substring(0, 12)) + tag2.substring(tag2.indexOf("(") + 1, tag2.indexOf(")"));
            }
            newTag = this.getShorterTag(tag2);
            length = newTag.length();
            if (length > maxTagLength) {
                maxTagLength = length;
            }
            if (newTag.endsWith(")") && units != null) {
                newtags.add(String.valueOf(newTag) + ".Val");
            } else {
                if (newTag.endsWith("(1)")) {
                    newTag = newTag.substring(0, newTag.length() - 3);
                }
                newtags.add(newTag);
            }
            values.add(value);
            vlen = value.length();
            if (vlen > maxValLength) {
                maxValLength = vlen;
            }
            oldtags.add(" % " + tag2 + "\n");
            if (units == null) continue;
            if (newTag.endsWith(")")) {
                newtags.add(String.valueOf(newTag) + ".Unit");
            } else {
                newtags.add(String.valueOf(newTag) + "Unit");
            }
            String temp = "'" + units + "'";
            values.add(temp);
            vlen = temp.length();
            if (vlen > maxValLength) {
                maxValLength = vlen;
            }
            oldtags.add("\n");
        }
        int i = 0;
        while (i < newtags.size()) {
            out.append((String)newtags.get(i)).append(this.getContentTagSpaces(maxTagLength, (String)newtags.get(i))).append(" = ");
            out.append((String)values.get(i)).append(";").append(this.getContentTagSpaces(maxValLength, (String)values.get(i)));
            out.append((String)oldtags.get(i));
            ++i;
        }
        out.append("DSer.Vals").append(" = [\n").append(this._data).append("\n];");
        if (this._isTimeSeries) {
            out.append(this.tsMfile);
        } else {
            out.append(this.rsMfile);
        }
        return this.writeBuffer(outfilename, out);
    }

    private String getContentTagSpaces(int length, String contentTag) {
        int spaces = length - contentTag.length();
        String spaceString = "";
        int j = 0;
        while (j < spaces) {
            spaceString = spaceString.concat(" ");
            ++j;
        }
        return spaceString;
    }

    private String getShorterTag(String tag) {
        StringBuffer shString = new StringBuffer();
        String[] components = tag.split("\\.");
        StringBuffer comp = null;
        String reorg = null;
        String test = null;
        String amass = null;
        int lastIndex = 0;
        int last = 0;
        int parIx = 0;
        boolean foundCaps = false;
        int i = 0;
        while (i < components.length) {
            comp = new StringBuffer(components[i]);
            comp = this.replace(comp, "SerialNumber", "SN");
            comp = this.replace(comp, "hannel", "h");
            comp = this.replace(comp, "NumberOf", "No");
            comp = this.replace(comp, "Number", "No");
            comp = this.replace(comp, "Agency", "Agy");
            comp = this.replace(comp, "Checksum", "Chk");
            comp = this.replace(comp, "Identifier", "ID");
            comp = this.replace(comp, "identifier", "ID");
            comp = this.replace(comp, "Peak", "Pk");
            comp = this.replace(comp, "Series", "Ser");
            comp = this.replace(comp, "GeoLocation", "GLoc");
            comp = this.replace(comp, "Location", "Loc");
            comp = this.replace(comp, "Second", "Sec");
            comp = this.replace(comp, "Locus", "Loc");
            comp = this.replace(comp, "Sensitivity", "Stvy");
            comp = this.replace(comp, "Model", "Modl");
            comp = this.replace(comp, "Latitude", "Lat");
            comp = this.replace(comp, "Depth", "Dep");
            comp = this.replace(comp, "Height", "Ht");
            comp = this.replace(comp, "Value", "Val");
            comp = this.replace(comp, "Event", "Evt");
            comp = this.replace(comp, "Array", "Arr");
            comp = this.replace(comp, "Error", "Err");
            comp = this.replace(comp, "Decay", "Dcay");
            comp = this.replace(comp, "Period", "Per");
            comp = this.replace(comp, "Datum", "Dtum");
            comp = this.replace(comp, "Owner", "Ownr");
            comp = this.replace(comp, "Index", "Indx");
            comp = this.replace(comp, "Interval", "Intv");
            comp = this.replace(comp, "Denominator", "Den");
            comp = this.replace(comp, "Numerator", "Num");
            comp = this.replace(comp, "Solution", "Soln");
            comp = this.replace(comp, "Building", "Bldg");
            comp = this.replace(comp, "building", "Bldg");
            comp = this.replace(comp, "Occupancy", "Occ");
            comp = this.replace(comp, "Bridge", "Brdg");
            comp = this.replace(comp, "Strike", "Strk");
            comp = this.replace(comp, "Source", "Src");
            comp = this.replace(comp, "Moment", "Momt");
            comp = this.replace(comp, "AbutmentType", "Abut");
            comp = this.replace(comp, "Material", "Matl");
            comp = this.replace(comp, "Volume", "Vol");
            comp = this.replace(comp, "Final", "Fnal");
            comp = this.replace(comp, "Review", "Revw");
            comp = this.replace(comp, "GtoGalConversionConstant", "GGConv");
            amass = comp.substring(0, 1);
            lastIndex = 0;
            foundCaps = false;
            int j = 1;
            while (j < comp.length()) {
                test = comp.substring(j, j + 1);
                if (test.matches("[A-Z]")) {
                    foundCaps = true;
                    amass = String.valueOf(amass) + test;
                    lastIndex = j;
                }
                ++j;
            }
            parIx = comp.indexOf("(");
            reorg = comp.toString();
            if (foundCaps) {
                if (parIx > 0) {
                    if (parIx - lastIndex > 3) {
                        reorg = String.valueOf(amass) + comp.substring(lastIndex + 1, lastIndex + 4) + comp.substring(parIx, comp.indexOf(")") + 1);
                    } else {
                        test = parIx - lastIndex < 2 ? "" : comp.substring(lastIndex + 1, parIx);
                        reorg = String.valueOf(amass) + test + comp.substring(parIx, comp.indexOf(")") + 1);
                    }
                } else {
                    last = comp.length();
                    if (last > lastIndex + 4) {
                        last = lastIndex + 4;
                    }
                    reorg = String.valueOf(amass) + comp.substring(lastIndex + 1, last);
                }
            } else if (parIx > 0) {
                if (parIx > 4) {
                    reorg = String.valueOf(comp.substring(0, 4)) + comp.substring(parIx, comp.indexOf(")") + 1);
                }
            } else {
                if (comp.length() > 4) {
                    comp.setLength(4);
                }
                reorg = comp.toString();
            }
            comp = new StringBuffer(reorg);
            shString.append(comp);
            shString.append(".");
            ++i;
        }
        reorg = shString.toString().substring(0, shString.length() - 1);
        return reorg;
    }

    private StringBuffer replace(StringBuffer input, String searchVal, String replacement) {
        StringBuffer output = new StringBuffer(input);
        int ix = input.indexOf(searchVal);
        if (ix > -1) {
            output.replace(ix, ix + searchVal.length(), replacement);
        }
        return output;
    }

    protected String readFile(String fname) {
        ClassLoader cl = this.getClass().getClassLoader();
        StringBuffer sb = new StringBuffer();
        try {
            int ch;
            InputStreamReader isr = new InputStreamReader(cl.getResourceAsStream(fname));
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                sb.append((char)ch);
            }
            ((Reader)in).close();
            return sb.toString();
        }
        catch (Exception ee2) {
            System.err.println("Error accessing file:" + fname + "  " + ee2.toString());
            return sb.toString();
        }
    }
}

