/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.cosmos.converter.Grapher;

public class LogSpecGrapher
extends Grapher {
    private static final long serialVersionUID = 1L;
    protected int minploty;
    protected int maxploty;
    protected int minplotx;
    protected int maxplotx;
    protected float plotxrange;
    protected int numPoints;
    protected int SecMultiplier;
    protected int ValMultiplier;
    protected float xrange;
    protected float plotMax;
    protected float yrange;
    protected float[] bigY;
    protected float xfact;
    protected int[] x;
    protected int[] y;
    protected float plotHeight;
    protected float plotMid;
    protected int SecPerTick;
    protected int ValPerTick;
    protected float yfact;
    protected int ytop;
    protected int ybottom;
    protected String dampValue;
    protected String xunits;

    public LogSpecGrapher() {
        this.ytop = (int)this.AbovePlot;
        this.SecMultiplier = 100;
        this.ValMultiplier = 100;
        this.SecPerTick = this.SecMultiplier / 10;
        this.ValPerTick = 5;
    }

    @Override
    public void toPoints(String dataFile, String xaxisunits, String units, int dampingIndex, String dampingValue, float xxmin, float xxmax) {
        this.s = this.getSize();
        if (dataFile.length() < 40) {
            System.out.println("Insufficient data points to plot");
            return;
        }
        this.myUnits = units;
        this.xunits = xaxisunits;
        if ((double)xxmin < 0.01) {
            xxmin = 0.01f;
        }
        this.dampValue = dampingValue;
        StringTokenizer st = new StringTokenizer(dataFile.trim(), this.delims);
        this.xdata = new ArrayList(st.countTokens());
        this.ydata = new ArrayList(st.countTokens());
        int j = 0;
        String tempString = null;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(line, " ");
            Float tempx = Float.valueOf(Float.parseFloat(st2.nextToken().trim()));
            if (!(tempx.floatValue() >= xxmin) || !(tempx.floatValue() <= xxmax)) continue;
            double tx = tempx.floatValue();
            float txlf = Float.parseFloat(String.valueOf(Math.log10(tx)));
            this.xdata.add(Float.valueOf(txlf));
            int i = 0;
            while (i <= dampingIndex) {
                tempString = st2.nextToken();
                ++i;
            }
            double ty = Double.parseDouble(tempString.trim());
            float tylf = Float.parseFloat(String.valueOf(Math.log10(ty)));
            this.ydata.add(Float.valueOf(tylf));
            if (tylf < this.miny) {
                this.miny = tylf;
            }
            if (tylf > this.maxy) {
                this.maxy = tylf;
            }
            ++j;
        }
        this.xdata.trimToSize();
        this.numPoints = this.xdata.size();
        this.minx = ((Float)this.xdata.get(0)).floatValue();
        this.maxx = ((Float)this.xdata.get(this.numPoints - 1)).floatValue();
        this.xrange = (this.maxx - this.minx) * 1.1f;
        this.plotMax = (float)((int)(this.maxy - this.miny)) + 1.0f;
        this.yrange = this.plotMax * 1.1f;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.s = this.getSize();
        if (this.s.width == 0) {
            this.s = this.getPreferredSize();
        }
        this.ybottom = (int)((float)this.s.height - this.BelowPlot);
        this.plotHeight = (float)this.s.height - this.BelowPlot - this.AbovePlot - 2.0f * this.lineWidth;
        this.xfact = (float)this.s.width / this.xrange;
        this.yfact = this.plotHeight / this.plotMax;
        Graphics2D g2 = (Graphics2D)g;
        this.setImage(g2);
        g2.drawImage((Image)offimg, 0, 0, this);
    }

    public void setImage(Graphics2D comp) {
        int val;
        offimg = (BufferedImage)this.createImage(this.s.width, this.s.height);
        comp = offimg.createGraphics();
        comp.setBackground(Color.WHITE);
        comp.clearRect(0, 0, this.s.width, this.s.height);
        this.x = new int[this.numPoints];
        this.y = new int[this.numPoints];
        int i = 0;
        while (i < this.numPoints) {
            this.x[i] = (int)((((Float)this.xdata.get(i)).floatValue() - this.minx) * this.xfact + this.xOffset);
            this.y[i] = (int)((float)this.ybottom + this.lineWidth - (((Float)this.ydata.get(i)).floatValue() - this.miny) * this.yfact);
            ++i;
        }
        comp.setFont(this.f);
        int xstart = this.x[0];
        int xend = this.x[this.numPoints - 1];
        float myxmin = ((Float)this.xdata.get(0)).floatValue();
        int xLabelStart = xstart;
        int datastart = (int)myxmin;
        int thismin = (int)this.minx;
        int thismax = (int)this.maxx;
        int iTicks = thismax - thismin + 1;
        ArrayList<Integer> xLongTick = null;
        try {
            xLongTick = new ArrayList<Integer>(iTicks);
        }
        catch (Exception e) {
            System.err.println("min:" + thismin + " max:" + thismax + " num ticks:" + iTicks);
            System.exit(1);
        }
        int j = thismin;
        while (j <= thismax) {
            int val2 = (int)(this.xOffset + ((float)j - this.minx) * this.xfact);
            xLongTick.add(val2);
            ++j;
        }
        int xnudge = this.fontHeight / 4;
        int longerTick = this.ybottom + 8;
        int labelbottom = this.ybottom + 17;
        String numSec = null;
        i = 0;
        while (i < iTicks) {
            comp.drawLine((Integer)xLongTick.get(i), this.ybottom, (Integer)xLongTick.get(i), longerTick);
            comp.setColor(Color.LIGHT_GRAY);
            comp.drawLine((Integer)xLongTick.get(i), this.ybottom, (Integer)xLongTick.get(i), this.ytop);
            comp.setColor(Color.BLACK);
            int val3 = i + datastart;
            numSec = String.valueOf(val3);
            xnudge = this.fontHeight / 2;
            if (val3 > 9) {
                xnudge += this.fontHeight / 2;
            }
            comp.drawString("10", (Integer)xLongTick.get(i) - xnudge * 2 - 1, labelbottom);
            comp.setFont(this.smallf);
            comp.drawString(numSec, (Integer)xLongTick.get(i) + xnudge - 2, labelbottom - 4);
            comp.setFont(this.f);
            ++i;
        }
        if (this.xunits.contains("Hz")) {
            comp.drawString("Hz", (xend - xLabelStart) / 2, this.ybottom + 25);
        } else {
            comp.drawString("Period (sec)", (xend - xLabelStart) / 2, this.ybottom + 25);
        }
        comp.drawLine(xstart, this.ybottom, xend, this.ybottom);
        comp.drawLine(xstart, this.ytop, xstart, this.ybottom);
        String dampingString = "Damping = " + this.dampValue + "%";
        thismin = (int)this.miny;
        thismax = (int)this.maxy;
        iTicks = thismax - thismin + 1;
        ArrayList<Integer> yLongTick = new ArrayList<Integer>(iTicks);
        int j2 = thismin;
        while (j2 <= thismax) {
            val = (int)((float)this.ybottom - ((float)j2 - this.miny) * this.yfact);
            yLongTick.add(val);
            ++j2;
        }
        datastart = thismin;
        int ynudge = this.fontHeight / 4;
        longerTick = xstart - 5;
        ynudge = this.fontHeight / 2;
        i = 0;
        while (i < iTicks) {
            comp.drawLine(longerTick, (Integer)yLongTick.get(i), xstart, (Integer)yLongTick.get(i));
            comp.setColor(Color.LIGHT_GRAY);
            if ((Integer)yLongTick.get(i) != this.ybottom) {
                comp.drawLine(xend, (Integer)yLongTick.get(i), xstart, (Integer)yLongTick.get(i));
            }
            comp.setColor(Color.BLACK);
            val = i + datastart;
            String sval = String.valueOf(val);
            comp.drawString("10", xstart - this.fm.stringWidth(sval) - 15, (Integer)yLongTick.get(i) + ynudge);
            comp.setFont(this.smallf);
            comp.drawString(String.valueOf(val), xstart - this.fm.stringWidth(sval) - 3, (Integer)yLongTick.get(i) + ynudge - 6);
            comp.setFont(this.f);
            ++i;
        }
        if (this.dampValue != null) {
            comp.drawString(dampingString, xend - this.fm.stringWidth(dampingString), this.ytop + this.fontHeight);
        }
        String yAxisUnits = "Y Axis units = " + this.myUnits;
        comp.drawString(yAxisUnits, xend - this.fm.stringWidth(yAxisUnits), this.ytop + this.fontHeight * 3);
        GeneralPath dependent = new GeneralPath(0, this.numPoints);
        dependent.moveTo(this.x[0], this.y[0]);
        i = 1;
        while (i < this.numPoints) {
            dependent.lineTo(this.x[i], this.y[i]);
            ++i;
        }
        comp.draw(dependent);
        this.x = null;
        this.y = null;
    }
}

