/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.cosmos.converter.ConverterFrame;
import org.cosmos.converter.TagManager;
import org.cosmos.to_tag.FileFetcher;
import org.cosmos.to_tag.MatrixHandler;
import org.cosmos.to_tag.ProcessFormat;
import org.cosmos.to_tag.TableHandler;
import org.cosmos.to_tag.data;
import org.cosmos.utils.FileHandler;
import org.cosmos.utils.FileSplitter;
import org.cosmos.utils.TagHeader;

public class InputManager {
    private FileHandler fh = new FileHandler();
    private ArrayList<TagManager> tm;
    private String[] tagfile;
    private String[] outFilename;
    private boolean haveText = false;
    private int numFiles = 0;
    private boolean isTimeSeries = false;
    private boolean isSpec;
    private int ndamps;
    private MatrixHandler mh = null;
    private String errorMessage = null;
    private TableHandler tbh = null;
    FileSplitter fs;
    private static int headerLinesToSkip = 1;
    private static String commentIndicator = "||";
    private static String contentString = "DataSeries.DataSeriesValues_txt";
    private static String beginContent = "{";
    private static String endContent = "};";

    public FileHandler getFileHandler() {
        return this.fh;
    }

    public boolean isDir() {
        return this.fh.isDir();
    }

    public boolean haveText() {
        return this.haveText;
    }

    public boolean isSingleton() {
        return this.fh.isSingleFile();
    }

    public boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public boolean isSpec() {
        return this.isSpec;
    }

    public String getInputDirName() {
        return this.fh.getInputDirName();
    }

    public void setDefaultOutput() {
        this.fh.setOutputDir(this.fh.getInputDirName());
    }

    public String setOutputDir(String dir) {
        return this.fh.setOutputDir(dir);
    }

    public String setOutputDir() {
        return this.fh.setOutputDir();
    }

    public String getOutputDirName() {
        return this.fh.getOutputDirName();
    }

    public Vector<String> getSplitOutputFileList() {
        return this.fs.getSplitOutputFileList();
    }

    public void resetSplitFiles() {
        if (this.fs != null) {
            this.fs.resetSplitFileList();
        }
    }

    protected boolean inputIsDirectory(String filename) {
        boolean isDir = this.fh.isFolder(filename);
        return isDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String splitSplittableFile(String inputType, String filename) {
        this.fs = new FileSplitter();
        String f = filename;
        String _inputType = inputType.toLowerCase();
        StringBuffer message = new StringBuffer("");
        String errorMessage = null;
        String shortname = this.fh.getShortName(f);
        String type = this.fh.getDataType(f);
        String format = this.fh.getFormatType(f);
        message.append("Splitting file: " + shortname);
        if (_inputType.startsWith("cgs")) {
            try {
                if (f.toUpperCase().endsWith("V2") || f.toUpperCase().endsWith("V3")) {
                    message.append(", a cgs multi-file.\n");
                    errorMessage = this.fs.splitCSMIP2(this.fh, f, shortname);
                    if (errorMessage == null) return message.toString();
                    message.append(errorMessage);
                    return message.toString();
                }
                if (!f.toUpperCase().endsWith("V1")) return null;
                message.append(", a cgs unprocessed multi-file.\n");
                errorMessage = this.fs.splitByChannel(this.fh, f, shortname);
                if (errorMessage == null) return message.toString();
                message.append(errorMessage);
                return message.toString();
            }
            catch (Exception exception) {
                return message.toString();
            }
        } else if (_inputType.startsWith("gns")) {
            try {
                if (f.toUpperCase().endsWith("V2A")) {
                    message.append(", a gns multi-file.\n");
                    errorMessage = this.fs.splitNZ(this.fh, f, shortname);
                    if (errorMessage == null) return message.toString();
                    message.append(errorMessage);
                    return message.toString();
                }
                if (f.toUpperCase().endsWith("V1A") || f.toUpperCase().endsWith("V3A")) {
                    message.append(", a gns uncorrected multi-file.\n");
                    errorMessage = this.fs.splitByChannel(this.fh, f, shortname);
                    if (errorMessage == null) return message.toString();
                    message.append(errorMessage);
                    return message.toString();
                }
                if (!f.toUpperCase().endsWith("V3A")) return null;
                message.append(", a gns spectra multi-file.\n");
                errorMessage = this.fs.splitByChannel(this.fh, f, shortname);
                if (errorMessage == null) return message.toString();
                message.append(errorMessage);
                return message.toString();
            }
            catch (Exception exception) {
                return message.toString();
            }
        } else {
            message.append(" not possible, un-recognized type.\n");
        }
        return message.toString();
    }

    public String splitSplittableFiles(String inputType) {
        StringBuffer message;
        block11: {
            String errorMessage;
            String _inputType;
            block10: {
                this.fs = new FileSplitter();
                _inputType = inputType.toLowerCase();
                message = new StringBuffer("");
                errorMessage = null;
                if (!_inputType.startsWith("cgs")) break block10;
                String[] files = this.fh.getSplittableCSMIPFiles();
                int i = 0;
                while (i < files.length) {
                    String shortname = this.fh.getShortName(files[i]);
                    if (!shortname.startsWith(".")) {
                        message.append("Splitting file: " + shortname + ", a cgs multi-file");
                        String type = this.fh.getDataType(files[i]);
                        String format = this.fh.getFormatType(files[i]);
                        message.append(" type:" + type + "\n");
                        try {
                            errorMessage = type.equals("spectra") || type.contains("unprocessed") ? this.fs.splitByChannel(this.fh, files[i], shortname) : this.fs.splitCSMIP2(this.fh, files[i], shortname);
                            if (errorMessage != null) {
                                message.append(errorMessage);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                break block11;
            }
            if (!_inputType.startsWith("gns")) break block11;
            String[] files = this.fh.getSplittableNZFiles();
            System.out.println("num splittable GNS files: " + files.length);
            int i = 0;
            while (i < files.length) {
                String shortname = this.fh.getShortName(files[i]);
                if (!shortname.startsWith(".")) {
                    message.append("Splitting file: " + shortname + ", a gns multi-file");
                    String type = this.fh.getDataType(files[i]);
                    String format = this.fh.getFormatType(files[i]);
                    message.append("; type=" + type + " format=" + format + "\n");
                    try {
                        errorMessage = type.equals("spectra") ? this.fs.splitByChannel(this.fh, files[i], shortname) : (type.contains("unprocessed") ? this.fs.splitByChannel(this.fh, files[i], shortname) : this.fs.splitNZ(this.fh, files[i], shortname));
                        if (errorMessage != null) {
                            message.append(errorMessage);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return message.toString();
    }

    public String findOutput(String previous) {
        return this.fh.findOutput(previous);
    }

    public File getOutputDir() {
        this.setDefaultOutput();
        return this.fh.getOutputDir();
    }

    public String getFirstfileName() {
        return this.fh.getFirstFileName();
    }

    public String setFileName(String name) {
        return this.fh.setFileName(name);
    }

    public String getFileName(String previousFile) {
        return this.fh.getFileName(previousFile);
    }

    public String getFileName() {
        return this.fh.getFileName();
    }

    public String[] getFileNames() {
        return this.fh.getFileNames();
    }

    public String getData(int i) {
        return this.tm.get(i).getTextData();
    }

    public int getNoOutputFiles() {
        return this.numFiles;
    }

    public void setText() {
        this.haveText = true;
    }

    public String getXUnits(int i) {
        return this.haveText ? this.tm.get(i).getXUnits() : null;
    }

    public String getYUnits(int i) {
        return this.haveText ? this.tm.get(i).getYUnits() : null;
    }

    public String getUnits(int i, int index) {
        return this.haveText ? this.tm.get(i).getUnits(index) : null;
    }

    public int getNpts(int i) {
        return this.haveText ? Integer.valueOf(this.tm.get(i).getNumPoints()) : null;
    }

    public double getSamplesPerSec(int i) {
        return this.haveText ? Double.valueOf(this.tm.get(i).getSamplesPerSecond()) : null;
    }

    public String getFactor(int i) {
        return this.haveText ? this.tm.get(i).getFactor() : null;
    }

    public String[] getDamps(int i) {
        if (!this.haveText) {
            return null;
        }
        this.ndamps = this.tm.get(i).getNoDamps();
        String[] damps = new String[this.ndamps];
        ArrayList<String> tempDamps = this.haveText ? this.tm.get(i).getDamps() : null;
        int j = 0;
        while (j < this.ndamps) {
            damps[j] = String.valueOf((int)(Float.parseFloat(tempDamps.get(j)) * 100.0f));
            ++j;
        }
        return damps;
    }

    public boolean isDFT(int i) {
        return this.haveText ? Boolean.valueOf(this.tm.get(i).isDFT()) : null;
    }

    public float getSpan(int i) {
        if (this.isTimeSeries) {
            return (this.haveText ? Float.valueOf(this.tm.get(i).getSpan()) : null).floatValue();
        }
        return (this.haveText ? Float.valueOf(this.tm.get(i).getLastFreq()) : null).floatValue();
    }

    public float getDataMin(int i) {
        if (this.isTimeSeries) {
            return 0.0f;
        }
        return (this.haveText ? Float.valueOf(this.tm.get(i).getFirstFreq()) : null).floatValue();
    }

    public String[] readTable(String path) {
        FileFetcher ff1 = new FileFetcher();
        return ff1.readTable(path);
    }

    public String convertToTags(ProcessFormat proc, String[] rows, String tableLoc, String filename) {
        block9: {
            this.tm = new ArrayList();
            this.haveText = false;
            proc.setTemplate();
            this.mh = new MatrixHandler();
            this.errorMessage = this.mh.fillMatrix(rows, proc.getTemplate(), proc);
            this.tbh = new TableHandler();
            this.errorMessage = this.tbh.setTableLines(tableLoc, headerLinesToSkip);
            if (this.errorMessage != null) {
                return this.errorMessage;
            }
            proc.setTableHandler(this.tbh);
            if (this.fh.getShortName(filename).startsWith(".") || this.fh.isFolder(filename)) break block9;
            proc.readFile(filename);
            this.errorMessage = proc.setComponents();
            if (this.errorMessage != null) {
                return this.errorMessage;
            }
            this.errorMessage = this.mh.process();
            if (this.errorMessage != null) {
                return this.errorMessage;
            }
            String start = null;
            Object end = null;
            this.mh.finalize();
            try {
                proc.getData();
            }
            catch (Exception ee) {
                return "couldn't get data";
            }
            try {
                data[] dats = proc.getData();
                this.tagfile = new String[dats.length];
                this.outFilename = new String[dats.length];
                int j = 0;
                while (j < dats.length) {
                    String temp = "";
                    proc.resetElements(this.mh, dats[j]);
                    this.outFilename[j] = this.fh.getOutputDir() + ConverterFrame.fileSeparator + proc.getOutputFileName(dats[j].getShortName());
                    String[] head = this.mh.getHeaderArray(commentIndicator);
                    temp = this.consolidate(head);
                    start = String.valueOf(contentString) + this.mh.getRemainingSpaces(contentString) + "= " + beginContent;
                    temp = temp.concat(String.valueOf(start) + "\n");
                    temp = temp.concat(this.consolidate(dats[j].toStringArray()));
                    this.tagfile[j] = temp.concat(endContent);
                    TagManager t = new TagManager();
                    t.importTagged(this.tagfile[j]);
                    this.isTimeSeries = t.isTimeSeries();
                    this.tm.add(t);
                    ++j;
                }
            }
            catch (Exception ee) {
                return "Could not process tag file.\n" + ee.toString();
            }
        }
        this.setText();
        this.numFiles = this.tm.size();
        return null;
    }

    public String consolidate(String[] array) {
        if (array == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int length = array.length;
        int i = 0;
        while (i < length) {
            sb.append(String.valueOf(array[i]) + "\n");
            ++i;
        }
        return sb.toString();
    }

    public TagHeader getTagSet(int i) {
        if (this.haveText) {
            return this.tm.get(i).getTagSet();
        }
        return null;
    }

    public String getTagFilename(int i) {
        return this.outFilename[i];
    }

    public String getTagFile(int i) {
        return this.tagfile[i];
    }
}

