/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.cosmos.converter.Exporter;

public class ExcelExporter
extends Exporter {
    HSSFSheet sheet;
    HSSFWorkbook wb;
    POIFSFileSystem TSFS;
    POIFSFileSystem SpecFS;
    POIFSFileSystem FSpecFS;
    POIFSFileSystem FHzSpecFS;
    HSSFRow row;
    HSSFCell cell;

    public ExcelExporter() {
        this.readTemplates();
    }

    @Override
    public String export() {
        String outfilename = this.getOutFilename("xls");
        Set<String> tags = this._th.getTags();
        String tag2 = null;
        String val = null;
        String xunits = "s";
        String units = "";
        String data2 = "";
        String sps = "";
        String sint = "";
        String type = "";
        ArrayList<String> damps = new ArrayList<String>();
        String err = null;
        err = this._isTimeSeries ? this.getSheet(this.TSFS, outfilename) : (outfilename.contains("DFT") ? (xunits.contains("Hz") ? this.getSheet(this.FHzSpecFS, outfilename) : this.getSheet(this.FSpecFS, outfilename)) : this.getSheet(this.SpecFS, outfilename));
        if (err != null) {
            return err;
        }
        int nullInt = Integer.MIN_VALUE;
        double nullDouble = Double.NaN;
        int ix = 2;
        String valType = null;
        for (String tag2 : tags) {
            if (tag2.startsWith("DataSeries.OrdinateUnits(")) {
                units = this._th.getValue(tag2);
            }
            if (tag2.startsWith("DataSeries.AbscissaUnits(")) {
                xunits = this._th.getValue(tag2);
            }
            if (tag2.startsWith("DataSeries.SamplesPerSecond")) {
                sps = this._th.getValue(tag2);
            }
            if (tag2.startsWith("DataSeries.SampleInterval")) {
                sint = this._th.getValue(tag2);
            }
            if (tag2.startsWith("DataSeries.PhysicalParameter")) {
                type = this._th.getValue(tag2);
            }
            if (tag2.startsWith("DataSeries.ResponseSpectrumDamping")) {
                damps.add(this._th.getValue(tag2));
            }
            if (tag2.startsWith("DataSeries.DataSeriesValues")) {
                data2 = this._th.getValue(tag2);
                continue;
            }
            try {
                this.row = this.sheet.getRow(ix);
                if (this.row == null) {
                    this.row = this.sheet.createRow(ix);
                }
                this.cell = this.getCell(0);
                this.cell.setCellType(1);
                this.cell.setCellValue(tag2);
                this.cell = this.getCell(1);
                valType = this._th.getType(tag2);
                val = this._th.getValue(tag2);
                if (valType.contains("int")) {
                    this.cell.setCellType(0);
                    if (val.startsWith("NULL")) {
                        this.cell.setCellValue("NULL");
                    } else {
                        this.cell.setCellValue(Integer.valueOf(val).intValue());
                    }
                } else if (valType.contains("dbl")) {
                    this.cell.setCellType(0);
                    if (val.startsWith("NULL")) {
                        this.cell.setCellValue("NULL");
                    } else {
                        this.cell.setCellValue(Double.valueOf(val));
                    }
                } else {
                    this.cell.setCellType(1);
                    this.cell.setCellValue(val);
                }
                this.cell = this.getCell(2);
                this.cell.setCellType(1);
                this.cell.setCellValue(this._th.getUnits(tag2));
                this.cell = this.getCell(3);
                this.cell.setCellType(1);
                this.cell.setCellValue(this._th.getNote(tag2));
                ++ix;
            }
            catch (Exception e) {
                return "error adding header to cells: " + e.toString();
            }
        }
        if (this._isTimeSeries) {
            if (sint.length() < 1) {
                double sampPerSec = Double.valueOf(sps);
                sint = String.valueOf(1.0 / sampPerSec);
            }
            this.addTSdata(sint, data2, type, units);
        } else {
            this.addRSdata(damps, data2, type, units, xunits);
        }
        try {
            FileOutputStream fos = new FileOutputStream(outfilename);
            this.wb.write(fos);
            fos.close();
        }
        catch (Exception e) {
            return "Error writing/closing Excel workbook";
        }
        return "Output to file: " + outfilename;
    }

    private void addTSdata(String sint, String data2, String type, String units) {
        String[] dVals = data2.split("\n");
        this.row = this.sheet.getRow(2);
        this.cell = this.getCell(5);
        int lastCell = dVals.length + 2;
        this.cell.setCellValue("$G$3:$H$" + lastCell);
        double sampInt = Double.valueOf(sint);
        double time = 0.0;
        double revTime = 0.0;
        this.row = this.sheet.getRow(1);
        this.cell = this.getCell(7);
        this.cell.setCellValue(String.valueOf(type) + " (" + units + ")");
        int decimalPlaces = 2;
        this.cell.setAsActiveCell();
        int i = 0;
        while (i < dVals.length) {
            this.row = this.sheet.getRow(i + 2);
            if (this.row == null) {
                this.row = this.sheet.createRow(i + 2);
                this.cell = this.getCell(0);
                this.cell.setCellType(1);
                this.cell.setCellValue("");
            }
            this.cell = this.getCell(6);
            this.cell.setCellType(0);
            BigDecimal bd = new BigDecimal(time);
            bd.setScale(decimalPlaces, 4);
            this.cell.setCellValue(bd.doubleValue());
            time += sampInt;
            this.cell = this.getCell(7);
            this.cell.setCellType(0);
            this.cell.setCellValue(Double.valueOf(dVals[i]));
            ++i;
        }
        this.row = this.sheet.getRow(2);
        this.cell = this.getCell(5);
        this.cell.setAsActiveCell();
    }

    private void addRSdata(ArrayList<String> damps, String data2, String type, String units, String xunits) {
        String[] cols = new String[]{"G", "H", "I", "J", "K", "L", "M", "N"};
        String[] dRows = data2.split("\n");
        boolean resp = type.contains("Response");
        this.row = this.sheet.getRow(2);
        this.cell = this.getCell(5);
        int length = dRows.length + 2;
        if (resp) {
            this.cell.setCellValue("$G$3:$" + cols[damps.size()] + "$" + length);
        } else {
            if (xunits.contains("Hz")) {
                length = dRows.length;
            }
            this.cell.setCellValue("$G$3:$H$" + length);
        }
        HSSFCellStyle cs = this.wb.createCellStyle();
        cs.setWrapText(true);
        int rowNum = resp ? 0 : 1;
        this.row = this.sheet.getRow(rowNum);
        if (this.row == null) {
            this.row = this.sheet.createRow(rowNum);
        }
        this.cell = this.getCell(7);
        this.cell.setCellType(1);
        this.cell.setCellValue(String.valueOf(type) + " (" + units + ")");
        this.row = this.sheet.getRow(1);
        String newDamp = null;
        if (resp) {
            int i = 0;
            while (i < damps.size()) {
                this.cell = this.getCell(7 + i);
                this.cell.setCellStyle(cs);
                double damp = Double.valueOf(damps.get(i)) * 100.0;
                newDamp = String.valueOf(String.valueOf(damp)) + "%";
                this.cell.setCellValue(String.valueOf(newDamp) + " damping");
                ++i;
            }
        }
        int datastart = 0;
        if (xunits.contains("Hz")) {
            this.cell = this.getCell(6);
            this.cell.setCellType(1);
            this.cell.setCellValue("Freq (Hz)");
            datastart = 1;
        }
        int i = 0;
        while (i < dRows.length - datastart) {
            String[] dVals = dRows[i + datastart].trim().split("[\\s]+");
            this.row = this.sheet.getRow(i + 2);
            if (this.row == null) {
                this.row = this.sheet.createRow(i + 2);
            }
            this.cell = this.getCell(6);
            this.cell.setCellType(0);
            this.cell.setCellValue(Double.valueOf(dVals[0]));
            int j = 1;
            while (j < dVals.length) {
                this.cell = this.getCell(6 + j);
                this.cell.setCellType(0);
                try {
                    this.cell.setCellValue(Double.valueOf(dVals[j]));
                }
                catch (Exception e) {
                    int jj = i + 1;
                    System.err.println("on data line " + jj + " can't convert to decimal:" + dVals[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private HSSFCell getCell(int i) {
        this.cell = this.row.getCell((short)i);
        if (this.cell == null) {
            this.cell = this.row.createCell((short)i);
        }
        return this.cell;
    }

    private String getSheet(POIFSFileSystem temp, String outfileName) {
        this.sheet = null;
        try {
            this.wb = new HSSFWorkbook(temp);
            this.sheet = this.wb.getSheetAt(0);
            this.wb.setSheetName(0, "Sheet1");
            return null;
        }
        catch (Exception e) {
            return "Error copying Excel template";
        }
    }

    private void readTemplates() {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            this.TSFS = new POIFSFileSystem(cl.getResourceAsStream(String.valueOf(this.packageName) + "ts.xls"));
            this.SpecFS = new POIFSFileSystem(cl.getResourceAsStream(String.valueOf(this.packageName) + "spec.xls"));
            this.FSpecFS = new POIFSFileSystem(cl.getResourceAsStream(String.valueOf(this.packageName) + "fspec.xls"));
            this.FHzSpecFS = new POIFSFileSystem(cl.getResourceAsStream(String.valueOf(this.packageName) + "fspecFreq.xls"));
        }
        catch (Exception e) {
            System.err.println("Error reading Excel template from " + this.packageName + "\n" + e.toString());
        }
    }
}

