/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.converter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.cosmos.converter.InputManager;
import org.cosmos.converter.OutputManager;
import org.cosmos.converter.PlotManager;
import org.cosmos.to_tag.ProcessFormat;

public class ConverterFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanel1 = null;
    private JLabel statusBar = null;
    private JPanel FileSelect = null;
    private JPanel ExportPanel = null;
    private DropTarget dtInput;
    private DropTarget dtOutput;
    private DropTargetListener dtlInput;
    private DropTargetListener dtlOutput;
    private JTextField InputField = null;
    private JLabel Banner = null;
    private JButton ExportButton = null;
    private JComboBox OutputType = null;
    private PlotManager pm = new PlotManager();
    private InputManager im = new InputManager();
    private OutputManager om = new OutputManager();
    private Color bcolor = new Color(200, 220, 255);
    private Border border2 = new EtchedBorder(0, Color.white, new Color(178, 178, 178));
    private float plotmin;
    private float plotmax;
    private int decimalPoints;
    private String loglinchoice = "Linear";
    private JTextField OutputField = null;
    private JButton BrowseOutput = null;
    private JComboBox InputType = null;
    private ProcessFormat proc = null;
    private String formatDir = "format/";
    private String[] rows = null;
    private String tableLoc = null;
    private String errorMessage = null;
    private String[] files = null;
    private String preparer = "Cosmos Converter v1.1";
    private String packageName = null;
    private String prefix = null;
    private JScrollPane MessageScrollPane = null;
    private JTextArea MessageArea = null;
    private JProgressBar exportProgressBar = null;
    private JButton BrowseInput = null;
    private String[] damps;
    private int preferredDampIndex;
    private JPanel DataPane1 = null;
    private JScrollPane DataScrollPane = null;
    private JPanel PlotPane = null;
    static String fileSeparator = null;
    Vector<String> splitFiles;
    private boolean isSplittableType;
    protected String[] splittableTypes;

    public ConverterFrame() {
        fileSeparator = System.getProperty("file.separator");
        this.packageName = this.getClass().getPackage().getName();
        this.prefix = String.valueOf('/') + this.packageName.replace('.', '/');
        this.initialize();
        this.setDefaultCloseOperation(3);
        this.MessageArea.setText("");
    }

    private void initialize() {
        this.setSize(new Dimension(930, 706));
        this.setTitle("Cosmos Converter");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.statusBar = new JLabel();
            this.statusBar.setText(" ");
            this.statusBar.setDisplayedMnemonic(48);
            this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel1(), "Center");
            this.jContentPane.add((Component)this.statusBar, "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(null);
            this.jPanel1.setBackground(this.bcolor);
            this.jPanel1.setMinimumSize(new Dimension(620, 600));
            this.jPanel1.setPreferredSize(new Dimension(620, 600));
            this.jPanel1.add((Component)this.getMessageScrollPane(), null);
            this.jPanel1.add((Component)this.getFileSelect(), null);
            this.jPanel1.add((Component)this.getExportPanel(), null);
            this.jPanel1.add((Component)this.getDataPane1(), null);
        }
        return this.jPanel1;
    }

    private JPanel getFileSelect() {
        if (this.FileSelect == null) {
            this.FileSelect = new JPanel();
            this.Banner = new JLabel();
            this.Banner.setBorder(BorderFactory.createEmptyBorder());
            this.Banner.setIcon(new ImageIcon(this.getClass().getResource(String.valueOf(this.prefix) + "/top_label.gif")));
            this.Banner.setBounds(new Rectangle(202, 8, 528, 50));
            this.Banner.setText("");
            this.FileSelect = new JPanel();
            this.FileSelect.setLayout(null);
            this.FileSelect.setBounds(new Rectangle(9, 4, 910, 152));
            this.FileSelect.setBorder(this.border2);
            this.FileSelect.setBackground(Color.white);
            this.FileSelect.add((Component)this.getInputField(), null);
            this.FileSelect.add((Component)this.getOutputField(), null);
            this.FileSelect.add((Component)this.getBrowseInput(), null);
            this.FileSelect.add((Component)this.getBrowseOutput(), null);
            this.FileSelect.add((Component)this.Banner, null);
            this.FileSelect.add((Component)this.getInputType(), null);
            this.FileSelect.add((Component)this.getOutputType(), null);
        }
        return this.FileSelect;
    }

    private JButton getBrowseInput() {
        if (this.BrowseInput == null) {
            this.BrowseInput = new JButton();
            this.BrowseInput.setBounds(new Rectangle(11, 64, 175, 29));
            this.BrowseInput.setFont(new Font("Lucida Grande", 0, 12));
            this.BrowseInput.setBackground(Color.white);
            this.BrowseInput.setText("Browse Input File or Dir");
            this.BrowseInput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String input = null;
                    String previous = ConverterFrame.this.InputField.getText();
                    try {
                        input = ConverterFrame.this.im.getFileName(previous);
                    }
                    catch (Exception ee) {
                        ConverterFrame.this.MessageArea.append("Error opening input file or folder:" + ee.toString() + "\n");
                        return;
                    }
                    ConverterFrame.this.InputField.setText(input);
                    ConverterFrame.this.setDefaultOutput();
                }
            });
        }
        return this.BrowseInput;
    }

    private JButton getBrowseOutput() {
        if (this.BrowseOutput == null) {
            this.BrowseOutput = new JButton();
            this.BrowseOutput.setBounds(new Rectangle(25, 102, 161, 29));
            this.BrowseOutput.setText("Browse Output Dir");
            this.BrowseOutput.setFont(new Font("Lucida Grande", 0, 12));
            this.BrowseOutput.setBackground(Color.white);
            this.BrowseOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String previous = ConverterFrame.this.OutputField.getText();
                    String outdir = ConverterFrame.this.im.findOutput(previous);
                    ConverterFrame.this.errorMessage = ConverterFrame.this.im.setOutputDir(outdir);
                    if (ConverterFrame.this.errorMessage != null) {
                        ConverterFrame.this.MessageArea.append(String.valueOf(ConverterFrame.this.errorMessage) + "\n");
                        return;
                    }
                    ConverterFrame.this.OutputField.setText(ConverterFrame.this.im.getOutputDirName());
                }
            });
        }
        return this.BrowseOutput;
    }

    public JTextField getInputField() {
        if (this.InputField == null) {
            this.InputField = new JTextField();
            this.InputField.setBounds(new Rectangle(198, 61, 532, 30));
            this.InputField.setDragEnabled(true);
            this.InputField.setDropTarget(new DropTarget(){

                @Override
                public synchronized void drop(DropTargetDropEvent evt) {
                    try {
                        evt.acceptDrop(1);
                        List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        File file = (File)droppedFiles.get(0);
                        ConverterFrame.this.InputField.setText(file.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.InputField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConverterFrame.this.errorMessage = ConverterFrame.this.im.setFileName(ConverterFrame.this.InputField.getText());
                    if (ConverterFrame.this.errorMessage != null) {
                        ConverterFrame.this.MessageArea.append(String.valueOf(ConverterFrame.this.errorMessage) + "\n");
                        return;
                    }
                    ConverterFrame.this.setDefaultOutput();
                }
            });
        }
        return this.InputField;
    }

    public JTextField getOutputField() {
        if (this.OutputField == null) {
            this.OutputField = new JTextField();
            this.OutputField.setBounds(new Rectangle(198, 103, 531, 33));
            this.OutputField.setDragEnabled(true);
            this.OutputField.setDropTarget(new DropTarget(){

                @Override
                public synchronized void drop(DropTargetDropEvent evt) {
                    try {
                        evt.acceptDrop(1);
                        List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        File file = (File)droppedFiles.get(0);
                        ConverterFrame.this.OutputField.setText(file.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.OutputField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConverterFrame.this.errorMessage = ConverterFrame.this.im.setOutputDir(ConverterFrame.this.OutputField.getText());
                    if (ConverterFrame.this.errorMessage != null) {
                        ConverterFrame.this.MessageArea.append(String.valueOf(ConverterFrame.this.errorMessage) + "\n");
                        return;
                    }
                    ConverterFrame.this.OutputField.setText(ConverterFrame.this.im.getOutputDirName());
                }
            });
        }
        return this.OutputField;
    }

    private void setDefaultOutput() {
        if (this.OutputField.getText().trim().length() == 0) {
            this.errorMessage = this.im.setOutputDir(this.im.getInputDirName());
            if (this.errorMessage != null) {
                this.MessageArea.append(String.valueOf(this.errorMessage) + "\n");
                return;
            }
            this.OutputField.setText(this.im.getOutputDirName());
        }
    }

    private JComboBox getInputType() {
        if (this.InputType == null) {
            this.InputType = new JComboBox();
            this.InputType.setBounds(new Rectangle(743, 64, 159, 29));
            this.InputType.setEditable(false);
            this.InputType.setFont(new Font("Lucida Grande", 0, 12));
            this.InputType.setBackground(Color.white);
            this.InputType.addItem("Input format type");
            String[] itypes = this.im.readTable("/InputList.txt");
            this.splittableTypes = this.im.readTable("/SplittableTypesList.txt");
            if (itypes != null) {
                int i = 0;
                while (i < itypes.length) {
                    this.InputType.addItem(itypes[i]);
                    ++i;
                }
            }
            this.InputType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String dir = e.getItem().toString();
                    String message = ConverterFrame.this.initFormat(dir);
                    if (message != null) {
                        ConverterFrame.this.MessageArea.append(String.valueOf(message) + "\n");
                        return;
                    }
                }
            });
        }
        return this.InputType;
    }

    private JComboBox getOutputType() {
        if (this.OutputType == null) {
            this.OutputType = new JComboBox();
            this.OutputType.setBounds(new Rectangle(743, 102, 159, 29));
            this.OutputType.setBackground(Color.white);
            this.OutputType.setEditable(false);
            this.OutputType.setFont(new Font("Lucida Grande", 0, 12));
            String[] otypes = this.im.readTable("/OutputList.txt");
            this.OutputType.addItem("Output file type");
            if (otypes != null) {
                int i = 0;
                while (i < otypes.length) {
                    this.OutputType.addItem(otypes[i]);
                    ++i;
                }
                this.OutputType.setSelectedItem(0);
            }
        }
        return this.OutputType;
    }

    private String initFormat(String dir) {
        block3: {
            try {
                if (!dir.contains("Input format")) break block3;
                return null;
            }
            catch (Exception ee) {
                return "Can't find a Process class for this format type " + ee.toString();
            }
        }
        Class<?> cls = Class.forName("org.cosmos." + dir + ".Process");
        Constructor<?> con = cls.getConstructor(String.class);
        this.proc = (ProcessFormat)con.newInstance(String.valueOf(this.formatDir) + dir);
        this.rows = this.im.readTable("/" + this.formatDir + dir + "/tables/TranslationTable.tab");
        this.tableLoc = "/" + this.formatDir + dir + "/tables/OriginalTables.tab";
        return null;
    }

    private JPanel getExportPanel() {
        if (this.ExportPanel == null) {
            this.ExportPanel = new JPanel();
            this.ExportPanel.setLayout(null);
            this.ExportPanel.setBounds(new Rectangle(7, 215, 152, 141));
            this.ExportPanel.setBackground(this.bcolor);
            this.ExportPanel.add((Component)this.getExportButton(), null);
            this.ExportPanel.add((Component)this.getExportProgressBar(), null);
        }
        return this.ExportPanel;
    }

    private JProgressBar getExportProgressBar() {
        if (this.exportProgressBar == null) {
            this.exportProgressBar = new JProgressBar();
            this.exportProgressBar.setBounds(new Rectangle(17, 66, 112, 21));
        }
        return this.exportProgressBar;
    }

    private JButton getExportButton() {
        if (this.ExportButton == null) {
            this.ExportButton = new JButton();
            this.ExportButton.setBounds(new Rectangle(35, 23, 75, 29));
            this.ExportButton.setBackground(this.bcolor);
            this.ExportButton.setText("Export");
            this.ExportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int num;
                    ConverterFrame.this.errorMessage = ConverterFrame.this.checkInput();
                    if (ConverterFrame.this.errorMessage != null) {
                        ConverterFrame.this.MessageArea.append(String.valueOf(ConverterFrame.this.errorMessage) + "\n");
                        return;
                    }
                    ConverterFrame.this.isSplittableType = false;
                    String type = (String)ConverterFrame.this.InputType.getSelectedItem();
                    int j = 0;
                    while (j < ConverterFrame.this.splittableTypes.length) {
                        if (ConverterFrame.this.splittableTypes[j].equals(type)) {
                            ConverterFrame.this.isSplittableType = true;
                            break;
                        }
                        ++j;
                    }
                    if (ConverterFrame.this.im.inputIsDirectory(ConverterFrame.this.InputField.getText())) {
                        ConverterFrame.this.splitFiles = null;
                        if (ConverterFrame.this.isSplittableType) {
                            ConverterFrame.this.splitSplittableInputFiles();
                            if (ConverterFrame.this.splitFiles != null && ConverterFrame.this.splitFiles.size() > 0) {
                                ConverterFrame.this.errorMessage = ConverterFrame.this.setInputFileList(ConverterFrame.this.splitFiles);
                            } else {
                                ConverterFrame.this.errorMessage = ConverterFrame.this.setInputFileList();
                            }
                        } else {
                            ConverterFrame.this.errorMessage = ConverterFrame.this.setInputFileList();
                        }
                    } else if (ConverterFrame.this.isSplittableType) {
                        ConverterFrame.this.splitSplittableInputFile();
                        if (ConverterFrame.this.splitFiles != null && ConverterFrame.this.splitFiles.size() > 0) {
                            ConverterFrame.this.errorMessage = ConverterFrame.this.setInputFileList(ConverterFrame.this.splitFiles);
                        } else {
                            ConverterFrame.this.errorMessage = ConverterFrame.this.setInputFileList();
                        }
                    } else {
                        ConverterFrame.this.errorMessage = ConverterFrame.this.setInputFileList();
                    }
                    if (ConverterFrame.this.errorMessage != null) {
                        ConverterFrame.this.MessageArea.append(String.valueOf(ConverterFrame.this.errorMessage) + "\n");
                        return;
                    }
                    String choice = (String)ConverterFrame.this.OutputType.getSelectedItem();
                    ConverterFrame.this.proc.setPrepAgency(ConverterFrame.this.preparer);
                    if (ConverterFrame.this.files.length > 0) {
                        ConverterFrame.this.exportProgressBar.setMaximum(ConverterFrame.this.files.length - 1);
                    }
                    if (choice.startsWith("Plot")) {
                        ConverterFrame.this.errorMessage = ConverterFrame.this.om.init("Plot");
                        if (ConverterFrame.this.errorMessage != null) {
                            ConverterFrame.this.MessageArea.append(String.valueOf(ConverterFrame.this.errorMessage) + "\n");
                            return;
                        }
                        int i = 0;
                        while (i < ConverterFrame.this.files.length) {
                            ConverterFrame.this.errorMessage = ConverterFrame.this.importFile(ConverterFrame.this.files[i]);
                            ConverterFrame.this.exportProgressBar.setValue(i);
                            if (ConverterFrame.this.errorMessage == null) {
                                if (ConverterFrame.this.errorMessage != null) {
                                    ConverterFrame.this.MessageArea.append(String.valueOf(ConverterFrame.this.errorMessage) + "\n");
                                    return;
                                }
                                num = ConverterFrame.this.im.getNoOutputFiles();
                                int j2 = 0;
                                while (j2 < num) {
                                    ConverterFrame.this.om.setFilename(ConverterFrame.this.im.getTagFilename(j2));
                                    if (!ConverterFrame.this.im.isTimeSeries() && !ConverterFrame.this.im.isDFT(j2)) {
                                        ConverterFrame.this.setDamps(j2);
                                    }
                                    ConverterFrame.this.initPlot();
                                    ConverterFrame.this.showPlot(j2);
                                    ConverterFrame.this.pm.paintPlot();
                                    ConverterFrame.this.om.setGrapher(ConverterFrame.this.pm.getGrapher());
                                    ConverterFrame.this.MessageArea.append(String.valueOf(ConverterFrame.this.om.export()) + "\n");
                                    ConverterFrame.this.repaintThis();
                                    ++j2;
                                }
                            } else {
                                ConverterFrame.this.MessageArea.append("cannot process for plot file " + ConverterFrame.this.files[i] + ":\n " + ConverterFrame.this.errorMessage + "\n");
                            }
                            ++i;
                        }
                    } else if (choice.startsWith("Tag")) {
                        ConverterFrame.this.errorMessage = ConverterFrame.this.om.init("Tag");
                        if (ConverterFrame.this.errorMessage != null) {
                            ConverterFrame.this.MessageArea.setText(String.valueOf(ConverterFrame.this.errorMessage) + "\n");
                            return;
                        }
                        int i = 0;
                        while (i < ConverterFrame.this.files.length) {
                            ConverterFrame.this.errorMessage = ConverterFrame.this.importFile(ConverterFrame.this.files[i]);
                            ConverterFrame.this.exportProgressBar.setValue(i);
                            if (ConverterFrame.this.errorMessage == null) {
                                num = ConverterFrame.this.im.getNoOutputFiles();
                                int j3 = 0;
                                while (j3 < num) {
                                    try {
                                        ConverterFrame.this.om.setFilename(ConverterFrame.this.im.getTagFilename(j3));
                                        ConverterFrame.this.om.setWholeFile(ConverterFrame.this.im.getTagFile(j3));
                                        ConverterFrame.this.MessageArea.append(String.valueOf(ConverterFrame.this.om.export()) + "\n");
                                    }
                                    catch (Exception ee) {
                                        ConverterFrame.this.MessageArea.append("could not write tagged file to " + ConverterFrame.this.im.getTagFilename(j3) + ", " + ee + "\n");
                                        return;
                                    }
                                    ++j3;
                                }
                                ConverterFrame.this.repaintThis();
                            } else {
                                ConverterFrame.this.MessageArea.append("cannot process for tag format file " + ConverterFrame.this.files[i] + ":\n " + ConverterFrame.this.errorMessage + "\n");
                            }
                            ++i;
                        }
                    } else {
                        ConverterFrame.this.errorMessage = ConverterFrame.this.om.init(choice);
                        if (ConverterFrame.this.errorMessage != null) {
                            ConverterFrame.this.MessageArea.append(String.valueOf(ConverterFrame.this.errorMessage) + "\n");
                            return;
                        }
                        ConverterFrame.this.errorMessage = ConverterFrame.this.export();
                        if (ConverterFrame.this.errorMessage != null) {
                            ConverterFrame.this.MessageArea.append(String.valueOf(ConverterFrame.this.errorMessage) + "\n");
                            return;
                        }
                    }
                    ConverterFrame.this.MessageArea.append("Done.\n");
                }
            });
        }
        return this.ExportButton;
    }

    private String checkInput() {
        if (this.InputType.getSelectedIndex() == 0) {
            return "Please set an input file type";
        }
        if (this.OutputType.getSelectedIndex() == 0) {
            return "Please set an output file type";
        }
        if (this.InputField.getText().trim().length() == 0) {
            return "Please indicate an input directory or file";
        }
        this.errorMessage = this.im.setFileName(this.InputField.getText());
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        String outputdir = this.OutputField.getText();
        if (outputdir.length() > 0) {
            this.errorMessage = this.im.setOutputDir(outputdir);
            if (this.errorMessage != null) {
                return this.errorMessage;
            }
        } else {
            this.setDefaultOutput();
        }
        return null;
    }

    private void splitSplittableInputFile() {
        String type = (String)this.InputType.getSelectedItem();
        this.im.resetSplitFiles();
        String filename = this.InputField.getText().trim();
        String message = this.im.splitSplittableFile(type, filename);
        this.splitFiles = this.im.getSplitOutputFileList();
        this.MessageArea.append(String.valueOf(message) + "\n");
    }

    private void splitSplittableInputFiles() {
        String type = (String)this.InputType.getSelectedItem();
        this.im.resetSplitFiles();
        String message = this.im.splitSplittableFiles(type);
        this.splitFiles = this.im.getSplitOutputFileList();
        if (message != null) {
            this.MessageArea.append(String.valueOf(message) + "\n");
        }
    }

    private String setInputFileList() {
        this.files = this.im.getFileNames();
        if (this.files == null) {
            return "No such input file/folder";
        }
        return this.files.length == 0 ? "No files in input folder" : null;
    }

    private String setInputFileList(Vector<String> splitFilenames) {
        this.files = new String[splitFilenames.size()];
        int i = 0;
        while (i < splitFilenames.size()) {
            this.files[i] = splitFilenames.get(i);
            ++i;
        }
        return this.files.length == 0 ? "No files in input folder" : null;
    }

    private String importFile(String origfilename) {
        this.errorMessage = this.im.convertToTags(this.proc, this.rows, this.tableLoc, origfilename);
        return this.errorMessage != null ? this.errorMessage : null;
    }

    private String export() {
        int i = 0;
        while (i < this.files.length) {
            this.errorMessage = this.importFile(this.files[i]);
            this.om.setIsTimeSeries(this.im.isTimeSeries());
            this.exportProgressBar.setValue(i);
            if (this.errorMessage == null) {
                int num = this.im.getNoOutputFiles();
                int j = 0;
                while (j < num) {
                    this.om.fillOutFile(this.im.getTagFilename(j), this.im.getTagSet(j), this.im.getData(j), this.im.isTimeSeries());
                    this.MessageArea.append(String.valueOf(this.om.export()) + "\n");
                    this.repaintThis();
                    ++j;
                }
            } else {
                this.MessageArea.append("cannot export file " + this.files[i] + ":\n " + this.errorMessage + "\n");
            }
            ++i;
        }
        return null;
    }

    private JScrollPane getMessageScrollPane() {
        if (this.MessageScrollPane == null) {
            this.MessageScrollPane = new JScrollPane();
            this.MessageScrollPane.setBounds(new Rectangle(165, 179, 751, 177));
            this.MessageScrollPane.setViewportView(this.getMessageArea());
            this.MessageScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.MessageScrollPane;
    }

    private JTextArea getMessageArea() {
        if (this.MessageArea == null) {
            this.MessageArea = new JTextArea();
            this.MessageArea.setFont(new Font("Lucida Grande", 0, 12));
        }
        return this.MessageArea;
    }

    private JPanel getDataPane1() {
        if (this.DataPane1 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.DataPane1 = new JPanel();
            this.DataPane1.setLayout(new GridBagLayout());
            this.DataPane1.setBounds(new Rectangle(165, 378, 565, 264));
            this.DataPane1.setBackground(Color.white);
            this.DataPane1.setBorder(this.border2);
            this.DataPane1.add((Component)this.getDataScrollPane(), gridBagConstraints);
        }
        return this.DataPane1;
    }

    private JScrollPane getDataScrollPane() {
        if (this.DataScrollPane == null) {
            this.DataScrollPane = new JScrollPane();
            this.DataScrollPane.setBackground(Color.white);
            this.DataScrollPane.setViewportView(this.getPlotPane());
        }
        return this.DataScrollPane;
    }

    private JPanel getPlotPane() {
        if (this.PlotPane == null) {
            this.PlotPane = new JPanel();
            this.PlotPane.setLayout(new GridBagLayout());
            this.PlotPane.setBackground(Color.white);
            if (this.pm.getGrapher() != null) {
                this.PlotPane.add(this.pm.getGrapher());
            }
        }
        return this.PlotPane;
    }

    private void setDamps(int i) {
        this.damps = this.im.getDamps(i);
        this.preferredDampIndex = 0;
        int j = 0;
        while (j < this.damps.length) {
            if (this.damps[j].startsWith("5")) {
                this.preferredDampIndex = j;
            }
            ++j;
        }
    }

    private String setFormat(float value, int decimalPlaces) {
        BigDecimal bd = new BigDecimal(value);
        return String.valueOf(bd.setScale(decimalPlaces, 4));
    }

    private void correctMinMax(int i) {
        this.decimalPoints = this.im.isTimeSeries() ? 1 : 2;
        this.plotmin = Float.parseFloat(this.setFormat(this.im.getDataMin(i), this.decimalPoints));
        this.plotmax = Float.parseFloat(this.setFormat(this.im.getSpan(i), this.decimalPoints));
    }

    private void initPlot() {
        this.loglinchoice = this.im.isTimeSeries() ? "Linear" : "Log";
        this.pm.initGrapher(this.im.isTimeSeries(), this.loglinchoice);
        this.pm.initPlot();
    }

    private void showPlot(int i) {
        this.PlotPane = null;
        boolean haveData = this.im.haveText();
        if (!this.pm.havePlot()) {
            this.correctMinMax(i);
            if (this.im.isTimeSeries()) {
                this.pm.drawPlot(haveData, this.im.getData(i), this.im.getFactor(i), this.im.getYUnits(i), this.im.getSamplesPerSec(i), this.im.getNpts(i), this.plotmin, this.plotmax);
            } else if (this.im.isDFT(i)) {
                this.pm.drawPlot(haveData, this.im.getData(i), this.im.getXUnits(i), this.im.getYUnits(i), 0, null, this.plotmin, this.plotmax);
            } else {
                String dampingValue = this.damps[this.preferredDampIndex];
                this.pm.drawPlot(haveData, this.im.getData(i), this.im.getXUnits(i), this.im.getYUnits(i), this.preferredDampIndex, dampingValue, this.plotmin, this.plotmax);
            }
        }
        this.DataScrollPane.setViewportView(this.getPlotPane());
    }

    private void repaintThis() {
        this.paintComponents(this.getGraphics());
    }
}

