/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.USGS_SMC;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.HashMap;
import org.cosmos.to_tag.DateTime;
import org.cosmos.to_tag.MatrixHandler;
import org.cosmos.to_tag.ProcessFormat;
import org.cosmos.to_tag.TableHandler;
import org.cosmos.to_tag.comment;
import org.cosmos.to_tag.data;
import org.cosmos.to_tag.fourierData;
import org.cosmos.to_tag.integerHeader;
import org.cosmos.to_tag.numberFormat;
import org.cosmos.to_tag.periods;
import org.cosmos.to_tag.realHeader;
import org.cosmos.to_tag.responseSpectraData;
import org.cosmos.to_tag.textHeader;
import org.cosmos.to_tag.timeSeriesData;

public class Process
extends ProcessFormat {
    private int currentLine;
    private textHeader thead;
    private integerHeader ihead;
    private realHeader rhead;
    private comment comm;
    private data ts;
    private periods per;
    private int numberOfPeriods;
    private String firstSampleDateTime = null;
    private String SCNL = null;
    private int nFreq = 0;
    private String units;
    private String dtype;
    private HashMap<String, String> RSunits;

    public Process(String dir) {
        super(dir);
        this.spec = new String[]{"SdData", "SvData", "PSVData", "SaData"};
        this.currentLine = 0;
        this.componentTypes = new String[]{"textHeader", "integerHeader", "realHeader", "comment"};
    }

    @Override
    public String setComponents() {
        if (this.isValid(this.lines) == 1) {
            return "The second line of the file does not start with '*', so is not a valid SMC file";
        }
        if (this.isValid(this.lines) == 2) {
            return "Skipping Fourier spectrum file until I find the corresponding Response spectra file";
        }
        this.makeTextHeader();
        this.makeIntegerHeader(this.th);
        this.makeRealHeader();
        this.makeComment();
        if (this.lines[0].toLowerCase().contains("spectra")) {
            this.makeSpectra();
        } else {
            this.makeTimeSeries();
        }
        return null;
    }

    private int isValid(String[] lines) {
        if (lines[0].trim().length() == 0 && lines[4].toLowerCase().contains("delta")) {
            return 2;
        }
        if (lines[0].trim().contains("6 fourier")) {
            return 2;
        }
        if (!lines[1].startsWith("*")) {
            return 1;
        }
        return 0;
    }

    public void makeTextHeader() {
        this.thead = (textHeader)this.templ.getComponent("textHeader", 1);
        this.thead.setnumberOfLines("11");
        int numLines = this.thead.getnumberOfLines();
        this.thead.setLines(this.extractLines(0, numLines));
        this.currentLine = numLines;
    }

    public void makeIntegerHeader(TableHandler th) {
        int numLines = 0;
        try {
            this.ihead = (integerHeader)this.templ.getComponent("integerHeader", 1);
            String formatType = "8I10";
            numberFormat format = this.templ.getFormat(formatType);
            this.ihead.addComponent(format);
            this.ihead.setNumberOfValues("48");
            numLines = this.ihead.getNumberOfLines();
            this.ihead.setLines(this.extractLines(this.currentLine, numLines));
            String[] defaultValue = new String[]{this.ihead.getStringValue(1)};
            this.ihead.setNullValue(defaultValue);
            this.ihead.setTables(th);
            this.currentLine = numLines + this.currentLine;
        }
        catch (Exception e) {
            System.err.println("trouble reading integer header: " + e.toString());
        }
    }

    public void makeRealHeader() {
        int numLines = 0;
        try {
            this.rhead = (realHeader)this.templ.getComponent("realHeader", 1);
            String formatType = "5E15.7";
            numberFormat format = this.templ.getFormat(formatType);
            this.rhead.addComponent(format);
            this.rhead.setNumberOfValues("50");
            numLines = this.rhead.getNumberOfLines();
            this.rhead.setLines(this.extractLines(this.currentLine, numLines));
            String[] defaultValue = new String[]{this.rhead.getStringValue(1)};
            this.rhead.setNullValue(defaultValue);
        }
        catch (Exception e) {
            System.err.println("trouble reading real header, on line : " + this.currentLine + " " + e.toString());
        }
        this.currentLine = numLines + this.currentLine;
    }

    public void makeComment() {
        this.comm = (comment)this.templ.getComponent("comment", 1);
        this.comm.setStartsWith("|");
        int numLines = 0;
        int index = this.currentLine;
        while (this.lines[index++].startsWith("|")) {
            ++numLines;
        }
        this.comm.setNumberOfLines(String.valueOf(numLines));
        this.comm.setLines(this.extractLines(this.currentLine, numLines));
        this.currentLine = numLines + this.currentLine;
    }

    public void makeTimeSeries() {
        String datatype = this.lines[0].toLowerCase();
        this.dtype = "";
        if (datatype.contains("accelerogram")) {
            this.dtype = datatype.contains("uncorrected") ? "UnprocessedData" : "AccData";
            this.units = "cm/s/s";
        } else if (datatype.indexOf("velocity") > -1) {
            this.dtype = "VelData";
            this.units = "cm/s";
        } else if (datatype.indexOf("displacement") > -1) {
            this.dtype = "DisData";
            this.units = "cm";
        }
        this.templ.addComponent(this.dtype);
        this.ts = (timeSeriesData)this.templ.getComponent(this.dtype, 1);
        this.ts.setUnits(this.units);
        int numPoints = this.ihead.getValue(17);
        int formatCode = this.ihead.getValue(47);
        String formatType = formatCode == 8 ? "5E14.7E1" : "8E10.4E1";
        numberFormat nf = this.templ.getFormat(formatType);
        this.ts.addComponent(nf);
        int numLines = numPoints / nf.getNumberPerLine();
        if (numPoints % numLines > 0) {
            ++numLines;
        }
        this.ts.setLines(this.extractLines(this.currentLine, numLines));
    }

    public void makeSpectra() {
        this.dtype = "specData";
        String first = this.lines[this.currentLine++];
        String[] vals = new String[]{first.substring(2, 17).trim().toLowerCase(), first.substring(20, 34).trim().toLowerCase(), first.substring(41).trim().toLowerCase()};
        this.RSunits = new HashMap();
        String[] unitStrings = new String[]{vals[0], vals[1], vals[1], vals[2]};
        int i = 0;
        while (i < unitStrings.length) {
            unitStrings[i] = unitStrings[i].replaceAll("(sec squared)", "s/s");
            unitStrings[i] = unitStrings[i].replaceAll("sec", "s");
            unitStrings[i] = unitStrings[i].replaceAll("inches", "in");
            this.RSunits.put(this.spec[i], unitStrings[i]);
            ++i;
        }
        first = this.lines[this.currentLine++];
        int nDamps = Integer.parseInt(first.substring(0, 5).trim());
        this.numberOfPeriods = Integer.parseInt(first.substring(5, 10).trim());
        String timeFlag = first.substring(10, 15).trim();
        String damps = this.lines[this.currentLine++];
        responseSpectraData rs = new responseSpectraData();
        String[] dampset = new String[nDamps];
        int start = 0;
        int k = 0;
        while (k < nDamps) {
            dampset[k] = damps.substring(start, start + 15).trim();
            start += 15;
            ++k;
        }
        rs.setDamping(dampset);
        numberFormat nf = this.templ.getFormat("7E11.4");
        int numLines = this.numberOfPeriods / nf.getNumberPerLine();
        if (this.numberOfPeriods % nf.getNumberPerLine() > 0) {
            ++numLines;
        }
        this.per = new periods();
        this.per.addComponent(nf);
        this.per.setNumberOfLines(numLines);
        this.per.setPeriods(this.extractLines(this.currentLine, numLines));
        rs.setPeriods(this.per);
        this.currentLine += numLines;
        int dampIndex = 0;
        while (dampIndex < nDamps) {
            int i2 = 0;
            while (i2 < this.spec.length) {
                this.fillSpec(this.spec[i2], dampIndex);
                ++i2;
            }
            ++dampIndex;
        }
        String filename = this.ff.getLongFileName();
        String fourierfn = String.valueOf(filename.substring(0, filename.indexOf("r.rs2"))) + "f.fs1";
        try {
            File four = new File(fourierfn);
            if (four.exists()) {
                this.readFile(fourierfn);
                this.templ.addComponent("fourierData");
                fourierData fd = (fourierData)this.templ.getComponent("fourierData", 1);
                nf = this.templ.getFormat("10X,5E12.4");
                String numFreq = this.lines[3].substring(0, this.lines[3].indexOf("=")).trim();
                this.nFreq = Integer.parseInt(numFreq);
                String delta = this.lines[5].substring(this.lines[5].indexOf("=") + 1, this.lines[5].lastIndexOf("=")).trim();
                double fourDelta = Double.parseDouble(delta);
                String ffstart = this.lines[8].substring(this.lines[8].indexOf("=") + 1, this.lines[8].indexOf(" to ")).trim();
                double fstart = Double.parseDouble(ffstart);
                double[] periods2 = new double[this.nFreq];
                String[] pers = new String[this.nFreq];
                periods2[0] = fstart;
                pers[0] = String.valueOf(fstart);
                int i3 = 1;
                while (i3 < this.nFreq) {
                    periods2[i3] = periods2[i3 - 1] + fourDelta;
                    pers[i3] = String.valueOf(periods2[i3]);
                    ++i3;
                }
                fd.addComponent(nf);
                fd.setUnits("cm/s");
                this.per = new periods();
                numberFormat nff = this.templ.getFormat("1E13.5");
                this.per.addComponent(nff);
                String[] reformattedPeriods = this.reformat(13, 5, 2, 1, pers);
                this.per.setPeriods(reformattedPeriods);
                fd.setPeriods(this.per);
                numLines = reformattedPeriods.length / nf.getNumberPerLine();
                if (reformattedPeriods.length % nf.getNumberPerLine() > 0) {
                    ++numLines;
                }
                fd.setLines(this.extractLines(12, numLines));
            }
        }
        catch (Exception e) {
            System.out.println("error processing fourier spectra: " + e.toString());
        }
    }

    private void fillSpec(String specType, int dampIndex) {
        if (dampIndex == 0) {
            this.templ.addComponent(specType);
        }
        String header = this.lines[this.currentLine];
        responseSpectraData sp = (responseSpectraData)this.templ.getComponent(specType, 1);
        String formatType = specType.contains("SaData") ? "6E13.6" : "7E11.4";
        numberFormat nf = this.templ.getFormat(formatType);
        sp.addComponent(nf);
        sp.setUnits(this.RSunits.get(specType));
        int numLines = this.numberOfPeriods / nf.getNumberPerLine();
        if (this.numberOfPeriods % nf.getNumberPerLine() > 0) {
            ++numLines;
        }
        sp.setLines(this.extractLines(this.currentLine + 1, numLines), dampIndex);
        this.currentLine = this.currentLine + numLines + 1;
    }

    public String[] reformat(int columns, int decimalPlaces, int expPlaces, int numperline, String[] data2) {
        int spacer = 0;
        DecimalFormat scientific = (DecimalFormat)NumberFormat.getNumberInstance();
        StringBuffer pattern = new StringBuffer();
        StringBuffer decimals = new StringBuffer();
        StringBuffer exps = new StringBuffer();
        StringBuffer blank = new StringBuffer();
        int i = 0;
        while (i < decimalPlaces) {
            decimals.append("0");
            ++i;
        }
        i = 0;
        while (i < expPlaces) {
            exps.append("0");
            ++i;
        }
        i = 0;
        while (i < columns) {
            blank.append(" ");
            ++i;
        }
        String dec = decimals.toString();
        pattern.append(" 0." + dec + "E" + exps + ";-0." + dec + "E" + exps);
        scientific.applyPattern(pattern.toString());
        int numValues = data2.length;
        int numspaces = decimalPlaces + expPlaces + 4;
        String[] output = new String[numValues];
        int i2 = 0;
        while (i2 < numValues) {
            StringBuffer temp = new StringBuffer(blank.toString());
            ++spacer;
            double value = Double.parseDouble(data2[i2]);
            String numb = scientific.format(value);
            int findspace = (numb = numb.replace("E0", "E+0")).indexOf("E ");
            if (findspace > -1) {
                numb = String.valueOf(numb.substring(0, findspace + 1)) + "+" + numb.substring(findspace + 2);
            }
            temp = temp.replace(columns - numspaces - 1, columns, numb);
            output[i2] = temp.toString();
            ++i2;
        }
        return output;
    }

    @Override
    public void resetElements(MatrixHandler mh, data dats) {
        block9: {
            block10: {
                int num;
                block8: {
                    mh.resetElement("DataSeries.PhysicalParameter_txt", dats.getDataName());
                    if (!(dats instanceof responseSpectraData)) break block8;
                    responseSpectraData rs = (responseSpectraData)dats;
                    String[] formats = rs.getFortranFormat();
                    mh.resetElement("DataSeries.AbscissaFormat", formats[0]);
                    this.setFormats(mh, formats);
                    String units = this.RSunits.get(dats.getClass().getSimpleName());
                    mh.resetElement("DataSeriesAbscissaUnits_txt", "s");
                    int ndamps = rs.getNumberOfDampingValues();
                    int i = 1;
                    while (i < ndamps + 1) {
                        mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", units);
                        ++i;
                    }
                    i = ndamps + 1;
                    while (i <= this.maxformats) {
                        mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", null);
                        ++i;
                    }
                    mh.setDamping(rs.getDamping());
                    i = 0;
                    while (i < ndamps) {
                        int num2 = i + 1;
                        mh.resetElement("DataSeries.Peak(" + num2 + ").Value_dbl", rs.getMax(i), units);
                        mh.resetElement("DataSeries.Peak(" + num2 + ").Locus_dbl", rs.getMaxPoint(i), "s");
                        ++i;
                    }
                    break block9;
                }
                if (!(dats instanceof fourierData)) break block10;
                fourierData fs = (fourierData)dats;
                String units = dats.getUnits();
                String[] formats = fs.getFortranFormat();
                mh.resetElement("DataSeries.AbscissaFormat", formats[0]);
                this.setFormats(mh, formats);
                mh.resetElement("DataSeries.AbscissaUnits_txt", "Hz");
                mh.resetElement("DataSeries.OrdinateUnits(1)_txt", units);
                int i = 2;
                while (i <= this.maxformats) {
                    mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", null);
                    ++i;
                }
                mh.resetElement("DataSeries.Peak(1).Value_dbl", fs.getMax(), units);
                mh.resetElement("DataSeries.Peak(1).Locus_dbl", fs.getMaxPoint(), "s");
                i = 1;
                while (i < 5) {
                    num = i + 1;
                    mh.resetElement("DataSeries.Peak(" + num + ").Value_dbl", null, units);
                    mh.resetElement("DataSeries.Peak(" + num + ").Locus_dbl", null, "Hz");
                    ++i;
                }
                i = 0;
                while (i < 5) {
                    num = i + 1;
                    mh.resetElement("DataSeries.ResponseSpectrumDamping(" + num + ")_dbl", null);
                    ++i;
                }
                break block9;
            }
            if (!(dats instanceof timeSeriesData)) break block9;
            timeSeriesData ts = (timeSeriesData)dats;
            String[] formats = ts.getFortranFormat();
            mh.resetElement("DataSeries.OrdinateFormat(1)", formats[0]);
            int i = 2;
            while (i <= this.maxformats) {
                mh.resetElement("DataSeries.OrdinateFormat(" + i + ")", null);
                ++i;
            }
            mh.resetElement("DataSeries.AbscissaFormat", null);
            mh.resetElement("DataSeries.Peak(1).Value_dbl", ts.getMax(), ts.getUnits());
            mh.setUnits("DataSeries.Peak(1).Locus_dbl", "s");
            mh.resetElement("DataSeries.AbscissaUnits_txt", null);
            mh.resetElement("DataSeries.OrdinateUnits(1)_txt", ts.getUnits());
            i = 2;
            while (i <= this.maxformats) {
                mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", null);
                ++i;
            }
        }
    }

    public String getStationCode(HashMap attributes) {
        return this.getStationCode();
    }

    public String getStationCode() {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        tmap.put("headerLine", 3);
        tmap.put("startColumn", 1);
        tmap.put("endColumn", 4);
        String temp = this.thead.getValue(tmap);
        if (!temp.startsWith("*")) {
            return temp.trim();
        }
        temp = this.ihead.getStringValue(30);
        String[] nullValues = this.ihead.getNullValue();
        int i = 0;
        while (i < nullValues.length) {
            if (temp.contains(nullValues[i])) {
                return null;
            }
            ++i;
        }
        return temp;
    }

    public String getUnits(HashMap attributes) {
        if (this.ts != null) {
            return this.ts.getUnits();
        }
        return null;
    }

    public String getDAUModel(HashMap attributes) {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        tmap.put("headerLine", 8);
        tmap.put("startColumn", 11);
        tmap.put("endColumn", 15);
        String temp = this.thead.getValue(tmap);
        if (this.th.isInTable(1, temp, 1)) {
            return temp;
        }
        if (temp.toLowerCase().startsWith("mt")) {
            return "Mt Whitney";
        }
        if (temp.trim().length() != 0) {
            return "Other: " + temp;
        }
        return null;
    }

    public String getDAUManufacturer(HashMap attributes) {
        String DAUModel = this.getDAUModel(attributes);
        if (DAUModel == null || DAUModel.startsWith("Other")) {
            return null;
        }
        int index = this.th.getIndex(1, DAUModel, 1);
        if (index != -1) {
            return this.th.getValue(1, index, 2);
        }
        return null;
    }

    public String getWordLength(HashMap attributes) {
        return "NULL";
    }

    public String getProcessingInstance(HashMap attributes) {
        String[] nullValues = this.ihead.getNullValue();
        return "NULL";
    }

    public String getMomentAgency(HashMap attributes) {
        String target = "Moment:";
        String agency = this.findAgencyInComment(target);
        return agency;
    }

    public String getMagnitudeAgency(HashMap attributes) {
        String target = "Magnitude:";
        String agency = this.findAgencyInComment(target);
        return agency;
    }

    public String getHypocenterAgency(HashMap attributes) {
        String target = "Location:";
        String agency = this.findAgencyInComment(target);
        return agency;
    }

    private String findAgencyInComment(String target) {
        int numLines = this.comm.getNumberOfLines();
        String line = "";
        String agency = "NULL";
        int i = 0;
        while (i < numLines) {
            line = this.comm.getLine(i + 1);
            if (line == null) {
                return "NULL";
            }
            int index = line.indexOf(target);
            if (index > 0) {
                agency = line.substring(index + target.length()).trim();
                return agency;
            }
            ++i;
        }
        return agency;
    }

    public String getDeployment(HashMap attributes) {
        boolean building;
        boolean bridge;
        boolean dam;
        String stest;
        String temp = this.comm.getValue(attributes);
        if (temp.contains(stest = "<loclbl=>") && temp.contains("<end>")) {
            temp = "Other: " + temp.substring(temp.indexOf(stest) + stest.length(), temp.lastIndexOf("<end>")).trim();
            return temp;
        }
        String[] nullValues = this.ihead.getNullValue();
        int i = 0;
        while (i < nullValues.length) {
            if (this.ihead.getStringValue(19).contains(nullValues[i])) {
                return null;
            }
            ++i;
        }
        boolean bl = dam = this.ihead.getValue(19) == 3;
        if (dam) {
            int test = this.ihead.getValue(28);
            switch (test) {
                case 0: {
                    return null;
                }
                case 1: {
                    return "Other: at base of dam";
                }
                case 2: {
                    return "Other: on crest of dam";
                }
                case 3: {
                    return "Other: on abutment of dam";
                }
            }
            return null;
        }
        boolean bl2 = bridge = this.ihead.getValue(19) == 2;
        if (bridge) {
            int test = this.ihead.getValue(27);
            switch (test) {
                case 0: {
                    return null;
                }
                case 1: {
                    return "Other: at base of a pier or abutment";
                }
                case 2: {
                    return "Other: on an abutment";
                }
                case 3: {
                    return "Other: on the deck at the top of a pier";
                }
                case 4: {
                    return "Other: on the deck between piers or between an abutment and a pier";
                }
            }
            return null;
        }
        boolean bl3 = building = this.ihead.getValue(19) == 1;
        if (building) {
            int test = this.ihead.getValue(25);
            if (test == 0) {
                return "Other: basement";
            }
            if (test < 0) {
                return "Other: sub-basement no." + -test;
            }
            if (test == 1) {
                return "Other: at grade level";
            }
            if (test > 1) {
                return "Other: floor level above grade: " + test;
            }
            return null;
        }
        return null;
    }

    public String getBuildingType(HashMap attributes) {
        if (this.ihead.getValue(19) == 1) {
            return "Other Building Type";
        }
        return null;
    }

    public String getBridgeType(HashMap attributes) {
        if (this.ihead.getValue(19) == 2) {
            return "Other Bridge";
        }
        return null;
    }

    public String getDamType(HashMap attributes) {
        if (this.ihead.getValue(19) == 3) {
            int test = this.ihead.getValue(29);
            switch (test) {
                case 1: {
                    return "Concrete Gravity Dam";
                }
                case 2: {
                    return "Concrete Arch Dam";
                }
                case 3: {
                    return "Engineered Fill Dam";
                }
            }
            return "Other Dam";
        }
        return null;
    }

    public String getDataPeak(HashMap attributes) {
        double datamaxPeak = this.rhead.getValue(30);
        double dataminPeak = this.rhead.getValue(32);
        return Math.abs(dataminPeak) > datamaxPeak ? this.rhead.getStringValue(30) : this.rhead.getStringValue(32);
    }

    public String getDataPeakLoc(HashMap attributes) {
        double datamaxPeak = this.rhead.getValue(30);
        double dataminPeak = this.rhead.getValue(32);
        return Math.abs(dataminPeak) > datamaxPeak ? this.rhead.getStringValue(31) : this.rhead.getStringValue(29);
    }

    public String getAntiAliasDecay(HashMap attributes) {
        String decay = this.rhead.getStringValue(21);
        String[] nullValues = this.rhead.getNullValue();
        int i = 0;
        while (i < nullValues.length) {
            if (decay.contains(nullValues[i])) {
                return null;
            }
            ++i;
        }
        return decay;
    }

    public String getLowPassCorner(HashMap attributes) {
        String[] nullValues = this.rhead.getNullValue();
        int i = 0;
        while (i < nullValues.length) {
            if (this.rhead.getStringValue(33).contains(nullValues[i])) {
                return null;
            }
            ++i;
        }
        if (this.rhead.getValue(34) < 0.0) {
            return this.rhead.getStringValue(33);
        }
        return null;
    }

    public String getLowPassRollOff(HashMap attributes) {
        if (this.rhead.getValue(34) < 0.0) {
            return String.valueOf(-this.rhead.getValue(34));
        }
        return null;
    }

    public String getHighPassRollOff(HashMap attributes) {
        if (this.rhead.getValue(36) < 0.0) {
            return String.valueOf(-this.rhead.getValue(36));
        }
        return null;
    }

    public String getHighPassCorner(HashMap attributes) {
        String[] nullValues = this.rhead.getNullValue();
        int i = 0;
        while (i < nullValues.length) {
            if (this.rhead.getStringValue(35).contains(nullValues[i])) {
                return null;
            }
            ++i;
        }
        if (this.rhead.getValue(36) < 0.0) {
            return this.rhead.getStringValue(35);
        }
        return null;
    }

    @Override
    public String getOutputFileName(String datatype) {
        String name = this.getOutputFileNameDate();
        if (this.SCNL != null) {
            name = String.valueOf(name) + "_" + this.SCNL;
        } else {
            String agency = this.getAgency();
            name = String.valueOf(name) + "_" + agency;
            String site = this.getStationCode();
            name = String.valueOf(name) + "_" + site;
            name = this.dtype.startsWith("spec") ? String.valueOf(name) + "_Vo3" : (this.dtype.startsWith("Un") ? String.valueOf(name) + "_Vo1" : String.valueOf(name) + "_Vo2");
            name = String.valueOf(name) + "_Ch" + this.ihead.getStringValue(9);
        }
        name = String.valueOf(name) + "_" + datatype + ".cosm";
        return this.fixFileName(name);
    }

    public String getVolume(HashMap attributes) {
        if (this.dtype.startsWith("spec")) {
            return "3";
        }
        if (this.dtype.startsWith("Un")) {
            return "1";
        }
        return "2";
    }

    public String getEventName(HashMap attributes) {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        tmap.put("headerLine", 4);
        tmap.put("startColumn", 27);
        tmap.put("endColumn", 80);
        String temp = this.thead.getValue(tmap).trim();
        if (temp.length() > 0) {
            return temp;
        }
        return null;
    }

    public String getAgency(HashMap attributes) {
        return this.getAgency();
    }

    public String getAgency() {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        tmap.put("headerLine", 8);
        tmap.put("startColumn", 36);
        String temp = this.thead.getValue(tmap).trim();
        if (temp.contains("/")) {
            temp = temp.substring(temp.indexOf("/") + 1);
        }
        if (temp.contains("USGS") && temp.length() == 4) {
            return "NP";
        }
        if (temp.length() > 0) {
            return temp;
        }
        return null;
    }

    public String getComments(HashMap attributes) {
        String lineDelimiter = "\r\n|\n|\r";
        String startswith = this.comm.getStartsWith();
        String allLines = this.comm.toString();
        String[] iLines = allLines.split(lineDelimiter);
        String oLines = "";
        int startIndex = startswith.length();
        int ix = 0;
        int i = 0;
        while (i < iLines.length) {
            ix = iLines[i].indexOf(startswith);
            oLines = String.valueOf(oLines) + iLines[i].substring(ix + startIndex).trim() + " ";
            ++i;
        }
        return oLines;
    }

    public String getInfluence(HashMap attributes) {
        String[] nullValues = this.ihead.getNullValue();
        int i = 0;
        while (i < nullValues.length) {
            if (this.ihead.getStringValue(19).contains(nullValues[i])) {
                return "NULL";
            }
            ++i;
        }
        if (this.ihead.getValue(19) == 2) {
            return this.ihead.getValue(27) == 0 ? "Reference" : "In or on structure";
        }
        if (this.ihead.getValue(19) == 3) {
            return this.ihead.getValue(28) == 0 ? "Reference" : "In or on structure";
        }
        if (this.ihead.getValue(19) == 1) {
            return "In/on structure";
        }
        return null;
    }

    public String getStatus(HashMap attributes) {
        String probflag = this.ihead.getStringValue(18);
        String[] nullValues = this.ihead.getNullValue();
        int i = 0;
        while (i < nullValues.length) {
            if (probflag.contains(nullValues[i])) {
                return "None";
            }
            ++i;
        }
        return "NULL";
    }

    public String getSensorAzimuth(HashMap attributes) {
        String[] nullValues = this.ihead.getNullValue();
        int i = 0;
        while (i < nullValues.length) {
            if (this.ihead.getStringValue(14).startsWith(nullValues[i])) {
                return "0";
            }
            ++i;
        }
        return this.ihead.getStringValue(14);
    }

    public String getRelativeAzimuth(HashMap attributes) {
        String azim = null;
        String[] nullValues = this.ihead.getNullValue();
        int i = 0;
        while (i < nullValues.length) {
            if (this.ihead.getStringValue(55).startsWith(nullValues[i])) {
                return null;
            }
            ++i;
        }
        int az = this.ihead.getValue(55);
        if (az < 361) {
            azim = String.valueOf(az);
        } else if (az > 399 && az < 403) {
            azim = String.valueOf(0);
        }
        return azim;
    }

    public String getSensorInclination(HashMap attributes) {
        String incl = this.ihead.getStringValue(13);
        String[] nullValues = this.ihead.getNullValue();
        int i = 0;
        while (i < nullValues.length) {
            if (this.ihead.getStringValue(13).startsWith(nullValues[i])) {
                return "90";
            }
            ++i;
        }
        return incl;
    }

    public String getOriginDateTime(HashMap attributes) {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        tmap.put("headerLine", 4);
        tmap.put("startColumn", 6);
        tmap.put("endColumn", 9);
        int year = Integer.parseInt(this.thead.getValue(tmap));
        tmap.put("startColumn", 12);
        tmap.put("endColumn", 13);
        int mon = Integer.parseInt(this.thead.getValue(tmap)) - 1;
        tmap.put("startColumn", 16);
        tmap.put("endColumn", 17);
        int day = Integer.parseInt(this.thead.getValue(tmap));
        tmap.put("startColumn", 22);
        tmap.put("endColumn", 23);
        int hour = Integer.parseInt(this.thead.getValue(tmap));
        tmap.put("startColumn", 24);
        tmap.put("endColumn", 25);
        int min = Integer.parseInt(this.thead.getValue(tmap));
        String zone = "GMT";
        tmap.put("startColumn", 1);
        tmap.put("endColumn", 3);
        String temp = this.thead.getValue(tmap).trim();
        if (temp.length() > 0) {
            zone = temp;
        }
        DateTime dt = new DateTime();
        int sec = 0;
        int milli = 0;
        return dt.getDateString(year, mon, day, hour, min, sec, milli, zone);
    }

    public String getFirstSample(HashMap attributes) {
        int year = this.ihead.getValue(2);
        int juliandate = this.ihead.getValue(3);
        if (juliandate > 366 || juliandate < 1) {
            return null;
        }
        DateTime dt = new DateTime();
        Calendar cal = dt.getCalendar(year, juliandate);
        int month = cal.get(2) + 1;
        int[] hmsm = new int[4];
        hmsm[3] = 0;
        hmsm[2] = 0;
        hmsm[1] = 0;
        hmsm[0] = 0;
        int[] intNull = this.ihead.getNullAsInt();
        int j = 0;
        while (j < 4) {
            block5: {
                boolean isNull = false;
                int i = 0;
                while (i < intNull.length) {
                    if (this.ihead.getValue(j + 4) == intNull[i]) {
                        isNull = true;
                        break block5;
                    }
                    ++i;
                }
                if (!isNull) {
                    hmsm[j] = this.ihead.getValue(j + 4);
                }
            }
            ++j;
        }
        cal.set(11, hmsm[0]);
        cal.set(12, hmsm[1]);
        cal.set(13, hmsm[2]);
        cal.set(14, hmsm[3]);
        this.firstSampleDateTime = dt.getDateString(cal);
        return this.firstSampleDateTime;
    }

    private String getOutputFileNameDate() {
        if (this.firstSampleDateTime == null) {
            return "00000000_000000";
        }
        DateTime dt = new DateTime();
        return dt.getOutputFileNameDate(this.firstSampleDateTime);
    }

    public String getSNCL(HashMap attributes) {
        String test;
        String temp = this.comm.getValue(attributes);
        if (!temp.contains(test = "SNCL:")) {
            return null;
        }
        this.SCNL = temp = temp.substring(temp.indexOf(test) + test.length(), temp.lastIndexOf(".") + 3).trim();
        return temp;
    }

    public String getProcessingDate(HashMap attributes) {
        String test;
        String temp = this.comm.getValue(attributes);
        if (!temp.contains(test = "using program evt2smc")) {
            return null;
        }
        temp = temp.substring(temp.indexOf(test) + test.length(), temp.lastIndexOf("/") + 12).trim();
        return this.parseDate(temp);
    }

    private String parseDate(String temp) {
        int origin;
        DateTime dt = new DateTime();
        int[] dateparts = null;
        String line = temp;
        int end = origin = 0;
        try {
            int start = origin;
            end = line.indexOf("/");
            int year = Integer.parseInt(line.substring(start, end).trim());
            start = end + 1;
            end = line.indexOf("/", start);
            int mon = Integer.parseInt(line.substring(start, end));
            start = end + 1;
            end = line.indexOf(" ", start);
            int day = Integer.parseInt(line.substring(start, end));
            start = end + 1;
            end = line.indexOf(":", start);
            int hour = Integer.parseInt(line.substring(start, end).trim());
            start = end + 1;
            end = line.indexOf(":", start);
            int min = Integer.parseInt(line.substring(start, end));
            start = end + 1;
            end = start + 2;
            int sec = Integer.parseInt(line.substring(start, end));
            dateparts = new int[]{year, mon, day, hour, min, sec};
            return dt.getDateString(dateparts);
        }
        catch (Exception e) {
            System.err.println("can't parse processing date in comment: " + line.substring(origin, end) + " " + e.toString());
            return null;
        }
    }
}

