/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.NIED_Japan;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import org.cosmos.to_tag.DateTime;
import org.cosmos.to_tag.MatrixHandler;
import org.cosmos.to_tag.ProcessFormat;
import org.cosmos.to_tag.data;
import org.cosmos.to_tag.numberFormat;
import org.cosmos.to_tag.textHeader;
import org.cosmos.to_tag.timeSeriesData;

public class Process
extends ProcessFormat {
    private int currentLine = 0;
    private textHeader thead;
    private data ts;
    private String thisDataType;
    private int volume;
    private String channel;
    private String firstSample;
    private String orient;
    private HashMap<String, String> channels;
    private String[] ext = new String[]{"ns", "ew", "ud", "ns1", "ew1", "ud1", "ns2", "ew2", "ud2"};
    private String[] chan = new String[]{"1", "2", "3", "1", "2", "3", "4", "5", "6"};

    public Process(String dir) {
        super(dir);
        this.componentTypes = new String[]{"textHeader", "integerHeader", "realHeader"};
        this.channels = new HashMap();
        int i = 0;
        while (i < this.ext.length) {
            this.channels.put(this.ext[i], this.chan[i]);
            ++i;
        }
    }

    public void initialize() {
        this.thead = null;
        this.ts = null;
    }

    @Override
    public String setComponents() {
        this.initialize();
        if (!this.isValid(this.lines[0])) {
            return "file is not a recognizable K-Net or Kik-Net format file";
        }
        try {
            this.makeTextHeader();
        }
        catch (Exception e) {
            return "error reading file header, " + e.toString();
        }
        this.makeTimeSeries();
        return null;
    }

    private boolean isValid(String firstLine) {
        int position = firstLine.toLowerCase().indexOf("origin time", 0);
        if (position > -1) {
            this.volume = 1;
            return true;
        }
        return false;
    }

    public void makeTextHeader() {
        this.thead = (textHeader)this.templ.getComponent("textHeader", 1);
        String noLines = "17";
        this.thead.setnumberOfLines(noLines);
        int numLines = this.thead.getnumberOfLines();
        this.thead.setLines(this.extractLines(0, numLines));
        this.currentLine = numLines;
    }

    public void makeTimeSeries() {
        String datatype = this.lines[0].toLowerCase().substring(0, 25).trim();
        String dtype = "";
        this.thisDataType = dtype = "UncData";
        this.templ.addComponent(dtype);
        this.ts = (timeSeriesData)this.templ.getComponent(dtype, 1);
        int numPoints = this.getNumberOfPoints();
        numberFormat nf = this.templ.getFormat("8I9");
        this.ts.addComponent(nf);
        int numLines = numPoints / nf.getNumberPerLine();
        if (numPoints % numLines > 0) {
            ++numLines;
        }
        this.ts.setLines(this.extractLines(this.currentLine, numLines));
        this.ts.setUnits("counts");
    }

    private double calculateMean() {
        double mean = 0.0;
        String smean = "";
        String[] timeSeriesStrings = this.ts.getTimeSeriesAsStrings();
        if (timeSeriesStrings == null) {
            return 0.0;
        }
        int numPoints = timeSeriesStrings.length;
        try {
            int i = 0;
            while (i < numPoints) {
                mean += Double.parseDouble(timeSeriesStrings[i]);
                ++i;
            }
            mean /= (double)numPoints;
        }
        catch (Exception e) {
            mean = 0.0;
        }
        BigDecimal bd = new BigDecimal(mean);
        smean = String.valueOf(bd.setScale(1, 4));
        return Double.parseDouble(smean);
    }

    public String getMean() {
        double mean = this.calculateMean();
        return String.valueOf(mean);
    }

    @Override
    public void resetElements(MatrixHandler mh, data dats) {
        String inputfilename = this.ff.getFileName().toLowerCase();
        try {
            this.channel = this.channels.get(inputfilename.substring(inputfilename.lastIndexOf(".") + 1));
        }
        catch (Exception e) {
            this.channel = "00";
        }
        mh.resetElement("DataSeries.PhysicalParameter_txt", dats.getDataName());
        if (dats instanceof timeSeriesData) {
            timeSeriesData ts = (timeSeriesData)dats;
            String units = ts.getUnits();
            mh.resetElement("DataSeries.OrdinateUnits(1)", units);
            String[] formats = ts.getFortranFormat();
            mh.resetElement("DataSeries.OrdinateFormat(1)", formats[0]);
            mh.resetElement("Sensor.DAUchannel", this.channel);
            String newMean = this.getMean();
            double amean = Double.parseDouble(newMean);
            ts.calculateMaxima(amean);
            int pointsToMax = ts.getMaxLocation() + 1;
            double SecsToMax = (double)pointsToMax / Double.parseDouble(this.getSampleRate());
            mh.resetElement("DataSeries.Mean_dbl", newMean, "counts");
            mh.resetElement("DataSeries.Peak(1).Locus_dbl", String.valueOf(SecsToMax), "s");
            mh.resetElement("DataSeries.NumberOfSamples", String.valueOf(ts.getNumberOfPoints()));
            if (inputfilename.endsWith("1") || inputfilename.endsWith("2")) {
                mh.resetElement("Point.NonStructuralDeploymentDescription", "Geotechnical Array");
            }
        }
    }

    private String getDefaultUnits() {
        if (this.thisDataType.startsWith("Acc")) {
            return "counts";
        }
        return null;
    }

    public String getDataPeak(HashMap attributes) {
        return null;
    }

    public String getDataPeakLocation(HashMap attributes) {
        return null;
    }

    public String getCountsConversion(HashMap attributes) {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        int headerLine = 14;
        tmap.put("headerLine", headerLine);
        tmap.put("afterString", "Factor");
        try {
            String val = this.thead.getValue(tmap).trim().toLowerCase();
            String[] factor = val.split("/");
            factor[0] = factor[0].substring(0, factor[0].indexOf("("));
            double fact = Double.valueOf(factor[0]) / Double.valueOf(factor[1]);
            return String.valueOf(fact);
        }
        catch (Exception e) {
            return null;
        }
    }

    private int getNumberOfPoints() {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        try {
            int sampleRate = Integer.parseInt(this.getSampleRate());
            int headerLine = 12;
            tmap.put("headerLine", headerLine);
            tmap.put("afterString", "(s)");
            String temp = this.thead.getValue(tmap).trim();
            int duration = Integer.parseInt(temp);
            return duration * sampleRate;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getSampleRate(HashMap attributes) {
        return this.getSampleRate();
    }

    public String getSampleRate() {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        int headerLine = 11;
        tmap.put("headerLine", headerLine);
        tmap.put("afterString", "(Hz)");
        String temp = this.thead.getValue(tmap).trim();
        if (temp == null) {
            return null;
        }
        return temp.substring(0, temp.indexOf("Hz"));
    }

    public String getProcessingDate(HashMap attributes) {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        int headerLine = 16;
        tmap.put("headerLine", headerLine);
        tmap.put("afterString", "Correction");
        String temp = this.thead.getValue(tmap).trim();
        int[] vals = this.parseDate(temp);
        return this.convertDate(vals, 0);
    }

    public String getOriginDateTime(HashMap attributes) {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        int headerLine = 1;
        tmap.put("headerLine", headerLine);
        tmap.put("afterString", "Time");
        String temp = this.thead.getValue(tmap).trim();
        int[] vals = this.parseDate(temp);
        return this.convertDate(vals, 0);
    }

    public String getFirstSample(HashMap attributes) {
        String temp;
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        int headerLine = 10;
        tmap.put("headerLine", headerLine);
        tmap.put("afterString", "Time");
        this.firstSample = temp = this.thead.getValue(tmap).trim();
        int[] vals = this.parseDate(temp);
        return this.convertDate(vals, -15);
    }

    private int[] parseDate(String temp) {
        int[] vals = new int[]{Integer.parseInt(temp.substring(0, 4)), Integer.parseInt(temp.substring(5, 7)) - 1, Integer.parseInt(temp.substring(8, 10)), Integer.parseInt(temp.substring(11, 13)), Integer.parseInt(temp.substring(14, 16)), Integer.parseInt(temp.substring(17, 19))};
        return vals;
    }

    private String convertDate(int[] vals, int adjustSec) {
        DateTime dt = new DateTime();
        Calendar cal = dt.getCalendar(vals, "JST");
        cal.add(13, adjustSec);
        long time = cal.getTimeInMillis();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dt.getDateString(cal);
    }

    private String getOutputFileNameDate() {
        String year = this.firstSample.substring(0, 4);
        String month = this.firstSample.substring(5, 7);
        String day = this.firstSample.substring(8, 10);
        String hour = this.firstSample.substring(11, 13);
        String min = this.firstSample.substring(14, 16);
        String sec = this.firstSample.substring(17, 19);
        String eday = String.valueOf(year) + month + day;
        return String.valueOf(eday) + "_" + hour + min + sec;
    }

    @Override
    public String getOutputFileName(String datatype) {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        tmap.put("headerLine", 6);
        tmap.put("afterString", "Code");
        String site = this.thead.getValue(tmap).trim();
        String name = this.getOutputFileNameDate();
        String agency = "BO";
        name = String.valueOf(name) + "_" + agency;
        name = String.valueOf(name) + "_" + site;
        name = String.valueOf(name) + "_Vo" + 1;
        name = String.valueOf(name) + "_Ch" + this.channel;
        name = String.valueOf(name) + "_" + datatype + ".cosm";
        return this.fixFileName(name);
    }

    public String getBlueBook(HashMap attributes) {
        return String.valueOf(this.volume);
    }

    public String getAgencyIdentifier(HashMap attributes) {
        return this.ff.getFileName();
    }

    public String getSensorInclination(HashMap attributes) {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        tmap.put("headerLine", 13);
        tmap.put("afterString", "Dir.");
        this.orient = this.thead.getValue(tmap).trim().toLowerCase();
        if (this.orient.contains("u-d")) {
            return "0";
        }
        if (this.orient.contains("n-s") || this.orient.contains("e-w")) {
            return "90";
        }
        try {
            int val = Integer.parseInt(this.orient);
            switch (val) {
                case 1: {
                    return "90";
                }
                case 2: {
                    return "90";
                }
                case 3: {
                    return "0";
                }
                case 4: {
                    return "90";
                }
                case 5: {
                    return "90";
                }
                case 6: {
                    return "0";
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSensorAzimuth(HashMap attributes) {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        tmap.put("headerLine", 13);
        tmap.put("afterString", "Dir.");
        String az = this.thead.getValue(tmap).trim().toLowerCase();
        if (az.contains("n-s")) {
            return "0";
        }
        if (az.contains("e-w")) {
            return "90";
        }
        if (az.contains("u-d")) {
            return "0";
        }
        try {
            int val = Integer.parseInt(az);
            switch (val) {
                case 1: {
                    return "0";
                }
                case 2: {
                    return "90";
                }
                case 3: {
                    return "0";
                }
                case 4: {
                    return "0";
                }
                case 5: {
                    return "90";
                }
                case 6: {
                    return "0";
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSeriesComment(HashMap attributes) {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        tmap.put("headerLine", 14);
        tmap.put("afterString", "Factor");
        String factor = this.thead.getValue(tmap).trim().toLowerCase();
        return "Scale Factor: " + factor;
    }
}

