/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.GNS_NZ;

import java.util.HashMap;
import org.cosmos.to_tag.DateTime;
import org.cosmos.to_tag.MatrixHandler;
import org.cosmos.to_tag.ProcessFormat;
import org.cosmos.to_tag.TableHandler;
import org.cosmos.to_tag.data;
import org.cosmos.to_tag.fourierData;
import org.cosmos.to_tag.integerHeader;
import org.cosmos.to_tag.numberFormat;
import org.cosmos.to_tag.periods;
import org.cosmos.to_tag.realHeader;
import org.cosmos.to_tag.responseSpectraData;
import org.cosmos.to_tag.textHeader;
import org.cosmos.to_tag.timeSeriesData;

public class Process
extends ProcessFormat {
    private int currentLine = 0;
    private textHeader thead;
    private integerHeader ihead;
    private realHeader rhead;
    private data ts;
    private boolean haveEventDate;
    private periods per;
    private int numberOfPeriods;
    private HashMap<String, String> specUnits;
    private String thisDataType;
    private int volume;
    private String channel;

    public Process(String dir) {
        super(dir);
        this.spec = new String[]{"SaData", "SvData", "SdData"};
        this.specUnits = new HashMap();
        this.specUnits.put("SdData", "mm");
        this.specUnits.put("SvData", "mm/s");
        this.specUnits.put("SaData", "mm/s/s");
        this.componentTypes = new String[]{"textHeader", "integerHeader", "realHeader"};
    }

    public void initialize() {
        this.thead = null;
        this.ihead = null;
        this.rhead = null;
        this.ts = null;
    }

    @Override
    public String setComponents() {
        this.initialize();
        if (!this.isValid(this.lines[0])) {
            return "file is not a recognizable GNS format file";
        }
        try {
            this.makeTextHeader();
            String[] defaultIntValue = new String[]{"0"};
            String[] defaultRealValue = new String[]{"0.000"};
            this.makeIntegerHeader(defaultIntValue, this.th);
            this.makeRealHeader(defaultRealValue);
        }
        catch (Exception e) {
            return "error reading file header, " + e.toString();
        }
        if (this.volume == 3) {
            this.makeSpectra();
        } else {
            this.makeTimeSeries();
        }
        return null;
    }

    private boolean isValid(String firstLine) {
        int position = firstLine.indexOf("GNS", 0);
        if (position < 0) {
            position = firstLine.toLowerCase().indexOf("nuclear", 0);
        }
        if (position > 10 && firstLine.startsWith("Uncorrected")) {
            this.volume = 1;
            return true;
        }
        if (position > 10 && firstLine.startsWith("Corrected")) {
            this.volume = 2;
            return true;
        }
        if (position > 10 && firstLine.startsWith("Response Spectra")) {
            this.volume = 3;
            return true;
        }
        return false;
    }

    public void makeTextHeader() {
        this.thead = (textHeader)this.templ.getComponent("textHeader", 1);
        String noLines = "16";
        this.thead.setnumberOfLines(noLines);
        int numLines = this.thead.getnumberOfLines();
        this.thead.setLines(this.extractLines(0, numLines));
        this.currentLine = numLines;
    }

    public void makeIntegerHeader(String[] defaultValue, TableHandler th) {
        try {
            this.ihead = (integerHeader)this.templ.getComponent("integerHeader", 1);
            numberFormat format = null;
            format = this.templ.getFormat("10I8");
            this.ihead.addComponent(format);
            String numVals = this.volume == 3 ? "44" : "40";
            this.ihead.setNumberOfValues(numVals);
            int numLines = this.ihead.getNumberOfLines();
            this.ihead.setLines(this.extractLines(this.currentLine, numLines));
            this.ihead.setNullValue(defaultValue);
            this.ihead.setTables(th);
            this.currentLine = numLines + this.currentLine;
        }
        catch (Exception e) {
            System.err.println("trouble reading integer header: " + e.toString());
            return;
        }
    }

    public void makeRealHeader(String[] defaultValue) {
        try {
            this.rhead = (realHeader)this.templ.getComponent("realHeader", 1);
            numberFormat format = this.templ.getFormat("10F8.0");
            this.rhead.addComponent(format);
            this.rhead.setNumberOfValues("60");
            int numLines = this.rhead.getNumberOfLines();
            this.rhead.setLines(this.extractLines(this.currentLine, numLines));
            this.rhead.setNullValue(defaultValue);
            this.currentLine = numLines + this.currentLine;
        }
        catch (Exception e) {
            System.err.println("trouble reading real header, on line : " + this.currentLine + " " + e.toString());
            return;
        }
    }

    public void makeTimeSeries() {
        String datatype = this.lines[0].toLowerCase().substring(0, 25).trim();
        String dtype = "";
        if (datatype.indexOf("acceleration") > -1) {
            dtype = "AccData";
        } else if (datatype.indexOf("uncorrected") > -1) {
            dtype = "UncData";
        } else if (datatype.indexOf("velocity") > -1) {
            dtype = "VelData";
        } else if (datatype.indexOf("displacement") > -1) {
            dtype = "DisData";
        }
        this.thisDataType = dtype;
        this.templ.addComponent(dtype);
        this.ts = (timeSeriesData)this.templ.getComponent(dtype, 1);
        String npts = null;
        if (dtype.indexOf("AccData") > -1 || dtype.indexOf("UncData") > -1) {
            this.ts.setUnits("mm/s/s");
            npts = this.ihead.getStringValue(34);
        }
        if (dtype.indexOf("VelData") > -1) {
            this.ts.setUnits("mm/s");
            npts = this.ihead.getStringValue(35);
        }
        if (dtype.indexOf("DisData") > -1) {
            this.ts.setUnits("mm");
            npts = this.ihead.getStringValue(36);
        }
        int numPoints = Integer.parseInt(npts);
        numberFormat nf = this.templ.getFormat("10F8.1");
        this.ts.addComponent(nf);
        int numLines = numPoints / nf.getNumberPerLine();
        if (numPoints % numLines > 0) {
            ++numLines;
        }
        this.ts.setLines(this.extractLines(this.currentLine, numLines));
    }

    public void makeSpectra() {
        this.thisDataType = "spec";
        String dampline = this.lines[this.currentLine++];
        int nDamps = this.ihead.getValue(41);
        responseSpectraData rs = new responseSpectraData();
        String[] dampset = new String[nDamps];
        int start = 0;
        int k = 0;
        while (k < nDamps) {
            dampset[k] = dampline.substring(start, start + 8).trim();
            start += 8;
            ++k;
        }
        rs.setDamping(dampset);
        int numPerLine = 10;
        int width = 8;
        numberFormat nf = this.templ.getFormat("1F8.0");
        this.numberOfPeriods = this.ihead.getValue(42);
        int numLines = this.numberOfPeriods / numPerLine;
        if (this.numberOfPeriods % numPerLine > 0) {
            ++numLines;
        }
        this.per = new periods();
        this.per.addComponent(nf);
        this.per.setNumberOfLines(numLines);
        String[] templines = this.extractLines(this.currentLine, numLines);
        String[] actualValues = this.getActualValues(this.numberOfPeriods, width, numPerLine, templines);
        this.per.setPeriods(actualValues);
        rs.setPeriods(this.per);
        this.currentLine += numLines;
        int i = 0;
        while (i < this.spec.length) {
            ++this.currentLine;
            int dampIndex = 0;
            while (dampIndex < nDamps) {
                this.fillSpec(this.spec[i], dampIndex);
                ++dampIndex;
            }
            ++i;
        }
        this.templ.addComponent("fourierData");
        fourierData fd = (fourierData)this.templ.getComponent("fourierData", 1);
        nf = this.templ.getFormat("1E10.3");
        fd.addComponent(nf);
        fd.setUnits("mm/s");
        fd.setPeriods(this.per);
        numPerLine = 8;
        width = 10;
        numLines = this.numberOfPeriods / numPerLine;
        if (this.numberOfPeriods % numPerLine > 0) {
            ++numLines;
        }
        templines = this.extractLines(++this.currentLine, numLines);
        actualValues = this.getActualValues(this.numberOfPeriods, width, numPerLine, templines);
        fd.setLines(actualValues);
    }

    private String[] getActualValues(int numValues, int width, int perLine, String[] lines) {
        int start = 0;
        int j = 0;
        int k = 0;
        String temp = null;
        int lastStart = (perLine - 1) * width;
        String[] actualValues = new String[numValues];
        while (j < numValues) {
            int end = start + width;
            if (end > lines[k].length()) {
                end = lines[k].length();
            }
            temp = lines[k].substring(start, end);
            actualValues[j++] = temp;
            if ((start += width) <= lastStart) continue;
            start = 0;
            ++k;
        }
        return actualValues;
    }

    private void fillSpec(String specType, int dampIndex) {
        if (dampIndex == 0) {
            this.templ.addComponent(specType);
        }
        responseSpectraData sp = (responseSpectraData)this.templ.getComponent(specType, 1);
        numberFormat nf = this.templ.getFormat("1E10.3");
        sp.addComponent(nf);
        sp.setUnits(this.specUnits.get(specType));
        int numPerLine = 8;
        int width = 10;
        int numLines = this.numberOfPeriods / numPerLine;
        if (this.numberOfPeriods % numPerLine > 0) {
            ++numLines;
        }
        String[] templines = this.extractLines(this.currentLine, numLines);
        sp.setLines(this.getActualValues(this.numberOfPeriods, width, numPerLine, templines), dampIndex);
        this.currentLine += numLines;
    }

    @Override
    public void resetElements(MatrixHandler mh, data dats) {
        String inputfilename = this.ff.getFileName();
        String[] formats = null;
        this.channel = inputfilename.substring(0, inputfilename.indexOf("_gns"));
        int length = this.channel.length();
        this.channel = this.channel.substring(length - 2);
        if (this.channel.startsWith("0")) {
            this.channel = this.channel.substring(1);
        }
        mh.resetElement("DataSeries.PhysicalParameter_txt", dats.getDataName());
        if (dats instanceof responseSpectraData) {
            responseSpectraData rs = (responseSpectraData)dats;
            int ndamps = rs.getNumberOfDampingValues();
            formats = rs.getFortranFormat();
            mh.resetElement("DataSeries.AbscissaFormat", formats[0]);
            this.setFormats(mh, formats);
            mh.resetElement("DataSeries.AbscissaUnits_txt", "s");
            String units = this.specUnits.get(dats.getClass().getSimpleName());
            int i = 1;
            while (i < ndamps + 1) {
                mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", units);
                ++i;
            }
            i = ndamps + 1;
            while (i < this.maxformats) {
                mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", null);
                ++i;
            }
            mh.setDamping(rs.getDamping());
            i = 0;
            while (i < ndamps) {
                int num = i + 1;
                mh.resetElement("DataSeries.Peak(" + num + ").Value_dbl", rs.getMax(i).trim(), units);
                mh.resetElement("DataSeries.Peak(" + num + ").Locus_dbl", rs.getMaxPoint(i), "s");
                ++i;
            }
        } else if (dats instanceof fourierData) {
            int num;
            fourierData fs = (fourierData)dats;
            formats = fs.getFortranFormat();
            mh.resetElement("DataSeries.AbscissaFormat", formats[0]);
            this.setFormats(mh, formats);
            String units = dats.getUnits();
            mh.resetElement("DataSeries.AbscissaUnits_txt", "s");
            mh.resetElement("DataSeries.OrdinateUnits(1)_txt", units);
            int i = 2;
            while (i <= this.maxformats) {
                mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", null);
                ++i;
            }
            mh.resetElement("DataSeries.Peak(1).Value_dbl", fs.getMax().trim(), units);
            mh.resetElement("DataSeries.Peak(1).Locus_dbl", fs.getMaxPoint(), "s");
            i = 1;
            while (i < 5) {
                num = i + 1;
                mh.resetElement("DataSeries.Peak(" + num + ").Value_dbl", null, units);
                mh.resetElement("DataSeries.Peak(" + num + ").Locus_dbl", null, "s");
                ++i;
            }
            i = 0;
            while (i < 5) {
                num = i + 1;
                mh.resetElement("DataSeries.ResponseSpectrumDamping(" + num + ")_dbl", null);
                ++i;
            }
        } else if (dats instanceof timeSeriesData) {
            timeSeriesData ts = (timeSeriesData)dats;
            String units = ts.getUnits();
            mh.resetElement("DataSeries.AbscissaUnits_txt", null);
            mh.resetElement("DataSeries.OrdinateUnits(1)_txt", units);
            int i = 2;
            while (i < this.maxformats) {
                mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", null);
                ++i;
            }
            formats = ts.getFortranFormat();
            mh.resetElement("DataSeries.OrdinateFormat(1)", formats[0]);
            i = 2;
            while (i <= this.maxformats) {
                mh.resetElement("DataSeries.OrdinateFormat(" + i + ")", null);
                ++i;
            }
            mh.resetElement("DataSeries.AbscissaFormat", null);
            mh.resetElement("Sensor.DAUchannel", this.channel);
            mh.resetElement("DataSeries.Peak(1).Value_dbl", ts.getMax().trim(), units);
            mh.setUnits("DataSeries.Peak(1).Locus_dbl", "s");
        }
    }

    private String getDefaultUnits() {
        if (this.thisDataType.startsWith("Acc")) {
            return "mm/s/s";
        }
        if (this.thisDataType.startsWith("Vel")) {
            return "mm/s";
        }
        if (this.thisDataType.startsWith("Dis")) {
            return "mm";
        }
        return null;
    }

    public String getDataPeak(HashMap attributes) {
        if (this.thisDataType.startsWith("Unc")) {
            return String.valueOf(this.rhead.getStringValue(31).trim()) + " mm/s/s";
        }
        if (this.thisDataType.startsWith("Acc")) {
            return String.valueOf(this.rhead.getStringValue(36).trim()) + " mm/s/s";
        }
        if (this.thisDataType.startsWith("Vel")) {
            return String.valueOf(this.rhead.getStringValue(41).trim()) + " mm/s";
        }
        if (this.thisDataType.startsWith("Dis")) {
            return String.valueOf(this.rhead.getStringValue(46).trim()) + " mm";
        }
        return null;
    }

    public String getDataPeakLocation(HashMap attributes) {
        if (this.thisDataType.startsWith("Unc")) {
            return this.rhead.getStringValue(32);
        }
        if (this.thisDataType.startsWith("Acc")) {
            return this.rhead.getStringValue(37);
        }
        if (this.thisDataType.startsWith("Vel")) {
            return this.rhead.getStringValue(42);
        }
        if (this.thisDataType.startsWith("Dis")) {
            return this.rhead.getStringValue(47);
        }
        return null;
    }

    public String getNumberOfPoints(HashMap attributes) {
        if (this.thisDataType.startsWith("Unc")) {
            return this.ihead.getStringValue(34);
        }
        if (this.thisDataType.startsWith("Acc")) {
            return this.ihead.getStringValue(34);
        }
        if (this.thisDataType.startsWith("Vel")) {
            return this.ihead.getStringValue(35);
        }
        if (this.thisDataType.startsWith("Dis")) {
            return this.ihead.getStringValue(36);
        }
        return null;
    }

    public String getProcessingDate(HashMap attributes) {
        String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            int headerLine = 6;
            tmap.put("headerLine", headerLine);
            tmap.put("afterString", "Processed");
            String temp = this.thead.getValue(tmap).trim();
            DateTime dt = new DateTime();
            String[] vals = temp.split(" ");
            year = new Integer(vals[0]);
            String textMon = vals[1].toLowerCase();
            int i = 0;
            while (i < months.length) {
                if (textMon.startsWith(months[i])) {
                    month = i;
                }
                ++i;
            }
            day = new Integer(vals[2]);
            return dt.getDateString(year, month, day, "UTC");
        }
        catch (Exception ee) {
            return null;
        }
    }

    public String getOriginDateTime(HashMap attributes) {
        int year = this.ihead.getValue(1);
        int month = this.ihead.getValue(2) - 1;
        int day = this.ihead.getValue(3);
        int hour = this.ihead.getValue(4);
        int min = this.ihead.getValue(5);
        int sec = this.ihead.getValue(6) / 10;
        int milli = this.ihead.getValue(6) % 10 * 100;
        this.haveEventDate = true;
        try {
            DateTime dt = new DateTime();
            String dateTime = dt.getDateString(year, month, day, hour, min, sec, milli, "UTC");
            return dateTime;
        }
        catch (Exception ee) {
            return null;
        }
    }

    private String getOutputFileNameDate() {
        String ssec;
        String min;
        String day;
        if (!this.haveEventDate) {
            return "00000000_000000";
        }
        String month = this.ihead.getStringValue(2);
        if (month.length() < 2) {
            month = "0" + month;
        }
        if ((day = this.ihead.getStringValue(3)).length() < 2) {
            day = "0" + day;
        }
        String eday = String.valueOf(this.ihead.getStringValue(1)) + month + day;
        int sec = this.ihead.getValue(6) / 10;
        String hour = this.ihead.getStringValue(4);
        if (hour.length() < 2) {
            hour = "0" + hour;
        }
        if ((min = this.ihead.getStringValue(5)).length() < 2) {
            min = "0" + min;
        }
        if ((ssec = String.valueOf(sec)).length() < 2) {
            ssec = "0" + ssec;
        }
        return String.valueOf(eday) + "_" + hour + min + ssec;
    }

    @Override
    public String getOutputFileName(String datatype) {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        tmap.put("headerLine", 2);
        tmap.put("startColumn", 6);
        tmap.put("endColumn", 9);
        String site = this.thead.getValue(tmap).trim();
        String name = this.getOutputFileNameDate();
        String agency = "NZ";
        name = String.valueOf(name) + "_" + agency;
        name = String.valueOf(name) + "_" + site;
        name = String.valueOf(name) + "_Vo" + this.volume;
        name = String.valueOf(name) + "_Ch" + this.channel;
        name = String.valueOf(name) + "_" + datatype + ".cosm";
        return this.fixFileName(name);
    }

    public String getBlueBook(HashMap attributes) {
        return String.valueOf(this.volume);
    }

    public String getSensorInclination(HashMap attributes) {
        int inc = this.ihead.getValue(28);
        if (inc == 500) {
            return "0";
        }
        return "90";
    }

    public String getSensorAzimuth(HashMap attributes) {
        int az = this.ihead.getValue(28);
        if (az == 500) {
            return "0";
        }
        if (az == 999) {
            return "0";
        }
        if (az > 360) {
            return String.valueOf(az - 360);
        }
        return String.valueOf(az);
    }

    public String getEventLat(HashMap attributes) {
        String lat = this.rhead.getStringValue(13);
        return "-" + lat;
    }

    public String getPointLat(HashMap attributes) {
        String lat = this.rhead.getStringValue(11);
        return "-" + lat;
    }

    public String getFileIdentifier(HashMap attributes) {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        tmap.put("headerLine", 2);
        tmap.put("afterString", "file");
        String temp = this.thead.getValue(tmap);
        if (temp == null) {
            return null;
        }
        if ((temp = temp.trim()).length() < 1) {
            return null;
        }
        if ((temp = temp.substring(1)).startsWith(".")) {
            temp = temp.substring(temp.lastIndexOf(".") + 1);
        }
        return temp.trim();
    }

    public String getDAU(HashMap attributes) {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        tmap.put("headerLine", 4);
        tmap.put("startColumn", 12);
        tmap.put("endColumn", 15);
        String temp = this.thead.getValue(tmap).trim().toLowerCase();
        if (temp.startsWith("etna")) {
            return "Etna";
        }
        if (temp.startsWith("qdr")) {
            return "QDR";
        }
        if (temp.startsWith("ids")) {
            return "IDS-3602";
        }
        if (temp.startsWith("dca")) {
            return "DCA-333";
        }
        if (temp.startsWith("gsr")) {
            return "GSR-12";
        }
        if (temp.startsWith("mo2a")) {
            return "MO2A";
        }
        if (temp.startsWith("mo2")) {
            return "MO-2";
        }
        return null;
    }

    public String getDAUManufacturer(HashMap attributes) {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        tmap.put("headerLine", 4);
        tmap.put("startColumn", 12);
        tmap.put("endColumn", 15);
        String temp = this.thead.getValue(tmap).trim().toLowerCase();
        if (temp.startsWith("etna")) {
            return "Kinemetrics";
        }
        if (temp.startsWith("qdr")) {
            return "Kinemetrics";
        }
        if (temp.startsWith("ids")) {
            return "Terratech (IDS)";
        }
        if (temp.startsWith("dca")) {
            return "Terratech";
        }
        if (temp.startsWith("gsr")) {
            return "GeoSIG";
        }
        if (temp.startsWith("mo2")) {
            return "(New Zealand)";
        }
        return null;
    }

    public String getDAUSN(HashMap attributes) {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        tmap.put("headerLine", 4);
        tmap.put("startColumn", 15);
        tmap.put("endColumn", 20);
        String temp = this.thead.getValue(tmap).trim();
        if (temp.contains("_")) {
            return temp.substring(temp.indexOf("_") + 1);
        }
        if (temp.contains("/")) {
            return temp.substring(temp.indexOf("_") + 1);
        }
        return temp;
    }

    public String getWordLength(HashMap attributes) {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        tmap.put("headerLine", 5);
        tmap.put("afterString", "Resolution");
        tmap.put("untilString", "bit");
        String temp = this.thead.getValue(tmap).trim().toLowerCase();
        if (temp == null) {
            return null;
        }
        if (temp.length() < 1) {
            return null;
        }
        if (temp.startsWith(":")) {
            temp = temp.substring(2);
        }
        if (temp.endsWith("-")) {
            temp = temp.substring(0, temp.indexOf("-"));
        }
        return temp;
    }

    public String getArrayAzimuth(HashMap attributes) {
        int[] intNulls = this.ihead.getNullAsInt();
        int i = 0;
        while (i < intNulls.length) {
            if (this.ihead.getValue(27) == intNulls[i]) {
                return null;
            }
            ++i;
        }
        return this.ihead.getStringValue(27);
    }

    public String getEventComment(HashMap attributes) {
        if (this.ihead.getValue(18) != 0) {
            return "Centroid Depth: " + this.ihead.getValue(18) + " km";
        }
        return null;
    }

    public String getProcessingComment(HashMap attributes) {
        if (this.ihead.getNumberOfValues() > 40 && this.ihead.getValue(43) == 0) {
            return "Algorithm: Duhamel Integral";
        }
        return null;
    }

    public String getRMS(HashMap attributes) {
        if (this.thisDataType.startsWith("Unc") && this.rhead.getValue(33) != 0.0) {
            return this.rhead.getStringValue(33);
        }
        if (this.thisDataType.startsWith("Acc") && this.rhead.getValue(38) != 0.0) {
            return this.rhead.getStringValue(38);
        }
        if (this.thisDataType.startsWith("Vel") && this.rhead.getValue(43) != 0.0) {
            return this.rhead.getStringValue(43);
        }
        if (this.thisDataType.startsWith("Dis") && this.rhead.getValue(48) != 0.0) {
            return this.rhead.getStringValue(48);
        }
        return null;
    }

    public String getDataComments(HashMap attributes) {
        if (this.thisDataType.startsWith("Unc")) {
            return null;
        }
        String start = "Peak horizontal ";
        String start2 = ", Dominant ";
        if (this.thisDataType.startsWith("Acc") && this.rhead.getValue(39) != 0.0) {
            return String.valueOf(start) + "acceleration: " + this.rhead.getStringValue(39) + " mm/s/s" + start2 + "filtered acceleration frequency: " + this.rhead.getValue(40) + "Hz";
        }
        if (this.thisDataType.startsWith("Vel") && this.rhead.getValue(44) != 0.0) {
            return String.valueOf(start) + "velocity: " + this.rhead.getStringValue(44) + " mm/s" + start2 + "velocity frequency: " + this.rhead.getValue(45) + "Hz";
        }
        if (this.thisDataType.startsWith("Dis") && this.rhead.getValue(49) != 0.0) {
            return String.valueOf(start) + "displacement: " + this.rhead.getStringValue(49) + " mm" + start2 + "displacement frequency: " + this.rhead.getValue(50) + "Hz";
        }
        return null;
    }

    public String getDAUComment(HashMap attributes) {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        tmap.put("headerLine", 4);
        tmap.put("afterString", "Instrument");
        String temp = this.thead.getValue(tmap).trim();
        if (temp == null || temp.length() == 0) {
            return null;
        }
        if (temp.startsWith(":")) {
            return temp.substring(2);
        }
        return temp;
    }

    public String getSensorRelativeAzimuth(HashMap attributes) {
        String stype = this.ihead.getStringValue(32);
        if (stype.length() < 1) {
            return null;
        }
        int arrayaz = this.ihead.getValue(32);
        int[] intNulls = this.ihead.getNullAsInt();
        if (arrayaz == 0 || arrayaz == 360) {
            return null;
        }
        int i = 0;
        while (i < intNulls.length) {
            if (arrayaz == intNulls[i]) {
                return null;
            }
            ++i;
        }
        int az = this.ihead.getValue(27);
        int i2 = 0;
        while (i2 < intNulls.length) {
            if (az == intNulls[i2]) {
                return null;
            }
            ++i2;
        }
        if (az > 360) {
            return null;
        }
        if (az >= arrayaz) {
            return String.valueOf(az - arrayaz);
        }
        return String.valueOf(360 - arrayaz + az);
    }
}

