/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.COSMOSv12;

import java.util.HashMap;
import org.cosmos.to_tag.DateTime;
import org.cosmos.to_tag.MatrixHandler;
import org.cosmos.to_tag.ProcessFormat;
import org.cosmos.to_tag.TableHandler;
import org.cosmos.to_tag.comment;
import org.cosmos.to_tag.data;
import org.cosmos.to_tag.fourierData;
import org.cosmos.to_tag.integerHeader;
import org.cosmos.to_tag.numberFormat;
import org.cosmos.to_tag.periods;
import org.cosmos.to_tag.realHeader;
import org.cosmos.to_tag.responseSpectraData;
import org.cosmos.to_tag.textHeader;
import org.cosmos.to_tag.timeSeriesData;

public class Process
extends ProcessFormat {
    private int currentLine;
    private textHeader thead;
    private integerHeader ihead;
    private realHeader rhead;
    private comment comm;
    private data ts;
    private periods per;
    private int numberOfPeriods;
    private String firstSampleDateTime;
    private String structureInfluence;

    public Process(String dir) {
        super(dir);
        this.spec = new String[]{"SdData", "SvData", "SaData"};
        this.currentLine = 0;
        this.componentTypes = new String[]{"textHeader", "integerHeader", "realHeader", "comment"};
    }

    @Override
    public String setComponents() {
        if (!this.isValid(this.lines[0])) {
            return "file does not contain the text string '1.2' in columns 36-40, so is not a valid Cosmos 1.2 file";
        }
        this.makeTextHeader();
        String[] defaultIntValue = new String[]{this.lines[12].substring(64, 71).trim()};
        String[] defaultRealValue = new String[]{this.lines[12].substring(72, 80).trim()};
        this.makeIntegerHeader(defaultIntValue, this.th);
        this.makeRealHeader(defaultRealValue);
        this.makeComment();
        if (this.lines[0].toLowerCase().indexOf("spectra") > -1) {
            this.makeSpectra();
        } else {
            this.makeTimeSeries();
        }
        return null;
    }

    private boolean isValid(String line1) {
        int position = line1.indexOf("1.2", 35);
        return position > 35 && position < 39;
    }

    public void makeTextHeader() {
        this.thead = (textHeader)this.templ.getComponent("textHeader", 1);
        int numLines = 0;
        try {
            String count = this.lines[0].substring(46, 48);
            this.thead.setnumberOfLines(count);
            numLines = this.thead.getnumberOfLines();
        }
        catch (Exception e) {
            System.err.println("file does not contain number of text header lines in columns 47-48");
        }
        this.thead.setLines(this.extractLines(0, numLines));
        this.currentLine = numLines;
    }

    public void makeIntegerHeader(String[] defaultValue, TableHandler th) {
        int numLines = 0;
        String first = this.lines[this.currentLine];
        try {
            this.ihead = (integerHeader)this.templ.getComponent("integerHeader", 1);
            numberFormat format = null;
            String formatType = first.substring(57, first.indexOf(")", 57)).trim();
            format = this.templ.getFormat(formatType);
            this.ihead.addComponent(format);
            this.ihead.setNumberOfValues(first.substring(0, 4).trim());
            numLines = this.ihead.getNumberOfLines();
            this.ihead.setLines(this.extractLines(this.currentLine + 1, numLines));
            this.ihead.setNullValue(defaultValue);
            this.ihead.setTables(th);
            this.currentLine = numLines + this.currentLine + 1;
        }
        catch (Exception e) {
            System.err.println("trouble reading integer header: " + e.toString());
        }
    }

    public void makeRealHeader(String[] defaultValue) {
        int numLines = 0;
        String first = this.lines[this.currentLine];
        try {
            this.rhead = (realHeader)this.templ.getComponent("realHeader", 1);
            numberFormat format = null;
            String formatType = first.substring(54, first.indexOf(")", 54)).trim();
            format = this.templ.getFormat(formatType);
            this.rhead.addComponent(format);
            this.rhead.setNumberOfValues(first.substring(0, 4).trim());
            numLines = this.rhead.getNumberOfLines();
            this.rhead.setLines(this.extractLines(this.currentLine + 1, numLines));
            this.rhead.setNullValue(defaultValue);
        }
        catch (Exception e) {
            System.err.println("trouble reading real header, on line : " + this.currentLine + " " + e.toString());
        }
        this.currentLine = numLines + this.currentLine + 1;
    }

    public void makeComment() {
        this.comm = (comment)this.templ.getComponent("comment", 1);
        String first = this.lines[this.currentLine];
        if (first.indexOf("omment") > -1) {
            this.comm.setStartsWith(first.substring(50, first.indexOf("\":")));
            this.comm.setNumberOfLines(first.substring(0, 4).trim());
            int numLines = this.comm.getNumberOfLines();
            this.comm.setLines(this.extractLines(this.currentLine + 1, numLines));
            this.currentLine = numLines + this.currentLine + 1;
        } else {
            this.comm.setLines("");
        }
    }

    public void makeTimeSeries() {
        String datatype = this.lines[0].toLowerCase().substring(0, 25).trim();
        String dtype = "";
        if (datatype.indexOf("acceleration") > -1) {
            dtype = datatype.indexOf("uncorrected") > -1 ? "UnprocessedData" : "AccData";
        } else if (datatype.indexOf("velocity") > -1) {
            dtype = "VelData";
        } else if (datatype.indexOf("displacement") > -1) {
            dtype = "DisData";
        }
        String first = this.lines[this.currentLine];
        this.templ.addComponent(dtype);
        this.ts = (timeSeriesData)this.templ.getComponent(dtype, 1);
        this.ts.setUnits(this.getUnits(first));
        String npts = first.substring(0, 8).trim();
        int numPoints = Integer.parseInt(npts);
        String checkString = "format=";
        String form = first.substring(first.toLowerCase().indexOf(checkString) + checkString.length(), first.length()).toUpperCase();
        form = form.replace("(", "");
        form = form.replace(")", "");
        numberFormat nf = this.templ.getFormat(form);
        this.ts.addComponent(nf);
        int numLines = numPoints / nf.getNumberPerLine();
        if (numPoints % numLines > 0) {
            ++numLines;
        }
        this.ts.setLines(this.extractLines(this.currentLine + 1, numLines));
    }

    public void makeSpectra() {
        String first = this.lines[this.currentLine];
        String damps = first.substring(51, first.length()).trim();
        responseSpectraData rs = new responseSpectraData();
        String[] dampingset = damps.split(",");
        if (dampingset.length < 2) {
            dampingset = damps.split("  ");
        }
        rs.setDamping(dampingset);
        String second = this.lines[this.currentLine + 1];
        String nPeriods = second.substring(0, 4).trim();
        String formatType = second.substring(71, second.lastIndexOf(")")).trim();
        numberFormat nf = this.templ.getFormat(formatType);
        this.numberOfPeriods = Integer.parseInt(nPeriods);
        int numLines = this.numberOfPeriods / nf.getNumberPerLine();
        if (this.numberOfPeriods % nf.getNumberPerLine() > 0) {
            ++numLines;
        }
        this.currentLine += 2;
        this.per = new periods();
        this.per.addComponent(nf);
        this.per.setNumberOfLines(numLines);
        this.per.setPeriods(this.extractLines(this.currentLine, numLines));
        rs.setPeriods(this.per);
        this.currentLine += numLines;
        this.templ.addComponent("fourierData");
        String header = this.lines[this.currentLine];
        fourierData fd = (fourierData)this.templ.getComponent("fourierData", 1);
        formatType = header.substring(71, header.lastIndexOf(")")).trim();
        nf = this.templ.getFormat(formatType);
        fd.addComponent(nf);
        fd.setUnits(this.getUnits(header));
        fd.setPeriods(this.per);
        numLines = this.numberOfPeriods / nf.getNumberPerLine();
        if (this.numberOfPeriods % nf.getNumberPerLine() > 0) {
            ++numLines;
        }
        fd.setLines(this.extractLines(this.currentLine + 1, numLines));
        this.currentLine = this.currentLine + numLines + 1;
        int dampIndex = 0;
        while (dampIndex < rs.getNumberOfDampingValues()) {
            int i = 0;
            while (i < this.spec.length) {
                this.fillSpec(this.spec[i], dampIndex);
                ++i;
            }
            ++dampIndex;
        }
    }

    private void fillSpec(String specType, int dampIndex) {
        if (dampIndex == 0) {
            this.templ.addComponent(specType);
        }
        String header = this.lines[this.currentLine];
        responseSpectraData sp = (responseSpectraData)this.templ.getComponent(specType, 1);
        String formatType = header.substring(71, header.lastIndexOf(")")).trim();
        numberFormat nf = this.templ.getFormat(formatType);
        sp.addComponent(nf);
        sp.setUnits(this.getUnits(header));
        int numLines = this.numberOfPeriods / nf.getNumberPerLine();
        if (this.numberOfPeriods % nf.getNumberPerLine() > 0) {
            ++numLines;
        }
        sp.setLines(this.extractLines(this.currentLine + 1, numLines), dampIndex);
        this.currentLine = this.currentLine + numLines + 1;
    }

    private String getUnits(String headerLine) {
        try {
            int beginUnits = headerLine.indexOf("(1");
            String unitsCode = headerLine.substring(59, headerLine.indexOf(")")).trim();
            unitsCode = unitsCode.replace("(", "");
            unitsCode = unitsCode.replace(")", "");
            int index = Integer.parseInt(unitsCode);
            return this.th.getValue(2, index);
        }
        catch (Exception e) {
            System.err.println("couldn't retrieve units from the header lines: " + e.toString());
            return null;
        }
    }

    @Override
    public void resetElements(MatrixHandler mh, data dats) {
        mh.resetElement("DataSeries.PhysicalParameter_txt", dats.getDataName());
        String units = null;
        String[] formats = null;
        if (dats instanceof responseSpectraData) {
            responseSpectraData rs = (responseSpectraData)dats;
            units = rs.getUnits();
            int ndamps = rs.getNumberOfDampingValues();
            mh.resetElement("DataSeries.UnevenSamplingUnits_txt", "s");
            int i = 1;
            while (i < ndamps) {
                mh.resetElement("DataSeries.Units(" + i + ")_txt", units);
                ++i;
            }
            i = ndamps + 1;
            while (i < this.maxformats) {
                mh.resetElement("DataSeries.Units(" + i + ")_txt", null);
                ++i;
            }
            formats = rs.getFortranFormat();
            mh.resetElement("DataSeries.UnevenSamplingAbscissaFormat", formats[0]);
            this.setFormats(mh, rs.getFortranFormat());
            mh.setDamping(rs.getDamping());
            i = 0;
            while (i < ndamps) {
                int n = i + 1;
                mh.resetElement("DataSeries.Peak(" + n + ").Value_dbl", rs.getMax(i), units);
                mh.resetElement("DataSeries.Peak(" + n + ").Locus_dbl", rs.getMaxPoint(i), "s");
                ++i;
            }
            mh.setUnits("DataSeries.Mean_dbl", "g_standard");
            mh.setUnits("RawSeries.Mean_dbl", "g_standard");
            mh.setUnits("DataSeries.RMS_dbl", "g_standard");
        } else if (dats instanceof fourierData) {
            fourierData fs = (fourierData)dats;
            units = dats.getUnits();
            formats = fs.getFortranFormat();
            mh.resetElement("DataSeries.UnevenSamplingAbscissaFormat", formats[0]);
            this.setFormats(mh, fs.getFortranFormat());
            mh.resetElement("DataSeries.UnevenSamplingUnits_txt", "s");
            mh.resetElement("DataSeries.Units(1)_txt", units);
            int i = 2;
            while (i < this.maxformats) {
                mh.resetElement("DataSeries.Units(" + i + ")_txt", null);
                ++i;
            }
            mh.resetElement("DataSeries.Peak(1).Value_dbl", fs.getMax(), units);
            mh.resetElement("DataSeries.Peak(1).Locus_dbl", fs.getMaxPoint(), "s");
        } else if (dats instanceof timeSeriesData) {
            timeSeriesData ts = (timeSeriesData)dats;
            String samps = String.valueOf(ts.getNumberOfPoints());
            mh.resetElement("DataSeries.NumberOfSamples_int", samps);
            units = ts.getUnits();
            mh.resetElement("DataSeries.UnevenSamplingUnits_txt", null);
            mh.resetElement("DataSeries.Units(1)_txt", units);
            int i = 2;
            while (i < this.maxformats) {
                mh.resetElement("DataSeries.Units(" + i + ")_txt", null);
                ++i;
            }
            formats = ts.getFortranFormat();
            mh.resetElement("DataSeries.OrdinateFormat(1)", formats[0]);
            mh.resetElement("DataSeries.UnevenSamplingAbscissaFormat", null);
            mh.setUnits("DataSeries.Peak(1).Value_dbl", units);
            mh.setUnits("DataSeries.RMS_dbl", units);
            mh.setUnits("DataSeries.Mean_dbl", units);
            mh.setUnits("RawSeries.Mean_dbl", units);
        }
    }

    public String getStructureInfluence(HashMap attributes) {
        if (this.structureInfluence != null) {
            return this.structureInfluence;
        }
        int[] intNulls = this.ihead.getNullAsInt();
        int type = this.ihead.getValue(19);
        int i = 0;
        while (i < intNulls.length) {
            if (type == intNulls[i]) {
                return null;
            }
            ++i;
        }
        this.structureInfluence = type < 4 ? "Free Field" : (type == 4 ? "Reference" : "In or on structure");
        return this.structureInfluence;
    }

    public String getBuildingType(HashMap attributes) {
        if (this.ihead.getValue(19) == 10) {
            return "Other Building Type";
        }
        return null;
    }

    public String getBridgeType(HashMap attributes) {
        if (this.ihead.getValue(19) == 11) {
            return "Other Bridge";
        }
        return null;
    }

    public String getDamType(HashMap attributes) {
        if (this.ihead.getValue(19) == 12) {
            return "Other Dam";
        }
        return null;
    }

    public String getArrayType(HashMap attributes) {
        if (this.ihead.getValue(19) == 50) {
            return "Geotechnical Array";
        }
        if (this.ihead.getValue(19) == 51) {
            return "Other Array";
        }
        return null;
    }

    public String getRawPeak(HashMap attributes) {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        try {
            tmap.put("headerLine", new Integer("10"));
            tmap.put("startColumn", new Integer("45"));
            tmap.put("endColumn", new Integer("54"));
            String temp = this.thead.getValue(tmap);
            if (temp.startsWith(".")) {
                temp = "0" + temp;
            }
            if (temp.startsWith("-.")) {
                temp = "-0" + temp.substring(1);
            }
            if (temp.endsWith(" g")) {
                temp = String.valueOf(temp) + "_standard";
            }
            if (temp.endsWith(" cm/sec2")) {
                temp = " cm/s/s";
            }
            if (temp.endsWith(" cm/sec")) {
                temp = " cm/s";
            }
            return temp;
        }
        catch (Exception ee) {
            return null;
        }
    }

    public String getDataPeak(HashMap attributes) {
        String dataPeak = this.rhead.getStringValue(64);
        return dataPeak;
    }

    protected void setStuctureInfluence(String si) {
        this.structureInfluence = si;
    }

    public String getGain(HashMap attributes) {
        String value = this.rhead.getStringValue(47);
        String[] nulls = this.rhead.getNullValue();
        int i = 0;
        while (i < nulls.length) {
            if (value.indexOf(nulls[i]) > -1) {
                return null;
            }
            ++i;
        }
        try {
            return String.valueOf(20.0 * Math.log10(Double.parseDouble(value)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFirstSample(HashMap attributes) {
        int[] intNulls = this.ihead.getNullAsInt();
        DateTime dt = new DateTime();
        int year = this.ihead.getValue(40);
        int mon = this.ihead.getValue(42) - 1;
        int day = this.ihead.getValue(43);
        boolean hour = false;
        boolean min = false;
        int[] hm = new int[2];
        hm[1] = 0;
        hm[0] = 0;
        int j = 0;
        while (j < 1) {
            block6: {
                int i = 0;
                while (i < intNulls.length) {
                    if (this.ihead.getValue(j + 44) != intNulls[i]) {
                        ++i;
                        continue;
                    }
                    break block6;
                }
                hm[j] = this.ihead.getValue(j + 44);
            }
            ++j;
        }
        int sec = 0;
        int milli = 0;
        String seconds = this.rhead.getStringValue(30);
        String[] doubleNulls = this.rhead.getNullValue();
        boolean isNull = false;
        int i = 0;
        while (i < doubleNulls.length) {
            if (seconds.startsWith(doubleNulls[i])) {
                isNull = true;
            }
            ++i;
        }
        if (!isNull) {
            double secs = this.rhead.getValue(30);
            sec = (int)secs;
            milli = (int)((secs - (double)sec) * 1000.0);
        }
        this.firstSampleDateTime = dt.getDateString(year, mon, day, hm[0], hm[1], sec, milli, "UTC");
        return this.firstSampleDateTime;
    }

    private String getOutputFileNameDate() {
        if (this.firstSampleDateTime == null) {
            return "00000000_000000";
        }
        DateTime dt = new DateTime();
        return dt.getOutputFileNameDate(this.firstSampleDateTime);
    }

    @Override
    public String getOutputFileName(String datatype) {
        String stage;
        String name = this.getOutputFileNameDate();
        String agency = this.th.getValue(4, this.ihead.getValue(11));
        if (agency == null) {
            agency = this.th.getValue(11, this.ihead.getValue(12));
        }
        name = String.valueOf(name) + "_" + agency;
        String site = this.thead.getLine(5).substring(28, 34).trim();
        if (site.length() < 1) {
            site = this.ihead.getStringValue(8);
        }
        name = String.valueOf(name) + "_" + site;
        int bluebookVol = this.ihead.getValue(1);
        int[] intNulls = this.ihead.getNullAsInt();
        boolean isNull = false;
        int i = 0;
        while (i < intNulls.length) {
            if (bluebookVol == intNulls[i]) {
                isNull = true;
            }
            ++i;
        }
        if (!isNull) {
            name = String.valueOf(name) + "_Vo" + bluebookVol;
        }
        int instance = this.ihead.getValue(77);
        isNull = false;
        int i2 = 0;
        while (i2 < intNulls.length) {
            if (instance == intNulls[i2]) {
                isNull = true;
            }
            ++i2;
        }
        if (!isNull) {
            name = String.valueOf(name) + "_Op" + instance;
        }
        if ((stage = this.th.getValue(17, this.ihead.getValue(60))) != null) {
            name = String.valueOf(name) + "_St" + stage.substring(0, 1);
        }
        int channelNo = this.ihead.getValue(50);
        isNull = false;
        int i3 = 0;
        while (i3 < intNulls.length) {
            if (channelNo == intNulls[i3]) {
                isNull = true;
            }
            ++i3;
        }
        if (!isNull) {
            name = String.valueOf(name) + "_Ch" + channelNo;
        }
        int arrayIndex = this.ihead.getValue(56);
        isNull = false;
        int i4 = 0;
        while (i4 < intNulls.length) {
            if (arrayIndex == intNulls[i4]) {
                isNull = true;
            }
            ++i4;
        }
        if (!isNull) {
            name = String.valueOf(name) + "In" + arrayIndex;
        }
        name = String.valueOf(name) + "_" + datatype + ".cosm";
        return this.fixFileName(name);
    }

    public String getComments(HashMap attributes) {
        String allLines = this.comm.toString();
        if (allLines.length() == 0) {
            return null;
        }
        String lineDelimiter = "\r\n|\n|\r";
        String startswith = this.comm.getStartsWith();
        String[] iLines = allLines.split(lineDelimiter);
        String oLines = "";
        int startIndex = startswith.length();
        int ix = 0;
        int i = 0;
        while (i < iLines.length) {
            ix = iLines[i].indexOf(startswith);
            oLines = String.valueOf(oLines) + iLines[i].substring(ix + startIndex).trim() + " ";
            ++i;
        }
        return oLines;
    }

    public String getSampleInterval(HashMap attributes) {
        String[] doubleNulls = this.rhead.getNullValue();
        int i = 0;
        while (i < doubleNulls.length) {
            if (this.rhead.getStringValue(62).startsWith(doubleNulls[i])) {
                return null;
            }
            ++i;
        }
        return String.valueOf(this.rhead.getValue(62) / 1000.0);
    }

    public String getSensorAzimuth(HashMap attributes) {
        String azim = null;
        String[] intNulls = this.ihead.getNullValue();
        int i = 0;
        while (i < intNulls.length) {
            if (this.ihead.getStringValue(54).startsWith(intNulls[i])) {
                return null;
            }
            ++i;
        }
        int az = this.ihead.getValue(54);
        if (az < 361) {
            azim = String.valueOf(az);
        } else if (az > 399 && az < 403) {
            azim = String.valueOf(0);
        } else if (az > 1000 && az < -1360) {
            azim = String.valueOf(az - 1000);
        }
        return azim;
    }

    public String getRelativeAzimuth(HashMap attributes) {
        String[] intNulls = this.ihead.getNullValue();
        int i = 0;
        while (i < intNulls.length) {
            if (this.ihead.getStringValue(55).startsWith(intNulls[i])) {
                return null;
            }
            ++i;
        }
        String azim = null;
        int az = this.ihead.getValue(55);
        if (az < 361) {
            azim = String.valueOf(az);
        } else if (az > 399 && az < 403) {
            azim = String.valueOf(0);
        }
        return azim;
    }

    public String getSensorOrientation(HashMap attributes) {
        String[] intNulls = this.ihead.getNullValue();
        int i = 0;
        while (i < intNulls.length) {
            if (this.ihead.getStringValue(54).startsWith(intNulls[i])) {
                return null;
            }
            ++i;
        }
        String azim = null;
        int az = this.ihead.getValue(54);
        if (az == 402) {
            azim = "Vertical";
        } else if (az == 500) {
            azim = "AntiRadial";
        } else if (az == -500) {
            azim = "Radial";
        } else if (az == 501) {
            azim = "Transverse";
        } else if (az == 600) {
            azim = "Longitudinal";
        } else if (az == 601) {
            azim = "ShortAxis";
        } else if (az == 701 || az == 701) {
            azim = "Horizontal, azimuth unknown";
        } else if (az > 1000 && az < 1361) {
            azim = "Horizontal azimuth is relative to Channel 1";
        }
        return azim;
    }

    public String getSensorInclination(HashMap attributes) {
        String[] intNulls = this.ihead.getNullValue();
        int i = 0;
        while (i < intNulls.length) {
            if (this.ihead.getStringValue(54).startsWith(intNulls[i])) {
                return null;
            }
            ++i;
        }
        String incl = null;
        int inc = this.ihead.getValue(54);
        if (inc < 361) {
            incl = String.valueOf(90);
        }
        if (inc == 400) {
            incl = String.valueOf(0);
        }
        if (inc == 401) {
            incl = String.valueOf(180);
        }
        if (inc == 700 || inc == 701) {
            incl = String.valueOf(90);
        }
        if (inc == 500 || inc == 501) {
            incl = String.valueOf(90);
        }
        if (inc == -500 || inc == -501) {
            incl = String.valueOf(90);
        }
        if (inc > 1000 && inc < 1361) {
            incl = String.valueOf(90);
        }
        return incl;
    }

    public String getOriginDateTime(HashMap attributes) {
        try {
            return this.parseDate(4);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getProcessingDateTime(HashMap attributes) {
        return this.parseDate(11);
    }

    private String parseDate(int lineNo) {
        int origin;
        DateTime dt = new DateTime();
        int[] dateparts = null;
        String line = this.thead.getLine(lineNo);
        int end = origin = line.indexOf(":") + 1;
        try {
            int start = origin;
            end = line.indexOf("/");
            int mon = Integer.parseInt(line.substring(start, end).trim());
            start = end + 1;
            end = line.indexOf("/", start);
            int day = Integer.parseInt(line.substring(start, end));
            start = end + 1;
            end = line.indexOf(",", start);
            String syear = line.substring(start, end);
            if (syear.startsWith("0")) {
                syear = "20" + syear;
            }
            int year = Integer.parseInt(syear);
            start = end + 1;
            int testend = line.indexOf(":", start);
            if (testend > 0) {
                int sec;
                end = line.indexOf(":", start);
                int hour = Integer.parseInt(line.substring(start, end).trim());
                start = end + 1;
                end = line.indexOf(":", start);
                int min = Integer.parseInt(line.substring(start, end));
                start = end + 1;
                if ((end = line.indexOf(".", start)) > start + 2 || end < 0) {
                    end = line.indexOf(" ", start);
                    sec = Integer.parseInt(line.substring(start, end));
                    dateparts = new int[]{year, mon, day, hour, min, sec};
                } else {
                    sec = Integer.parseInt(line.substring(start, end));
                    start = end;
                    end = line.indexOf(" ", start);
                    int milli = (int)(Double.parseDouble(line.substring(start, end)) * 1000.0);
                    dateparts = new int[]{year, mon, day, hour, min, sec, milli};
                }
                String zone = line.substring(end, end + 4);
                String date = dt.getDateString(dateparts, zone.trim());
                return date;
            }
            String zone = "PST";
            dateparts = new int[]{year, mon, day};
            String date = dt.getDateString(dateparts, zone.trim());
            return date;
        }
        catch (Exception e) {
            System.err.println("can't parse date: " + line.substring(origin, end) + " " + e.toString());
            return null;
        }
    }
}

