/*
 * Decompiled with CFR 0.152.
 */
package org.cosmos.CGS_DMG2003;

import java.util.Calendar;
import java.util.HashMap;
import org.cosmos.to_tag.DateTime;
import org.cosmos.to_tag.MatrixHandler;
import org.cosmos.to_tag.ProcessFormat;
import org.cosmos.to_tag.TableHandler;
import org.cosmos.to_tag.data;
import org.cosmos.to_tag.fourierData;
import org.cosmos.to_tag.integerHeader;
import org.cosmos.to_tag.numberFormat;
import org.cosmos.to_tag.periods;
import org.cosmos.to_tag.realHeader;
import org.cosmos.to_tag.responseSpectraData;
import org.cosmos.to_tag.textHeader;
import org.cosmos.to_tag.timeSeriesData;

public class Process
extends ProcessFormat {
    private int currentLine = 0;
    private textHeader thead;
    private integerHeader ihead;
    private realHeader rhead;
    private data ts;
    private String firstSampleDateTime;
    private Calendar firstSampleCalendar;
    private periods per;
    private int numberOfPeriods;
    private HashMap<String, String> specUnits;
    private String structureInfluence;
    private String thisDataType;
    private int volume;

    public Process(String dir) {
        super(dir);
        this.spec = new String[]{"SdData", "SvData", "SaData", "PSVData", "ttsd", "ttsv", "ttsa"};
        this.specUnits = new HashMap();
        this.specUnits.put("SdData", "in");
        this.specUnits.put("SvData", "in/s");
        this.specUnits.put("SaData", "g_standard");
        this.specUnits.put("PSVData", "in/s");
        this.componentTypes = new String[]{"textHeader", "integerHeader", "realHeader"};
    }

    public void initialize() {
        this.thead = null;
        this.ihead = null;
        this.rhead = null;
        this.ts = null;
    }

    @Override
    public String setComponents() {
        this.initialize();
        if (!this.isValid(this.lines[0])) {
            return "file is not a recognizable DMG format file";
        }
        try {
            this.makeTextHeader();
            String[] defaultIntValue = new String[]{"0", "-999"};
            String[] defaultRealValue = new String[]{".000", "-999.00000", "-999.000"};
            this.makeIntegerHeader(defaultIntValue, this.th);
            this.makeRealHeader(defaultRealValue);
        }
        catch (Exception e) {
            return "error reading file header, " + e.toString();
        }
        if (this.volume == 3) {
            this.makeSpectra();
        } else {
            this.makeTimeSeries();
        }
        return null;
    }

    private boolean isValid(String firstLine) {
        int position = firstLine.toLowerCase().indexOf("corrected", 0);
        if (position == 2 && !firstLine.contains("v01.20")) {
            this.volume = 1;
            return true;
        }
        if (position == 0 && !firstLine.contains("v01.20")) {
            this.volume = 2;
            return true;
        }
        position = firstLine.toLowerCase().indexOf("response and fourier amplitude spectra");
        if (position == 0) {
            this.volume = 3;
            return true;
        }
        return false;
    }

    public void makeTextHeader() {
        this.thead = (textHeader)this.templ.getComponent("textHeader", 1);
        String noLines = "13";
        if (this.volume == 2) {
            noLines = "25";
        }
        if (this.volume == 3) {
            noLines = "30";
        }
        this.thead.setnumberOfLines(noLines);
        int numLines = this.thead.getnumberOfLines();
        this.thead.setLines(this.extractLines(0, numLines));
        this.currentLine = numLines;
    }

    public void makeIntegerHeader(String[] defaultValue, TableHandler th) {
        try {
            this.ihead = (integerHeader)this.templ.getComponent("integerHeader", 1);
            numberFormat format = null;
            format = this.templ.getFormat("16I5");
            this.ihead.addComponent(format);
            this.ihead.setNumberOfValues("100");
            int numLines = this.ihead.getNumberOfLines();
            this.ihead.setLines(this.extractLines(this.currentLine, numLines));
            this.ihead.setNullValue(defaultValue);
            this.ihead.setTables(th);
            this.currentLine = numLines + this.currentLine;
        }
        catch (Exception e) {
            System.err.println("trouble reading integer header: " + e.toString());
            return;
        }
    }

    public void makeRealHeader(String[] defaultValue) {
        try {
            this.rhead = (realHeader)this.templ.getComponent("realHeader", 1);
            numberFormat format = this.templ.getFormat("8F10.3");
            this.rhead.addComponent(format);
            if (this.volume == 1) {
                this.rhead.setNumberOfValues("50");
            } else {
                this.rhead.setNumberOfValues("100");
            }
            int numLines = this.rhead.getNumberOfLines();
            this.rhead.setLines(this.extractLines(this.currentLine, numLines));
            this.rhead.setNullValue(defaultValue);
            this.currentLine = numLines + this.currentLine;
        }
        catch (Exception e) {
            System.err.println("trouble reading real header, on line : " + this.currentLine + " " + e.toString());
            return;
        }
    }

    public void makeTimeSeries() {
        String datatype = this.lines[0].toLowerCase().substring(0, 25).trim();
        String dtype = "";
        if (datatype.indexOf("accelerogram") > -1 || datatype.indexOf("uncorrected") > -1) {
            dtype = "UncData";
        } else if (datatype.indexOf("accelerogram") > -1 || datatype.indexOf("acceleration") > -1) {
            dtype = "AccData";
        } else if (datatype.indexOf("velocity") > -1) {
            dtype = "VelData";
        } else if (datatype.indexOf("displacement") > -1) {
            dtype = "DisData";
        }
        String first = this.lines[this.currentLine];
        this.thisDataType = dtype;
        this.templ.addComponent(dtype);
        this.ts = (timeSeriesData)this.templ.getComponent(dtype, 1);
        if (dtype.indexOf("AccData") > -1) {
            this.ts.setUnits("cm/s/s");
        }
        if (dtype.indexOf("UncData") > -1) {
            this.ts.setUnits("cm/s/s");
        }
        if (dtype.indexOf("VelData") > -1) {
            this.ts.setUnits("cm/s");
        }
        if (dtype.indexOf("DisData") > -1) {
            this.ts.setUnits("cm");
        }
        String npts = first.substring(0, 6).trim();
        int numPoints = Integer.parseInt(npts);
        String form = first.substring(first.indexOf("(") + 1, first.lastIndexOf(")")).toUpperCase();
        numberFormat nf = null;
        try {
            nf = this.templ.getFormat(form);
        }
        catch (Exception e) {
            nf = this.templ.getFormat("8F10.3");
        }
        this.ts.addComponent(nf);
        int numLines = numPoints / nf.getNumberPerLine();
        if (numPoints % numLines > 0) {
            ++numLines;
        }
        this.ts.setLines(this.extractLines(this.currentLine + 1, numLines));
    }

    public void makeSpectra() {
        this.thisDataType = "spec";
        String dampline = this.lines[this.currentLine++];
        int nDamps = this.ihead.getValue(69);
        responseSpectraData rs = new responseSpectraData();
        String[] dampset = new String[nDamps];
        int start = 0;
        int k = 0;
        while (k < nDamps) {
            dampset[k] = dampline.substring(start, start + 10).trim();
            start += 10;
            ++k;
        }
        rs.setDamping(dampset);
        numberFormat nf = this.templ.getFormat("1F10.3");
        this.numberOfPeriods = this.ihead.getValue(68);
        int numLines = 13;
        this.per = new periods();
        this.per.addComponent(nf);
        this.per.setNumberOfLines(numLines);
        String[] templines = this.extractLines(this.currentLine, numLines);
        String[] actualValues = this.getActualValues(this.numberOfPeriods, templines);
        this.per.setPeriods(actualValues);
        rs.setPeriods(this.per);
        this.currentLine += numLines;
        this.templ.addComponent("fourierData");
        fourierData fd = (fourierData)this.templ.getComponent("fourierData", 1);
        nf = this.templ.getFormat("1E10.3");
        fd.addComponent(nf);
        fd.setUnits("in/s");
        fd.setPeriods(this.per);
        numLines = 13;
        templines = this.extractLines(++this.currentLine, numLines);
        actualValues = this.getActualValues(this.numberOfPeriods, templines);
        fd.setLines(actualValues);
        this.currentLine += numLines;
        int dampIndex = 0;
        while (dampIndex < nDamps) {
            ++this.currentLine;
            int i = 0;
            while (i < this.spec.length) {
                if (this.spec[i].startsWith("tt")) {
                    this.currentLine += 13;
                } else {
                    this.fillSpec(this.spec[i], dampIndex);
                }
                ++i;
            }
            ++dampIndex;
        }
    }

    private String[] getActualValues(int numValues, String[] lines) {
        int start = 0;
        int j = 0;
        int k = 0;
        String temp = null;
        String[] actualValues = new String[this.numberOfPeriods];
        while (j < numValues) {
            temp = lines[k].substring(start, start + 10);
            if (temp.contains(" .")) {
                temp = temp.replace(" .", "0.");
            }
            if (temp.contains(" -.")) {
                temp = temp.replace(" -.", "-0.");
            }
            actualValues[j++] = temp;
            if ((start += 10) <= 70) continue;
            start = 0;
            ++k;
        }
        return actualValues;
    }

    private void fillSpec(String specType, int dampIndex) {
        if (dampIndex == 0) {
            this.templ.addComponent(specType);
        }
        responseSpectraData sp = (responseSpectraData)this.templ.getComponent(specType, 1);
        String formatType = "1E10.3";
        numberFormat nf = this.templ.getFormat(formatType);
        sp.addComponent(nf);
        sp.setUnits(this.specUnits.get(specType));
        int numLines = 13;
        String[] templines = this.extractLines(this.currentLine, numLines);
        sp.setLines(this.getActualValues(this.numberOfPeriods, templines), dampIndex);
        this.currentLine += numLines;
    }

    @Override
    public void resetElements(MatrixHandler mh, data dats) {
        block12: {
            block13: {
                int num;
                block11: {
                    mh.resetElement("DataSeries.PhysicalParameter_txt", dats.getDataName());
                    if (!(dats instanceof responseSpectraData)) break block11;
                    responseSpectraData rs = (responseSpectraData)dats;
                    int ndamps = rs.getNumberOfDampingValues();
                    String[] formats = rs.getFortranFormat();
                    mh.resetElement("DataSeries.AbscissaFormat", formats[0]);
                    this.setFormats(mh, formats);
                    mh.resetElement("DataSeries.AbscissaUnits_txt", "s");
                    String units = this.specUnits.get(dats.getClass().getSimpleName());
                    int i = 1;
                    while (i <= ndamps) {
                        mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", units);
                        ++i;
                    }
                    i = ndamps + 1;
                    while (i <= this.maxformats) {
                        mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", null);
                        ++i;
                    }
                    String[] temp = rs.getDamping();
                    int i2 = 0;
                    while (i2 < ndamps) {
                        if (temp[i2].startsWith(".")) {
                            temp[i2] = "0" + temp[i2];
                        }
                        if (temp[i2].startsWith("-.")) {
                            temp[i2] = "-0" + temp[i2].substring(1);
                        }
                        ++i2;
                    }
                    mh.setDamping(temp);
                    i2 = 0;
                    while (i2 < ndamps) {
                        int num2 = i2 + 1;
                        mh.resetElement("DataSeries.Peak(" + num2 + ").Value_dbl", rs.getMax(i2), units);
                        mh.resetElement("DataSeries.Peak(" + num2 + ").Locus_dbl", rs.getMaxPoint(i2), "s");
                        ++i2;
                    }
                    break block12;
                }
                if (!(dats instanceof fourierData)) break block13;
                fourierData fs = (fourierData)dats;
                String units = dats.getUnits();
                String[] formats = fs.getFortranFormat();
                mh.resetElement("DataSeries.AbscissaFormat", formats[0]);
                this.setFormats(mh, formats);
                mh.resetElement("DataSeries.AbscissaUnits_txt", "s");
                mh.resetElement("DataSeries.OrdinateUnits(1)_txt", units);
                int i = 2;
                while (i < this.maxformats) {
                    mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", null);
                    ++i;
                }
                mh.resetElement("DataSeries.Peak(1).Value_dbl", fs.getMax(), units);
                mh.resetElement("DataSeries.Peak(1).Locus_dbl", fs.getMaxPoint(), "Hz");
                i = 1;
                while (i < 5) {
                    num = i + 1;
                    mh.resetElement("DataSeries.Peak(" + num + ").Value_dbl", null, units);
                    mh.resetElement("DataSeries.Peak(" + num + ").Locus_dbl", null, "s");
                    ++i;
                }
                i = 0;
                while (i < 5) {
                    num = i + 1;
                    mh.resetElement("DataSeries.ResponseSpectrumDamping(" + num + ")_dbl", null);
                    ++i;
                }
                break block12;
            }
            if (!(dats instanceof timeSeriesData)) break block12;
            timeSeriesData ts = (timeSeriesData)dats;
            String[] formats = ts.getFortranFormat();
            mh.resetElement("DataSeries.OrdinateFormat(1)", formats[0]);
            int i = 2;
            while (i <= this.maxformats) {
                mh.resetElement("DataSeries.OrdinateFormat(" + i + ")", null);
                ++i;
            }
            mh.resetElement("DataSeries.AbscissaFormat", null);
            mh.resetElement("DataSeries.Peak(1).Value_dbl", ts.getMax(), ts.getUnits());
            mh.setUnits("DataSeries.Peak(1).Locus_dbl", "s");
            mh.resetElement("DataSeries.AbscissaUnits_txt", null);
            mh.resetElement("DataSeries.OrdinateUnits(1)_txt", ts.getUnits());
            i = 2;
            while (i < this.maxformats) {
                mh.resetElement("DataSeries.OrdinateUnits(" + i + ")_txt", null);
                ++i;
            }
        }
    }

    public String getBuildingType(HashMap attributes) {
        if (this.ihead.getValue(19) == 10) {
            return "Other Building";
        }
        return null;
    }

    public String getBridgeType(HashMap attributes) {
        if (this.ihead.getValue(19) == 11) {
            return "Other Bridge";
        }
        return null;
    }

    public String getDamType(HashMap attributes) {
        if (this.ihead.getValue(19) == 12) {
            return "Other Dam";
        }
        return null;
    }

    public String getArrayType(HashMap attributes) {
        if (this.ihead.getValue(19) == 50) {
            return "Geotechnical Array";
        }
        if (this.ihead.getValue(19) == 51) {
            return "Other Array";
        }
        return null;
    }

    public String getUnits(HashMap attributes) {
        return this.getMyUnits();
    }

    public String getUnits() {
        return this.getMyUnits();
    }

    private String getMyUnits() {
        String G = this.getG();
        return G == null ? this.getDefaultUnits() : G;
    }

    private String getG() {
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (this.rhead.getStringValueWithoutLeadingZero(5).startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double value = 100.0 * this.rhead.getValue(5) + 1.0E-4;
        String units = "g_standard/" + String.valueOf(value);
        return units.substring(0, units.indexOf("."));
    }

    private String getDefaultUnits() {
        if (this.thisDataType.startsWith("Unc")) {
            return "cm/s/s";
        }
        if (this.thisDataType.startsWith("Acc")) {
            return "cm/s/s";
        }
        if (this.thisDataType.startsWith("Vel")) {
            return "cm/s";
        }
        if (this.thisDataType.startsWith("Dis")) {
            return "cm";
        }
        return null;
    }

    public String getRawMean(HashMap attributes) {
        String mean = this.rhead.getStringValue(18);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (mean.indexOf(nullVals[i]) > 0) {
                return null;
            }
            ++i;
        }
        String units = this.getG();
        if (units == null) {
            units = "cm/s/s";
        }
        if (units != null) {
            return String.valueOf(mean) + " " + units;
        }
        return null;
    }

    public String getDataPeak(HashMap attributes) {
        if (this.thisDataType.startsWith("Unc")) {
            return String.valueOf(this.rhead.getStringValue(7)) + " cm/s/s";
        }
        if (this.thisDataType.startsWith("Acc")) {
            return String.valueOf(this.rhead.getStringValue(66)) + " cm/s/s";
        }
        if (this.thisDataType.startsWith("Vel")) {
            return String.valueOf(this.rhead.getStringValue(68)) + " cm/s";
        }
        if (this.thisDataType.startsWith("Dis")) {
            return String.valueOf(this.rhead.getStringValue(70)) + " cm";
        }
        return "NULL";
    }

    public String getDataPeakLocation(HashMap attributes) {
        if (this.thisDataType.startsWith("Unc")) {
            return this.rhead.getStringValue(8);
        }
        if (this.thisDataType.startsWith("Acc")) {
            return this.rhead.getStringValue(65);
        }
        if (this.thisDataType.startsWith("Vel")) {
            return this.rhead.getStringValue(67);
        }
        if (this.thisDataType.startsWith("Dis")) {
            return this.rhead.getStringValue(69);
        }
        return "NULL";
    }

    public String getPeakTime(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(82);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(82);
        return String.valueOf(val);
    }

    public String getSA1(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(83);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(83);
        return String.valueOf(val);
    }

    public String getSA2(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(84);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(84);
        return String.valueOf(val);
    }

    public String getSA3(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(85);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(85);
        return String.valueOf(val);
    }

    public String getSA4(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(86);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(86);
        return String.valueOf(val);
    }

    public String getCAV(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(78);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(78);
        return String.valueOf(val);
    }

    public String getSI(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(90);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(90);
        return String.valueOf(val);
    }

    public String getAI(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(91);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(91);
        return String.valueOf(val);
    }

    public String getDurationOver5Pct(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(77);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(77);
        return String.valueOf(val);
    }

    public String getAI5to95(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(79);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(79);
        return String.valueOf(val);
    }

    public String getFrequencyBand1(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        return "Low Pass";
    }

    public String getFrequencyBand2(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        return "High Pass";
    }

    public String getFilterCorner1(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(73);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(73);
        return String.valueOf(val);
    }

    public String getFilterCorner2(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(62);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(62);
        return String.valueOf(val);
    }

    public String getFilterTB1(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(59);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(59);
        return String.valueOf(val);
    }

    public String getFilterTB2(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(63);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(63);
        return String.valueOf(val);
    }

    public String getFilterLength1(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(87);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(87);
        return String.valueOf(val);
    }

    public String getFilterLength2(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(87);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(87);
        return String.valueOf(val);
    }

    public String getNumberOfPoints(HashMap attributes) {
        if (this.thisDataType.startsWith("Unc")) {
            return this.ihead.getStringValue(28);
        }
        if (this.thisDataType.startsWith("Acc")) {
            return this.ihead.getStringValue(53);
        }
        if (this.thisDataType.startsWith("Vel")) {
            return this.ihead.getStringValue(64);
        }
        if (this.thisDataType.startsWith("Dis")) {
            return this.ihead.getStringValue(66);
        }
        return null;
    }

    public String getStationName(HashMap attributes) {
        int end = this.ihead.getValue(30);
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        try {
            int headerLine = this.volume == 2 ? 7 : 8;
            tmap.put("headerLine", headerLine);
            tmap.put("startColumn", 1);
            tmap.put("endColumn", end);
            String temp = this.thead.getValue(tmap).trim();
            return temp;
        }
        catch (Exception ee) {
            return null;
        }
    }

    public String getStationAgency(HashMap attributes) {
        String temp;
        block4: {
            int end = this.ihead.getValue(30);
            HashMap<String, Integer> tmap = new HashMap<String, Integer>();
            try {
                int headerLine = this.volume == 1 ? 6 : (this.volume == 2 ? 7 : 8);
                tmap.put("headerLine", headerLine);
                tmap.put("startColumn", end + 1);
                temp = this.thead.getValue(tmap).trim();
                if (temp.indexOf("CGS") <= -1) break block4;
                return "CE";
            }
            catch (Exception exception) {
                return "CE";
            }
        }
        if (temp.indexOf("USGS") > -1) {
            return "NP";
        }
        return null;
    }

    public String getAntiAliasFilterCorner(HashMap attribute) {
        if (this.volume == 1) {
            return "NULL";
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(92);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(92);
        return String.valueOf(val);
    }

    public String getAntiAliasFilterDecay(HashMap attribute) {
        if (this.volume == 1) {
            return "NULL";
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(93);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return "NULL";
            }
            ++i;
        }
        double val = this.rhead.getValue(93);
        return String.valueOf(val);
    }

    public String getHighPassCorner(HashMap attribute) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(94);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(94);
        return String.valueOf(val);
    }

    public String getHighPassDecay(HashMap attribute) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(95);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(95);
        return String.valueOf(val);
    }

    public String getThisFileAgency(HashMap attributes) {
        int end = this.ihead.getValue(30);
        return "CE";
    }

    public String getProcessingAgency(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        return "CE";
    }

    public String getProcessingDate(HashMap attributes) {
        HashMap<String, Object> tmap = new HashMap<String, Object>();
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            int headerLine = this.volume == 1 ? 1 : (this.volume == 2 ? 2 : 3);
            tmap.put("headerLine", headerLine);
            tmap.put("afterString", "Processed:");
            tmap.put("untilString", ",");
            String temp = this.thead.getValue(tmap).trim();
            DateTime dt = new DateTime();
            month = new Integer(temp.substring(0, 2)) - 1;
            day = new Integer(temp.substring(3, 5));
            year = new Integer(temp.substring(6, 8));
            year = year > 35 ? (year += 1900) : (year += 2000);
            return dt.getDateString(year, month, day, "PST");
        }
        catch (Exception ee) {
            return null;
        }
    }

    public String getEventComment1(HashMap attributes) {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        try {
            int headerLine = this.volume == 2 ? 4 : 5;
            tmap.put("headerLine", headerLine);
            String temp = "Event Date: " + this.thead.getValue(tmap).trim();
            return temp;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getEventComment2(HashMap attributes) {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        try {
            int headerLine = this.volume == 2 ? 10 : 11;
            tmap.put("headerLine", headerLine);
            String temp = "Hypocenter and Magnitude: " + this.thead.getValue(tmap).trim();
            return temp;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getEvtID(HashMap attributes) {
        HashMap<String, Integer> tmap = new HashMap<String, Integer>();
        try {
            int headerLine = this.volume == 2 ? 3 : 4;
            tmap.put("headerLine", headerLine);
            tmap.put("startColumn", 0);
            tmap.put("endColumn", this.ihead.getValue(29));
            String temp = this.thead.getValue(tmap).trim();
            return temp;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setStuctureInfluence(String si) {
        this.structureInfluence = si;
    }

    public String getFirstSample(HashMap attributes) {
        DateTime dt = new DateTime();
        int year = this.ihead.getValue(24);
        int mon = this.ihead.getValue(22) - 1;
        int day = this.ihead.getValue(23);
        int[] hmsl = new int[4];
        hmsl[3] = 0;
        hmsl[2] = 0;
        hmsl[1] = 0;
        hmsl[0] = 0;
        int[] nullVals = this.ihead.getNullAsInt();
        int j = 0;
        while (j < 4) {
            block3: {
                int i = 0;
                while (i < nullVals.length) {
                    if (this.ihead.getValue(17 + j) != nullVals[i]) {
                        ++i;
                        continue;
                    }
                    break block3;
                }
                hmsl[j] = this.ihead.getValue(17 + j);
            }
            ++j;
        }
        this.firstSampleDateTime = dt.getDateString(year, mon, day, hmsl[0], hmsl[1], hmsl[2], hmsl[3], "UTC");
        this.firstSampleCalendar = dt.getCalendar(year, mon, day, hmsl[0], hmsl[1], "UTC");
        return this.firstSampleDateTime;
    }

    public String getJulian(HashMap attributes) {
        return String.valueOf(this.firstSampleCalendar.get(6));
    }

    private String getOutputFileNameDate() {
        if (this.firstSampleDateTime == null) {
            return "00000000_000000";
        }
        DateTime dt = new DateTime();
        return dt.getOutputFileNameDate(this.firstSampleDateTime);
    }

    @Override
    public String getOutputFileName(String datatype) {
        String name = this.getOutputFileNameDate();
        String agency = "CE";
        if (this.thead.getLine(3).indexOf("Taiwan") > -1) {
            agency = "TW";
        }
        name = String.valueOf(name) + "_" + agency;
        String site = String.valueOf(this.ihead.getValue(14));
        name = String.valueOf(name) + "_" + site;
        name = String.valueOf(name) + "_Vo" + this.getBlueBook();
        int channelNo = this.ihead.getValue(3);
        String stage = "Raw";
        if (this.volume != 1) {
            stage = this.th.getValue(17, this.ihead.getValue(97));
        }
        if (stage != null) {
            name = String.valueOf(name) + "_St" + stage.substring(0, 1);
        }
        name = String.valueOf(name) + "_Ch" + channelNo;
        name = String.valueOf(name) + "_" + datatype + ".cosm";
        return this.fixFileName(name);
    }

    public String getFilterName1(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        try {
            String filtername = this.th.getValue(12, this.ihead.getValue(82));
            return filtername;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFilterName2(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        try {
            String filtername = this.th.getValue(12, this.ihead.getValue(80));
            return filtername;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getBlueBook(HashMap attributes) {
        return this.getBlueBook();
    }

    public String getBlueBook() {
        return String.valueOf(this.volume);
    }

    public String getSensorInclination(HashMap attributes) {
        String incl = null;
        int inc = this.ihead.getValue(27);
        if (inc < 361) {
            incl = String.valueOf(90);
        } else if (inc == 500) {
            incl = String.valueOf(0);
        } else if (inc == 600) {
            incl = String.valueOf(180);
        }
        return incl;
    }

    public String getSensorAzimuth(HashMap attributes) {
        int az = this.ihead.getValue(27);
        int[] intNulls = this.ihead.getNullAsInt();
        int i = 0;
        while (i < intNulls.length) {
            if (az == intNulls[i]) {
                return "NULL";
            }
            ++i;
        }
        return az < 360 ? String.valueOf(az) : "0";
    }

    public String getArrayAzimuth(HashMap attributes) {
        String stype = this.ihead.getStringValue(32);
        if (stype.length() < 1) {
            return "NULL";
        }
        int arrayaz = this.ihead.getValue(32);
        if (arrayaz == 0) {
            return "0";
        }
        return String.valueOf(arrayaz);
    }

    public String getSensorRelativeAzimuth(HashMap attributes) {
        String stype = this.ihead.getStringValue(32);
        if (stype.length() < 1) {
            return "NULL";
        }
        int arrayaz = this.ihead.getValue(32);
        int[] intNulls = this.ihead.getNullAsInt();
        int i = 0;
        while (i < intNulls.length) {
            if (arrayaz == intNulls[i]) {
                return "NULL";
            }
            ++i;
        }
        if (arrayaz == 0 || arrayaz == 360) {
            arrayaz = 360;
        }
        if (arrayaz < 0) {
            arrayaz += 360;
        }
        int az = this.ihead.getValue(27);
        int i2 = 0;
        while (i2 < intNulls.length) {
            if (az == intNulls[i2]) {
                return "NULL";
            }
            ++i2;
        }
        if (az > 360) {
            return "NULL";
        }
        if (az >= arrayaz) {
            return String.valueOf(az - arrayaz);
        }
        return String.valueOf(360 - arrayaz + az);
    }

    public String getStructureInfluence(HashMap attributes) {
        String stype = this.ihead.getStringValue(32);
        if (stype.length() < 1) {
            return "Free field";
        }
        int type = this.ihead.getValue(32);
        this.structureInfluence = type == 0 ? "Free field" : "In or on structure";
        return this.structureInfluence;
    }

    public String getRawInterval(HashMap attributes) {
        String value = this.rhead.getStringValueWithoutLeadingZero(13);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(13) / 1000.0;
        return String.valueOf(val);
    }

    public String getRMS(HashMap attributes) {
        String value = this.rhead.getStringValueWithoutLeadingZero(4);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(4);
        return String.valueOf(val);
    }

    public String getRawRMS(HashMap attributes) {
        if (this.volume == 1) {
            return this.getRMS(attributes);
        }
        return null;
    }

    public String getProcRMS(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        return this.getRMS(attributes);
    }

    public String getSampleInterval(HashMap attributes) {
        if (this.volume == 1) {
            return this.getRawInterval(attributes);
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(53);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(53);
        return String.valueOf(val);
    }

    public String getDataSeriesSpan(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(54);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(54);
        return String.valueOf(val);
    }

    public String getInitDec(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(13);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = 1.0 / (this.rhead.getValue(13) / 1000.0);
        return String.valueOf(val);
    }

    public String getFinalDec(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(53);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = 1.0 / this.rhead.getValue(53);
        return String.valueOf(val);
    }

    public String getEventDepth(HashMap attributes) {
        String value = this.rhead.getStringValue(46);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.indexOf(nullVals[i]) > -1) {
                return null;
            }
            ++i;
        }
        String val2 = value.substring(value.indexOf("."));
        double dep = Double.parseDouble(val2) * 1000.0;
        return String.valueOf(dep);
    }

    public String getStatus(HashMap attributes) {
        String value = null;
        if (this.volume == 1) {
            return "None";
        }
        int index = this.ihead.getValue(76);
        value = this.th.getValue(18, index);
        if (value == null) {
            value = "None";
        }
        return value;
    }

    public String getInitialVel(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(71);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(71);
        return String.valueOf(val);
    }

    public String getInitialDisp(HashMap attributes) {
        if (this.volume == 1) {
            return null;
        }
        String value = this.rhead.getStringValueWithoutLeadingZero(76);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.startsWith(nullVals[i])) {
                return null;
            }
            ++i;
        }
        double val = this.rhead.getValue(76);
        return String.valueOf(val);
    }

    public String getGain(HashMap attributes) {
        String value = this.ihead.getStringValue(9);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.indexOf(nullVals[i]) > -1) {
                return null;
            }
            ++i;
        }
        try {
            return String.valueOf(20.0 * Math.log10(Double.parseDouble(value)));
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getMagMoment(HashMap attributes) {
        String value = this.rhead.getStringValue(46);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.indexOf(nullVals[i]) > -1) {
                return null;
            }
            ++i;
        }
        String val2 = value.substring(0, value.indexOf(".") - 1);
        double mw = Double.parseDouble(val2) / 100.0;
        return String.valueOf(mw);
    }

    public String getMagLocal(HashMap attributes) {
        String value = this.rhead.getStringValue(47);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.indexOf(nullVals[i]) > -1) {
                return null;
            }
            ++i;
        }
        String val2 = value.substring(value.indexOf("."));
        double ml = Double.parseDouble(val2) * 10.0;
        return String.valueOf(ml);
    }

    public String getMagSurface(HashMap attributes) {
        String value = this.rhead.getStringValue(47);
        String[] nullVals = this.rhead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (value.indexOf(nullVals[i]) > -1) {
                return null;
            }
            ++i;
        }
        String val2 = value.substring(0, value.indexOf(".") - 1);
        double ms = Double.parseDouble(val2) / 100.0;
        return String.valueOf(ms);
    }

    public String getSpecialProcessing(HashMap attributes) {
        String val = this.ihead.getStringValue(74);
        String[] nullVals = this.ihead.getNullValue();
        int i = 0;
        while (i < nullVals.length) {
            if (val.indexOf(nullVals[i]) > -1) {
                return null;
            }
            ++i;
        }
        String val2 = val.substring(1, 2);
        if (val2.indexOf("1") > -1) {
            return "special processing";
        }
        return null;
    }

    public String getDomain(HashMap attributes) {
        String val2;
        block7: {
            if (this.volume == 1) {
                return null;
            }
            String val = this.ihead.getStringValue(74);
            String[] nullVals = this.ihead.getNullValue();
            int i = 0;
            while (i < nullVals.length) {
                if (val.indexOf(nullVals[i]) > -1) {
                    return null;
                }
                ++i;
            }
            try {
                val2 = val.substring(0, 1);
                if (val2.indexOf(1) <= -1) break block7;
                return "Time";
            }
            catch (Exception e) {
                return "Frequency";
            }
        }
        if (val2.indexOf(2) > -1) {
            return "Frequency";
        }
        return "Frequency";
    }
}

