/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.poi.util.LittleEndianConsts;

public class LittleEndian
implements LittleEndianConsts {
    private LittleEndian() {
    }

    public static short getShort(byte[] data2, int offset) {
        return (short)LittleEndian.getNumber(data2, offset, 2);
    }

    public static int getUShort(byte[] data2, int offset) {
        int num = (int)LittleEndian.getNumber(data2, offset, 2);
        int retNum = num < 0 ? 65536 + num : num;
        return retNum;
    }

    public static short[] getSimpleShortArray(byte[] data2, int offset, int size) {
        short[] results = new short[size];
        for (int i = 0; i < size; ++i) {
            results[i] = LittleEndian.getShort(data2, offset + 2 + i * 2);
        }
        return results;
    }

    public static short[] getShortArray(byte[] data2, int offset) {
        short size = (short)LittleEndian.getNumber(data2, offset, 2);
        short[] results = LittleEndian.getSimpleShortArray(data2, offset, size);
        return results;
    }

    public static short getShort(byte[] data2) {
        return LittleEndian.getShort(data2, 0);
    }

    public static int getUShort(byte[] data2) {
        return LittleEndian.getUShort(data2, 0);
    }

    public static int getInt(byte[] data2, int offset) {
        return (int)LittleEndian.getNumber(data2, offset, 4);
    }

    public static int getInt(byte[] data2) {
        return LittleEndian.getInt(data2, 0);
    }

    public static long getUInt(byte[] data2, int offset) {
        int num = (int)LittleEndian.getNumber(data2, offset, 4);
        long retNum = num < 0 ? 0x100000000L + (long)num : (long)num;
        return retNum;
    }

    public static long getUInt(byte[] data2) {
        return LittleEndian.getUInt(data2, 0);
    }

    public static long getLong(byte[] data2, int offset) {
        return LittleEndian.getNumber(data2, offset, 8);
    }

    public static long getLong(byte[] data2) {
        return LittleEndian.getLong(data2, 0);
    }

    public static double getDouble(byte[] data2, int offset) {
        return Double.longBitsToDouble(LittleEndian.getNumber(data2, offset, 8));
    }

    public static double getDouble(byte[] data2) {
        return LittleEndian.getDouble(data2, 0);
    }

    public static void putShort(byte[] data2, int offset, short value) {
        LittleEndian.putNumber(data2, offset, value, 2);
    }

    public static void putShortArray(byte[] data2, int offset, short[] value) {
        LittleEndian.putNumber(data2, offset, value.length, 2);
        for (int i = 0; i < value.length; ++i) {
            LittleEndian.putNumber(data2, offset + 2 + i * 2, value[i], 2);
        }
    }

    public static void putUShort(byte[] data2, int offset, int value) {
        LittleEndian.putNumber(data2, offset, value, 2);
    }

    public static void putShort(byte[] data2, short value) {
        LittleEndian.putShort(data2, 0, value);
    }

    public static void putInt(byte[] data2, int offset, int value) {
        LittleEndian.putNumber(data2, offset, value, 4);
    }

    public static void putInt(byte[] data2, int value) {
        LittleEndian.putInt(data2, 0, value);
    }

    public static void putLong(byte[] data2, int offset, long value) {
        LittleEndian.putNumber(data2, offset, value, 8);
    }

    public static void putLong(byte[] data2, long value) {
        LittleEndian.putLong(data2, 0, value);
    }

    public static void putDouble(byte[] data2, int offset, double value) {
        if (Double.isNaN(value)) {
            LittleEndian.putNumber(data2, offset, -276939487313920L, 8);
        } else {
            LittleEndian.putNumber(data2, offset, Double.doubleToLongBits(value), 8);
        }
    }

    public static void putDouble(byte[] data2, double value) {
        LittleEndian.putDouble(data2, 0, value);
    }

    public static short readShort(InputStream stream) throws IOException, BufferUnderrunException {
        return LittleEndian.getShort(LittleEndian.readFromStream(stream, 2));
    }

    public static int readInt(InputStream stream) throws IOException, BufferUnderrunException {
        return LittleEndian.getInt(LittleEndian.readFromStream(stream, 4));
    }

    public static long readLong(InputStream stream) throws IOException, BufferUnderrunException {
        return LittleEndian.getLong(LittleEndian.readFromStream(stream, 8));
    }

    public static byte[] readFromStream(InputStream stream, int size) throws IOException, BufferUnderrunException {
        byte[] buffer = new byte[size];
        int count = stream.read(buffer);
        if (count == -1) {
            Arrays.fill(buffer, (byte)0);
        } else if (count != size) {
            throw new BufferUnderrunException();
        }
        return buffer;
    }

    private static long getNumber(byte[] data2, int offset, int size) {
        long result = 0L;
        for (int j = offset + size - 1; j >= offset; --j) {
            result <<= 8;
            result |= (long)(0xFF & data2[j]);
        }
        return result;
    }

    private static void putNumber(byte[] data2, int offset, long value, int size) {
        int limit = size + offset;
        long v = value;
        for (int j = offset; j < limit; ++j) {
            data2[j] = (byte)(v & 0xFFL);
            v >>= 8;
        }
    }

    public static int ubyteToInt(byte b) {
        return (b & 0x80) == 0 ? b : (b & 0x7F) + 128;
    }

    public static int getUnsignedByte(byte[] data2, int offset) {
        return (int)LittleEndian.getNumber(data2, offset, 1);
    }

    public static int getUnsignedByte(byte[] data2) {
        return LittleEndian.getUnsignedByte(data2, 0);
    }

    public static byte[] getByteArray(byte[] data2, int offset, int size) {
        byte[] copy = new byte[size];
        System.arraycopy(data2, offset, copy, 0, size);
        return copy;
    }

    public static class BufferUnderrunException
    extends IOException {
        BufferUnderrunException() {
            super("buffer underrun");
        }
    }
}

