/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.util.FixedField;
import org.apache.poi.util.LittleEndian;

public class IntegerField
implements FixedField {
    private int _value;
    private final int _offset;

    public IntegerField(int offset) throws ArrayIndexOutOfBoundsException {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("negative offset");
        }
        this._offset = offset;
    }

    public IntegerField(int offset, int value) throws ArrayIndexOutOfBoundsException {
        this(offset);
        this.set(value);
    }

    public IntegerField(int offset, byte[] data2) throws ArrayIndexOutOfBoundsException {
        this(offset);
        this.readFromBytes(data2);
    }

    public IntegerField(int offset, int value, byte[] data2) throws ArrayIndexOutOfBoundsException {
        this(offset);
        this.set(value, data2);
    }

    public int get() {
        return this._value;
    }

    public void set(int value) {
        this._value = value;
    }

    public void set(int value, byte[] data2) throws ArrayIndexOutOfBoundsException {
        this._value = value;
        this.writeToBytes(data2);
    }

    public void readFromBytes(byte[] data2) throws ArrayIndexOutOfBoundsException {
        this._value = LittleEndian.getInt(data2, this._offset);
    }

    public void readFromStream(InputStream stream) throws IOException, LittleEndian.BufferUnderrunException {
        this._value = LittleEndian.readInt(stream);
    }

    public void writeToBytes(byte[] data2) throws ArrayIndexOutOfBoundsException {
        LittleEndian.putInt(data2, this._offset, this._value);
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

