/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.RootProperty;
import org.apache.poi.poifs.storage.ListManagedBlock;

class PropertyFactory {
    private PropertyFactory() {
    }

    static List convertToProperties(ListManagedBlock[] blocks) throws IOException {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (int j = 0; j < blocks.length; ++j) {
            byte[] data2 = blocks[j].getData();
            int property_count = data2.length / 128;
            int offset = 0;
            for (int k = 0; k < property_count; ++k) {
                switch (data2[offset + 66]) {
                    case 1: {
                        properties.add(new DirectoryProperty(properties.size(), data2, offset));
                        break;
                    }
                    case 2: {
                        properties.add(new DocumentProperty(properties.size(), data2, offset));
                        break;
                    }
                    case 5: {
                        properties.add(new RootProperty(properties.size(), data2, offset));
                        break;
                    }
                    default: {
                        properties.add(null);
                    }
                }
                offset += 128;
            }
        }
        return properties;
    }
}

