/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class UnknownRecord
extends Record {
    private short sid = 0;
    private byte[] thedata = null;

    public UnknownRecord() {
    }

    public UnknownRecord(short id, short size, byte[] data2) {
        this.sid = id;
        this.thedata = data2;
    }

    public UnknownRecord(short id, short size, byte[] data2, int offset) {
        this.sid = id;
        this.thedata = new byte[size];
        System.arraycopy(data2, offset, this.thedata, 0, size);
    }

    public int serialize(int offset, byte[] data2) {
        if (this.thedata == null) {
            this.thedata = new byte[0];
        }
        LittleEndian.putShort(data2, 0 + offset, this.sid);
        LittleEndian.putShort(data2, 2 + offset, (short)this.thedata.length);
        if (this.thedata.length > 0) {
            System.arraycopy(this.thedata, 0, data2, 4 + offset, this.thedata.length);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 4;
        if (this.thedata != null) {
            retval += this.thedata.length;
        }
        return retval;
    }

    protected void fillFields(byte[] data2, short sid) {
        this.sid = sid;
        this.thedata = data2;
    }

    protected void validateSid(short id) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[UNKNOWN RECORD:" + Integer.toHexString(this.sid) + "]\n");
        buffer.append("    .id        = ").append(Integer.toHexString(this.sid)).append("\n");
        buffer.append("[/UNKNOWN RECORD]\n");
        return buffer.toString();
    }

    public short getSid() {
        return this.sid;
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        throw new RecordFormatException("Unknown record cannot be constructed via offset -- we need a copy of the data");
    }

    public Object clone() {
        UnknownRecord rec = new UnknownRecord();
        rec.sid = this.sid;
        rec.thedata = this.thedata;
        return rec;
    }
}

