/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class UnitsRecord
extends Record {
    public static final short sid = 4097;
    private short field_1_units;

    public UnitsRecord() {
    }

    public UnitsRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public UnitsRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 4097) {
            throw new RecordFormatException("Not a Units record");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        int pos = 0;
        this.field_1_units = LittleEndian.getShort(data2, pos + 0 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[UNITS]\n");
        buffer.append("    .units                = ").append("0x").append(HexDump.toHex(this.getUnits())).append(" (").append(this.getUnits()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/UNITS]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        int pos = 0;
        LittleEndian.putShort(data2, 0 + offset, (short)4097);
        LittleEndian.putShort(data2, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data2, 4 + offset + pos, this.field_1_units);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4097;
    }

    public Object clone() {
        UnitsRecord rec = new UnitsRecord();
        rec.field_1_units = this.field_1_units;
        return rec;
    }

    public short getUnits() {
        return this.field_1_units;
    }

    public void setUnits(short field_1_units) {
        this.field_1_units = field_1_units;
    }
}

