/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class TickRecord
extends Record {
    public static final short sid = 4126;
    private byte field_1_majorTickType;
    private byte field_2_minorTickType;
    private byte field_3_labelPosition;
    private byte field_4_background;
    private int field_5_labelColorRgb;
    private short field_6_zero1;
    private short field_7_zero2;
    private short field_8_options;
    private BitField autoTextColor = new BitField(1);
    private BitField autoTextBackground = new BitField(2);
    private BitField rotation = new BitField(28);
    private BitField autorotate = new BitField(32);
    private short field_9_tickColor;
    private short field_10_zero3;

    public TickRecord() {
    }

    public TickRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public TickRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 4126) {
            throw new RecordFormatException("Not a Tick record");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        int pos = 0;
        this.field_1_majorTickType = data2[pos + 0 + offset];
        this.field_2_minorTickType = data2[pos + 1 + offset];
        this.field_3_labelPosition = data2[pos + 2 + offset];
        this.field_4_background = data2[pos + 3 + offset];
        this.field_5_labelColorRgb = LittleEndian.getInt(data2, pos + 4 + offset);
        this.field_6_zero1 = LittleEndian.getShort(data2, pos + 8 + offset);
        this.field_7_zero2 = LittleEndian.getShort(data2, pos + 16 + offset);
        this.field_8_options = LittleEndian.getShort(data2, pos + 24 + offset);
        this.field_9_tickColor = LittleEndian.getShort(data2, pos + 26 + offset);
        this.field_10_zero3 = LittleEndian.getShort(data2, pos + 28 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TICK]\n");
        buffer.append("    .majorTickType        = ").append("0x").append(HexDump.toHex(this.getMajorTickType())).append(" (").append(this.getMajorTickType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .minorTickType        = ").append("0x").append(HexDump.toHex(this.getMinorTickType())).append(" (").append(this.getMinorTickType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .labelPosition        = ").append("0x").append(HexDump.toHex(this.getLabelPosition())).append(" (").append(this.getLabelPosition()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .background           = ").append("0x").append(HexDump.toHex(this.getBackground())).append(" (").append(this.getBackground()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .labelColorRgb        = ").append("0x").append(HexDump.toHex(this.getLabelColorRgb())).append(" (").append(this.getLabelColorRgb()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .zero1                = ").append("0x").append(HexDump.toHex(this.getZero1())).append(" (").append(this.getZero1()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .zero2                = ").append("0x").append(HexDump.toHex(this.getZero2())).append(" (").append(this.getZero2()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .autoTextColor            = ").append(this.isAutoTextColor()).append('\n');
        buffer.append("         .autoTextBackground       = ").append(this.isAutoTextBackground()).append('\n');
        buffer.append("         .rotation                 = ").append(this.getRotation()).append('\n');
        buffer.append("         .autorotate               = ").append(this.isAutorotate()).append('\n');
        buffer.append("    .tickColor            = ").append("0x").append(HexDump.toHex(this.getTickColor())).append(" (").append(this.getTickColor()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .zero3                = ").append("0x").append(HexDump.toHex(this.getZero3())).append(" (").append(this.getZero3()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/TICK]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        int pos = 0;
        LittleEndian.putShort(data2, 0 + offset, (short)4126);
        LittleEndian.putShort(data2, 2 + offset, (short)(this.getRecordSize() - 4));
        data2[4 + offset + pos] = this.field_1_majorTickType;
        data2[5 + offset + pos] = this.field_2_minorTickType;
        data2[6 + offset + pos] = this.field_3_labelPosition;
        data2[7 + offset + pos] = this.field_4_background;
        LittleEndian.putInt(data2, 8 + offset + pos, this.field_5_labelColorRgb);
        LittleEndian.putShort(data2, 12 + offset + pos, this.field_6_zero1);
        LittleEndian.putShort(data2, 20 + offset + pos, this.field_7_zero2);
        LittleEndian.putShort(data2, 28 + offset + pos, this.field_8_options);
        LittleEndian.putShort(data2, 30 + offset + pos, this.field_9_tickColor);
        LittleEndian.putShort(data2, 32 + offset + pos, this.field_10_zero3);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 34;
    }

    public short getSid() {
        return 4126;
    }

    public Object clone() {
        TickRecord rec = new TickRecord();
        rec.field_1_majorTickType = this.field_1_majorTickType;
        rec.field_2_minorTickType = this.field_2_minorTickType;
        rec.field_3_labelPosition = this.field_3_labelPosition;
        rec.field_4_background = this.field_4_background;
        rec.field_5_labelColorRgb = this.field_5_labelColorRgb;
        rec.field_6_zero1 = this.field_6_zero1;
        rec.field_7_zero2 = this.field_7_zero2;
        rec.field_8_options = this.field_8_options;
        rec.field_9_tickColor = this.field_9_tickColor;
        rec.field_10_zero3 = this.field_10_zero3;
        return rec;
    }

    public byte getMajorTickType() {
        return this.field_1_majorTickType;
    }

    public void setMajorTickType(byte field_1_majorTickType) {
        this.field_1_majorTickType = field_1_majorTickType;
    }

    public byte getMinorTickType() {
        return this.field_2_minorTickType;
    }

    public void setMinorTickType(byte field_2_minorTickType) {
        this.field_2_minorTickType = field_2_minorTickType;
    }

    public byte getLabelPosition() {
        return this.field_3_labelPosition;
    }

    public void setLabelPosition(byte field_3_labelPosition) {
        this.field_3_labelPosition = field_3_labelPosition;
    }

    public byte getBackground() {
        return this.field_4_background;
    }

    public void setBackground(byte field_4_background) {
        this.field_4_background = field_4_background;
    }

    public int getLabelColorRgb() {
        return this.field_5_labelColorRgb;
    }

    public void setLabelColorRgb(int field_5_labelColorRgb) {
        this.field_5_labelColorRgb = field_5_labelColorRgb;
    }

    public short getZero1() {
        return this.field_6_zero1;
    }

    public void setZero1(short field_6_zero1) {
        this.field_6_zero1 = field_6_zero1;
    }

    public short getZero2() {
        return this.field_7_zero2;
    }

    public void setZero2(short field_7_zero2) {
        this.field_7_zero2 = field_7_zero2;
    }

    public short getOptions() {
        return this.field_8_options;
    }

    public void setOptions(short field_8_options) {
        this.field_8_options = field_8_options;
    }

    public short getTickColor() {
        return this.field_9_tickColor;
    }

    public void setTickColor(short field_9_tickColor) {
        this.field_9_tickColor = field_9_tickColor;
    }

    public short getZero3() {
        return this.field_10_zero3;
    }

    public void setZero3(short field_10_zero3) {
        this.field_10_zero3 = field_10_zero3;
    }

    public void setAutoTextColor(boolean value) {
        this.field_8_options = this.autoTextColor.setShortBoolean(this.field_8_options, value);
    }

    public boolean isAutoTextColor() {
        return this.autoTextColor.isSet(this.field_8_options);
    }

    public void setAutoTextBackground(boolean value) {
        this.field_8_options = this.autoTextBackground.setShortBoolean(this.field_8_options, value);
    }

    public boolean isAutoTextBackground() {
        return this.autoTextBackground.isSet(this.field_8_options);
    }

    public void setRotation(short value) {
        this.field_8_options = this.rotation.setShortValue(this.field_8_options, value);
    }

    public short getRotation() {
        return this.rotation.getShortValue(this.field_8_options);
    }

    public void setAutorotate(boolean value) {
        this.field_8_options = this.autorotate.setShortBoolean(this.field_8_options, value);
    }

    public boolean isAutorotate() {
        return this.autorotate.isSet(this.field_8_options);
    }
}

