/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class TabIdRecord
extends Record {
    public static final short sid = 317;
    public short[] field_1_tabids;

    public TabIdRecord() {
    }

    public TabIdRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public TabIdRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 317) {
            throw new RecordFormatException("NOT A TABID RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_tabids = new short[size / 2];
        for (int k = 0; k < this.field_1_tabids.length; ++k) {
            this.field_1_tabids[k] = LittleEndian.getShort(data2, k * 2 + offset);
        }
    }

    public void setTabIdArray(short[] array) {
        this.field_1_tabids = array;
    }

    public short[] getTabIdArray() {
        return this.field_1_tabids;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TABID]\n");
        buffer.append("    .elements        = ").append(this.field_1_tabids.length).append("\n");
        for (int k = 0; k < this.field_1_tabids.length; ++k) {
            buffer.append("    .element_" + k + "       = ").append(this.field_1_tabids[k]).append("\n");
        }
        buffer.append("[/TABID]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        short[] tabids = this.getTabIdArray();
        short length = (short)(tabids.length * 2);
        int byteoffset = 4;
        LittleEndian.putShort(data2, 0 + offset, (short)317);
        LittleEndian.putShort(data2, 2 + offset, length);
        for (int k = 0; k < length / 2; ++k) {
            LittleEndian.putShort(data2, byteoffset + offset, tabids[k]);
            byteoffset += 2;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.getTabIdArray().length * 2;
    }

    public short getSid() {
        return 317;
    }
}

