/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class SeriesToChartGroupRecord
extends Record {
    public static final short sid = 4165;
    private short field_1_chartGroupIndex;

    public SeriesToChartGroupRecord() {
    }

    public SeriesToChartGroupRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public SeriesToChartGroupRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 4165) {
            throw new RecordFormatException("Not a SeriesToChartGroup record");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        int pos = 0;
        this.field_1_chartGroupIndex = LittleEndian.getShort(data2, pos + 0 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SeriesToChartGroup]\n");
        buffer.append("    .chartGroupIndex      = ").append("0x").append(HexDump.toHex(this.getChartGroupIndex())).append(" (").append(this.getChartGroupIndex()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/SeriesToChartGroup]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        int pos = 0;
        LittleEndian.putShort(data2, 0 + offset, (short)4165);
        LittleEndian.putShort(data2, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data2, 4 + offset + pos, this.field_1_chartGroupIndex);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4165;
    }

    public Object clone() {
        SeriesToChartGroupRecord rec = new SeriesToChartGroupRecord();
        rec.field_1_chartGroupIndex = this.field_1_chartGroupIndex;
        return rec;
    }

    public short getChartGroupIndex() {
        return this.field_1_chartGroupIndex;
    }

    public void setChartGroupIndex(short field_1_chartGroupIndex) {
        this.field_1_chartGroupIndex = field_1_chartGroupIndex;
    }
}

