/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class SeriesLabelsRecord
extends Record {
    public static final short sid = 4108;
    private short field_1_formatFlags;
    private BitField showActual = new BitField(1);
    private BitField showPercent = new BitField(2);
    private BitField labelAsPercentage = new BitField(4);
    private BitField smoothedLine = new BitField(8);
    private BitField showLabel = new BitField(16);
    private BitField showBubbleSizes = new BitField(32);

    public SeriesLabelsRecord() {
    }

    public SeriesLabelsRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public SeriesLabelsRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 4108) {
            throw new RecordFormatException("Not a SeriesLabels record");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        int pos = 0;
        this.field_1_formatFlags = LittleEndian.getShort(data2, pos + 0 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ATTACHEDLABEL]\n");
        buffer.append("    .formatFlags          = ").append("0x").append(HexDump.toHex(this.getFormatFlags())).append(" (").append(this.getFormatFlags()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .showActual               = ").append(this.isShowActual()).append('\n');
        buffer.append("         .showPercent              = ").append(this.isShowPercent()).append('\n');
        buffer.append("         .labelAsPercentage        = ").append(this.isLabelAsPercentage()).append('\n');
        buffer.append("         .smoothedLine             = ").append(this.isSmoothedLine()).append('\n');
        buffer.append("         .showLabel                = ").append(this.isShowLabel()).append('\n');
        buffer.append("         .showBubbleSizes          = ").append(this.isShowBubbleSizes()).append('\n');
        buffer.append("[/ATTACHEDLABEL]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        int pos = 0;
        LittleEndian.putShort(data2, 0 + offset, (short)4108);
        LittleEndian.putShort(data2, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data2, 4 + offset + pos, this.field_1_formatFlags);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4108;
    }

    public Object clone() {
        SeriesLabelsRecord rec = new SeriesLabelsRecord();
        rec.field_1_formatFlags = this.field_1_formatFlags;
        return rec;
    }

    public short getFormatFlags() {
        return this.field_1_formatFlags;
    }

    public void setFormatFlags(short field_1_formatFlags) {
        this.field_1_formatFlags = field_1_formatFlags;
    }

    public void setShowActual(boolean value) {
        this.field_1_formatFlags = this.showActual.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isShowActual() {
        return this.showActual.isSet(this.field_1_formatFlags);
    }

    public void setShowPercent(boolean value) {
        this.field_1_formatFlags = this.showPercent.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isShowPercent() {
        return this.showPercent.isSet(this.field_1_formatFlags);
    }

    public void setLabelAsPercentage(boolean value) {
        this.field_1_formatFlags = this.labelAsPercentage.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isLabelAsPercentage() {
        return this.labelAsPercentage.isSet(this.field_1_formatFlags);
    }

    public void setSmoothedLine(boolean value) {
        this.field_1_formatFlags = this.smoothedLine.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isSmoothedLine() {
        return this.smoothedLine.isSet(this.field_1_formatFlags);
    }

    public void setShowLabel(boolean value) {
        this.field_1_formatFlags = this.showLabel.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isShowLabel() {
        return this.showLabel.isSet(this.field_1_formatFlags);
    }

    public void setShowBubbleSizes(boolean value) {
        this.field_1_formatFlags = this.showBubbleSizes.setShortBoolean(this.field_1_formatFlags, value);
    }

    public boolean isShowBubbleSizes() {
        return this.showBubbleSizes.isSet(this.field_1_formatFlags);
    }
}

