/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.ExtSSTRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.SSTDeserializer;
import org.apache.poi.hssf.record.SSTRecordSizeCalculator;
import org.apache.poi.hssf.record.SSTSerializer;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.BinaryTree;
import org.apache.poi.util.LittleEndian;

public class SSTRecord
extends Record {
    static final int MAX_RECORD_SIZE = 8228;
    static final int STD_RECORD_OVERHEAD = 4;
    static final int SST_RECORD_OVERHEAD = 12;
    static final int MAX_DATA_SPACE = 8216;
    static final int STRING_MINIMAL_OVERHEAD = 3;
    public static final short sid = 252;
    private int field_1_num_strings;
    private int field_2_num_unique_strings;
    private BinaryTree field_3_strings;
    private List _record_lengths = null;
    private SSTDeserializer deserializer;
    int[] bucketAbsoluteOffsets;
    int[] bucketRelativeOffsets;

    public SSTRecord() {
        this.field_1_num_strings = 0;
        this.field_2_num_unique_strings = 0;
        this.field_3_strings = new BinaryTree();
        this.deserializer = new SSTDeserializer(this.field_3_strings);
    }

    public SSTRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public SSTRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    public int addString(String string) {
        int rval;
        if (string == null) {
            rval = this.addString("", false);
        } else {
            boolean useUTF16 = false;
            int strlen = string.length();
            for (int j = 0; j < strlen; ++j) {
                if (string.charAt(j) <= '\u00ff') continue;
                useUTF16 = true;
                break;
            }
            rval = this.addString(string, useUTF16);
        }
        return rval;
    }

    public int addString(String string, boolean useUTF16) {
        int rval;
        ++this.field_1_num_strings;
        String str = string == null ? "" : string;
        UnicodeString ucs = new UnicodeString();
        ucs.setString(str);
        ucs.setCharCount((short)str.length());
        ucs.setOptionFlags((byte)(useUTF16 ? 1 : 0));
        Integer integer = (Integer)this.field_3_strings.getKeyForValue(ucs);
        if (integer != null) {
            rval = integer;
        } else {
            rval = this.field_3_strings.size();
            ++this.field_2_num_unique_strings;
            integer = new Integer(rval);
            SSTDeserializer.addToStringTable(this.field_3_strings, integer, ucs);
        }
        return rval;
    }

    public int getNumStrings() {
        return this.field_1_num_strings;
    }

    public int getNumUniqueStrings() {
        return this.field_2_num_unique_strings;
    }

    public void setNumStrings(int count) {
        this.field_1_num_strings = count;
    }

    public void setNumUniqueStrings(int count) {
        this.field_2_num_unique_strings = count;
    }

    public String getString(int id) {
        return ((UnicodeString)this.field_3_strings.get(new Integer(id))).getString();
    }

    public boolean isString16bit(int id) {
        UnicodeString unicodeString = (UnicodeString)this.field_3_strings.get(new Integer(id));
        return (unicodeString.getOptionFlags() & 1) == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SST]\n");
        buffer.append("    .numstrings     = ").append(Integer.toHexString(this.getNumStrings())).append("\n");
        buffer.append("    .uniquestrings  = ").append(Integer.toHexString(this.getNumUniqueStrings())).append("\n");
        for (int k = 0; k < this.field_3_strings.size(); ++k) {
            buffer.append("    .string_" + k + "      = ").append(this.field_3_strings.get(new Integer(k)).toString()).append("\n");
        }
        buffer.append("[/SST]\n");
        return buffer.toString();
    }

    public short getSid() {
        return 252;
    }

    public int hashCode() {
        return this.field_2_num_unique_strings;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SSTRecord other = (SSTRecord)o;
        return this.field_1_num_strings == other.field_1_num_strings && this.field_2_num_unique_strings == other.field_2_num_unique_strings && this.field_3_strings.equals(other.field_3_strings);
    }

    protected void validateSid(short id) throws RecordFormatException {
        if (id != 252) {
            throw new RecordFormatException("NOT An SST RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_num_strings = LittleEndian.getInt(data2, 0 + offset);
        this.field_2_num_unique_strings = LittleEndian.getInt(data2, 4 + offset);
        this.field_3_strings = new BinaryTree();
        this.deserializer = new SSTDeserializer(this.field_3_strings);
        this.deserializer.manufactureStrings(data2, 8 + offset);
    }

    Iterator getStrings() {
        return this.field_3_strings.values().iterator();
    }

    int countStrings() {
        return this.field_3_strings.size();
    }

    public int serialize(int offset, byte[] data2) {
        SSTSerializer serializer = new SSTSerializer(this._record_lengths, this.field_3_strings, this.getNumStrings(), this.getNumUniqueStrings());
        int bytes = serializer.serialize(this.getRecordSize(), offset, data2);
        this.bucketAbsoluteOffsets = serializer.getBucketAbsoluteOffsets();
        this.bucketRelativeOffsets = serializer.getBucketRelativeOffsets();
        return bytes;
    }

    public int getRecordSize() {
        SSTRecordSizeCalculator calculator = new SSTRecordSizeCalculator(this.field_3_strings);
        int recordSize = calculator.getRecordSize();
        this._record_lengths = calculator.getRecordLengths();
        return recordSize;
    }

    SSTDeserializer getDeserializer() {
        return this.deserializer;
    }

    public void processContinueRecord(byte[] record) {
        this.deserializer.processContinueRecord(record);
    }

    public ExtSSTRecord createExtSSTRecord(int sstOffset) {
        if (this.bucketAbsoluteOffsets == null || this.bucketAbsoluteOffsets == null) {
            throw new IllegalStateException("SST record has not yet been serialized.");
        }
        ExtSSTRecord extSST = new ExtSSTRecord();
        extSST.setNumStringsPerBucket((short)8);
        int[] absoluteOffsets = (int[])this.bucketAbsoluteOffsets.clone();
        int[] relativeOffsets = (int[])this.bucketRelativeOffsets.clone();
        int i = 0;
        while (i < absoluteOffsets.length) {
            int n = i++;
            absoluteOffsets[n] = absoluteOffsets[n] + sstOffset;
        }
        extSST.setBucketOffsets(absoluteOffsets, relativeOffsets);
        return extSST;
    }

    public int calcExtSSTRecordSize() {
        return ExtSSTRecord.getRecordSizeForStrings(this.field_3_strings.size());
    }
}

