/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class RowRecord
extends Record
implements Comparable {
    public static final short sid = 520;
    private int field_1_row_number;
    private short field_2_first_col;
    private short field_3_last_col;
    private short field_4_height;
    private short field_5_optimize;
    private short field_6_reserved;
    private short field_7_option_flags;
    private BitField outlineLevel = new BitField(7);
    private BitField colapsed = new BitField(16);
    private BitField zeroHeight = new BitField(32);
    private BitField badFontHeight = new BitField(64);
    private BitField formatted = new BitField(128);
    private short field_8_xf_index;

    public RowRecord() {
    }

    public RowRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public RowRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 520) {
            throw new RecordFormatException("NOT A valid ROW RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_row_number = LittleEndian.getUShort(data2, 0 + offset);
        this.field_2_first_col = LittleEndian.getShort(data2, 2 + offset);
        this.field_3_last_col = LittleEndian.getShort(data2, 4 + offset);
        this.field_4_height = LittleEndian.getShort(data2, 6 + offset);
        this.field_5_optimize = LittleEndian.getShort(data2, 8 + offset);
        this.field_6_reserved = LittleEndian.getShort(data2, 10 + offset);
        this.field_7_option_flags = LittleEndian.getShort(data2, 12 + offset);
        this.field_8_xf_index = LittleEndian.getShort(data2, 14 + offset);
    }

    public void setRowNumber(int row) {
        this.field_1_row_number = row;
    }

    public void setFirstCol(short col) {
        this.field_2_first_col = col;
    }

    public void setLastCol(short col) {
        this.field_3_last_col = col;
    }

    public void setHeight(short height) {
        this.field_4_height = height;
    }

    public void setOptimize(short optimize) {
        this.field_5_optimize = optimize;
    }

    public void setOptionFlags(short options) {
        this.field_7_option_flags = options;
    }

    public void setOutlineLevel(short ol) {
        this.field_7_option_flags = this.outlineLevel.setShortValue(this.field_7_option_flags, ol);
    }

    public void setColapsed(boolean c) {
        this.field_7_option_flags = this.colapsed.setShortBoolean(this.field_7_option_flags, c);
    }

    public void setZeroHeight(boolean z) {
        this.field_7_option_flags = this.zeroHeight.setShortBoolean(this.field_7_option_flags, z);
    }

    public void setBadFontHeight(boolean f) {
        this.field_7_option_flags = this.badFontHeight.setShortBoolean(this.field_7_option_flags, f);
    }

    public void setFormatted(boolean f) {
        this.field_7_option_flags = this.formatted.setShortBoolean(this.field_7_option_flags, f);
    }

    public void setXFIndex(short index) {
        this.field_8_xf_index = index;
    }

    public int getRowNumber() {
        return this.field_1_row_number;
    }

    public short getFirstCol() {
        return this.field_2_first_col;
    }

    public short getLastCol() {
        return this.field_3_last_col;
    }

    public short getHeight() {
        return this.field_4_height;
    }

    public short getOptimize() {
        return this.field_5_optimize;
    }

    public short getOptionFlags() {
        return this.field_7_option_flags;
    }

    public short getOutlineLevel() {
        return this.outlineLevel.getShortValue(this.field_7_option_flags);
    }

    public boolean getColapsed() {
        return this.colapsed.isSet(this.field_7_option_flags);
    }

    public boolean getZeroHeight() {
        return this.zeroHeight.isSet(this.field_7_option_flags);
    }

    public boolean getBadFontHeight() {
        return this.badFontHeight.isSet(this.field_7_option_flags);
    }

    public boolean getFormatted() {
        return this.formatted.isSet(this.field_7_option_flags);
    }

    public short getXFIndex() {
        return this.field_8_xf_index;
    }

    public boolean isInValueSection() {
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ROW]\n");
        buffer.append("    .rownumber      = ").append(Integer.toHexString(this.getRowNumber())).append("\n");
        buffer.append("    .firstcol       = ").append(Integer.toHexString(this.getFirstCol())).append("\n");
        buffer.append("    .lastcol        = ").append(Integer.toHexString(this.getLastCol())).append("\n");
        buffer.append("    .height         = ").append(Integer.toHexString(this.getHeight())).append("\n");
        buffer.append("    .optimize       = ").append(Integer.toHexString(this.getOptimize())).append("\n");
        buffer.append("    .reserved       = ").append(Integer.toHexString(this.field_6_reserved)).append("\n");
        buffer.append("    .optionflags    = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        buffer.append("        .outlinelvl = ").append(Integer.toHexString(this.getOutlineLevel())).append("\n");
        buffer.append("        .colapsed   = ").append(this.getColapsed()).append("\n");
        buffer.append("        .zeroheight = ").append(this.getZeroHeight()).append("\n");
        buffer.append("        .badfontheig= ").append(this.getBadFontHeight()).append("\n");
        buffer.append("        .formatted  = ").append(this.getFormatted()).append("\n");
        buffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        buffer.append("[/ROW]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)520);
        LittleEndian.putShort(data2, 2 + offset, (short)16);
        LittleEndian.putShort(data2, 4 + offset, (short)this.getRowNumber());
        LittleEndian.putShort(data2, 6 + offset, this.getFirstCol() == -1 ? (short)0 : this.getFirstCol());
        LittleEndian.putShort(data2, 8 + offset, this.getLastCol() == -1 ? (short)0 : this.getLastCol());
        LittleEndian.putShort(data2, 10 + offset, this.getHeight());
        LittleEndian.putShort(data2, 12 + offset, this.getOptimize());
        LittleEndian.putShort(data2, 14 + offset, this.field_6_reserved);
        LittleEndian.putShort(data2, 16 + offset, this.getOptionFlags());
        LittleEndian.putShort(data2, 18 + offset, this.getXFIndex());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20;
    }

    public short getSid() {
        return 520;
    }

    public int compareTo(Object obj) {
        RowRecord loc = (RowRecord)obj;
        if (this.getRowNumber() == loc.getRowNumber()) {
            return 0;
        }
        if (this.getRowNumber() < loc.getRowNumber()) {
            return -1;
        }
        if (this.getRowNumber() > loc.getRowNumber()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RowRecord)) {
            return false;
        }
        RowRecord loc = (RowRecord)obj;
        return this.getRowNumber() == loc.getRowNumber();
    }

    public Object clone() {
        RowRecord rec = new RowRecord();
        rec.field_1_row_number = this.field_1_row_number;
        rec.field_2_first_col = this.field_2_first_col;
        rec.field_3_last_col = this.field_3_last_col;
        rec.field_4_height = this.field_4_height;
        rec.field_5_optimize = this.field_5_optimize;
        rec.field_6_reserved = this.field_6_reserved;
        rec.field_7_option_flags = this.field_7_option_flags;
        rec.field_8_xf_index = this.field_8_xf_index;
        return rec;
    }
}

